/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.util;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;

public class GeomUtilities {
    public static double scaleToFit(Dimension src, Dimension dest) {
        double srcW = src.getWidth();
        double srcH = src.getHeight();
        double destW = dest.getWidth();
        double destH = dest.getHeight();
        double scale = 1.0;
        if (srcW > srcH) {
            if (srcW > destW) {
                scale = destW / srcW;
            }
            if ((srcH *= scale) > destH) {
                scale *= destH / srcH;
            }
        } else {
            if (srcH > destH) {
                scale = destH / srcH;
            }
            if ((srcW *= scale) > destW) {
                scale *= destW / srcW;
            }
        }
        return scale;
    }

    public static Rectangle2D getBounds2D(List shapeList) {
        Shape shape;
        Rectangle2D.Double r = new Rectangle2D.Double();
        if (shapeList.size() > 0 && (shape = (Shape)shapeList.get(0)) != null) {
            ((Rectangle2D)r).setRect(shape.getBounds2D());
        }
        for (int i = 1; i < shapeList.size(); ++i) {
            Shape shape2 = (Shape)shapeList.get(i);
            if (shape2 == null) continue;
            Rectangle2D.union(r, shape2.getBounds(), r);
        }
        return r;
    }

    public static Shape createShape(String pathString) throws IllegalArgumentException {
        AWTPathProducer pathHandler = new AWTPathProducer();
        try {
            PathParser pathParser = new PathParser();
            pathParser.setPathHandler((PathHandler)pathHandler);
            pathParser.parse(pathString);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        return pathHandler.getShape();
    }

    public static List<Point2D> simplify(double tol, List<Point2D> pointList, List<Point2D> simplifyList) {
        List<Point2D> output = simplifyList;
        if (output == null) {
            output = new ArrayList<Point2D>();
        }
        SimplifyImpl impl = new SimplifyImpl();
        impl.simplify(tol, pointList, output);
        return output;
    }

    public static int getPathSegType(String type) {
        int segType = 0;
        if (type.equals("M")) {
            segType = 2;
        } else if (type.equals("m")) {
            segType = 3;
        } else if (type.equalsIgnoreCase("z")) {
            segType = 1;
        } else if (type.equals("A")) {
            segType = 10;
        } else if (type.equals("a")) {
            segType = 11;
        } else if (type.equals("L")) {
            segType = 4;
        } else if (type.equals("l")) {
            segType = 5;
        } else if (type.equals("H")) {
            segType = 12;
        } else if (type.equals("h")) {
            segType = 13;
        } else if (type.equals("V")) {
            segType = 14;
        } else if (type.equals("v")) {
            segType = 15;
        } else if (type.equals("C")) {
            segType = 6;
        } else if (type.equals("c")) {
            segType = 7;
        } else if (type.equals("S")) {
            segType = 16;
        } else if (type.equals("s")) {
            segType = 17;
        } else if (type.equals("Q")) {
            segType = 8;
        } else if (type.equals("q")) {
            segType = 9;
        } else if (type.equals("T")) {
            segType = 18;
        } else if (type.equals("t")) {
            segType = 19;
        }
        return segType;
    }

    private static class SimplifyImpl {
        private SimplifyImpl() {
        }

        public void simplify(double tol, List<Point2D> orig, List<Point2D> simplify) {
            double tol2 = tol * tol;
            int n = orig.size();
            boolean[] mk = new boolean[n];
            for (int c = 0; c < mk.length; ++c) {
                mk[c] = false;
            }
            mk[0] = true;
            mk[n - 1] = true;
            this.simplifyDP(tol2, orig, 0, n - 1, mk);
            int m = 0;
            for (int i = 0; i < n; ++i) {
                if (!mk[i]) continue;
                simplify.add(orig.get(i));
            }
        }

        private void simplifyDP(double tol2, List v, int j, int k, boolean[] mk) {
            if (k <= j + 1) {
                return;
            }
            int maxi = j;
            double maxd2 = 0.0;
            Point2D p0 = (Point2D)v.get(j);
            Point2D p1 = (Point2D)v.get(k);
            Point2D u = this.segmentDirection(p1, p0);
            double cu = this.dot(u, u);
            Point2D.Double pb = new Point2D.Double();
            for (int i = j + 1; i < k; ++i) {
                double dv2;
                Point2D vi = (Point2D)v.get(i);
                Point2D w = this.segmentDirection(vi, p0);
                double cw = this.dot(w, u);
                if (cw <= 0.0) {
                    dv2 = vi.distanceSq(p0.getX(), p0.getY());
                } else if (cw > cu) {
                    dv2 = vi.distanceSq(p1.getX(), p1.getY());
                } else {
                    double b = cu != 0.0 ? cw / cu : 0.0;
                    double x = p0.getX() + b * u.getX();
                    double y = p0.getY() + b * u.getY();
                    ((Point2D)pb).setLocation(x, y);
                    dv2 = vi.distanceSq(((Point2D)pb).getX(), ((Point2D)pb).getY());
                }
                if (!(dv2 > maxd2)) continue;
                maxi = i;
                maxd2 = dv2;
            }
            if (maxd2 > tol2) {
                mk[maxi] = true;
                this.simplifyDP(tol2, v, j, maxi, mk);
                this.simplifyDP(tol2, v, maxi, k, mk);
            }
        }

        private Point2D segmentDirection(Point2D point1, Point2D point2) {
            double x = point1.getX() - point2.getX();
            double y = point1.getY() - point2.getY();
            Point2D.Double point = new Point2D.Double(x, y);
            return point;
        }

        private double dot(Point2D point1, Point2D point2) {
            double d = point1.getX() * point2.getX() + point1.getY() * point2.getY();
            return d;
        }
    }
}

