/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.undo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import kiyut.sketsa.undo.DOMUndoableEdit;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;

public class DOMUndoManager
extends UndoManager {
    protected EventListener domListener;
    protected SVGDocument document;
    protected EventListenerList listenerList = new EventListenerList();
    protected int limit;
    protected List<Entry> undoList;
    protected List<Entry> redoList;
    protected Entry currentEntry;
    protected boolean end = true;
    protected boolean inProgress = false;

    public DOMUndoManager() {
        this(100);
    }

    public DOMUndoManager(int limit) {
        this.limit = limit;
        this.undoList = new ArrayList<Entry>(limit);
        this.redoList = new ArrayList<Entry>(limit);
        this.domListener = new EventListener(){

            @Override
            public void handleEvent(Event evt) {
                DOMUndoManager.this.domNodeHandleEvent(evt);
            }
        };
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.add(UndoableEditListener.class, listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.remove(UndoableEditListener.class, listener);
    }

    protected void fireUndoableEditHappened() {
        Object[] listeners = this.listenerList.getListenerList();
        UndoableEditEvent event = new UndoableEditEvent(this, this.currentEntry.getCompoundEdit());
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != UndoableEditListener.class) continue;
            ((UndoableEditListener)listeners[i + 1]).undoableEditHappened(event);
        }
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
        while (this.undoList.size() > limit) {
            Entry entry = this.undoList.remove(0);
            CompoundEdit edit = entry.getCompoundEdit();
            edit.die();
        }
    }

    public void start(String name) {
        this.end = false;
        ExtendedCompoundEdit compoundEdit = new ExtendedCompoundEdit();
        this.currentEntry = new Entry(name, compoundEdit);
    }

    @Override
    public void end() {
        if (this.end) {
            return;
        }
        this.end = true;
        ExtendedCompoundEdit compoundEdit = (ExtendedCompoundEdit)this.currentEntry.getCompoundEdit();
        compoundEdit.end();
        if (compoundEdit.size() > 0) {
            this.undoList.add(this.currentEntry);
            this.fireUndoableEditHappened();
        }
        this.redoList.clear();
        this.currentEntry = null;
        while (this.undoList.size() > this.limit) {
            Entry entry = this.undoList.remove(0);
            CompoundEdit edit = entry.getCompoundEdit();
            edit.die();
        }
    }

    public void cancel() {
        this.end = true;
        this.currentEntry = null;
    }

    @Override
    public void discardAllEdits() {
        this.undoList.clear();
        this.redoList.clear();
        this.end = true;
        this.inProgress = false;
    }

    @Override
    public boolean canUndo() {
        return !this.undoList.isEmpty();
    }

    @Override
    public boolean canRedo() {
        return !this.redoList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.inProgress = true;
        try {
            Entry entry = this.undoList.remove(this.undoList.size() - 1);
            CompoundEdit edit = entry.getCompoundEdit();
            edit.undo();
            this.redoList.add(entry);
        }
        finally {
            this.inProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.inProgress = true;
        try {
            Entry entry = this.redoList.remove(this.redoList.size() - 1);
            CompoundEdit edit = entry.getCompoundEdit();
            edit.redo();
            this.undoList.add(entry);
        }
        finally {
            this.inProgress = false;
        }
    }

    public void setSVGDocument(SVGDocument doc) {
        SVGDocument old = this.document;
        if (old != null) {
            this.removeDOMEventListener((EventTarget)((Object)old.getDocumentElement()));
        }
        this.document = doc;
        if (this.document != null) {
            this.addDOMEventListener((EventTarget)((Object)this.document.getDocumentElement()));
        }
    }

    @Override
    public synchronized String getUndoOrRedoPresentationName() {
        if (this.end) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    @Override
    public synchronized String getUndoPresentationName() {
        if (this.canUndo()) {
            Entry entry = this.undoList.get(this.undoList.size() - 1);
            return entry.getName();
        }
        return "";
    }

    @Override
    public synchronized String getRedoPresentationName() {
        if (this.canRedo()) {
            Entry entry = this.redoList.get(this.redoList.size() - 1);
            return entry.getName();
        }
        return "";
    }

    protected void addDOMEventListener(EventTarget et) {
        et.addEventListener("DOMAttrModified", this.domListener, false);
        et.addEventListener("DOMNodeInserted", this.domListener, false);
        et.addEventListener("DOMNodeRemoved", this.domListener, false);
        et.addEventListener("DOMCharacterDataModified", this.domListener, false);
    }

    protected void removeDOMEventListener(EventTarget et) {
        et.removeEventListener("DOMAttrModified", this.domListener, false);
        et.removeEventListener("DOMNodeInserted", this.domListener, false);
        et.removeEventListener("DOMNodeRemoved", this.domListener, false);
        et.removeEventListener("DOMCharacterDataModified", this.domListener, false);
    }

    protected void domNodeHandleEvent(Event evt) {
        if (this.end) {
            return;
        }
        if (this.inProgress) {
            return;
        }
        MutationEvent me = (MutationEvent)evt;
        EventTarget et = me.getTarget();
        DOMUndoableEdit edit = new DOMUndoableEdit(me.getType(), (Node)((Object)et), me.getRelatedNode(), me.getPrevValue(), me.getNewValue(), me.getAttrName(), me.getAttrChange());
        CompoundEdit compoundEdit = this.currentEntry.getCompoundEdit();
        compoundEdit.addEdit(edit);
    }

    public class ExtendedCompoundEdit
    extends CompoundEdit {
        public int size() {
            return this.edits.size();
        }
    }

    public class Entry {
        private String name;
        private String shortName;
        private CompoundEdit edit;

        public Entry(String name, CompoundEdit edit) {
            this.name = name;
            this.edit = edit;
            if (name != null) {
                int i = name.indexOf(32);
                this.shortName = i != -1 && i < name.length() - 1 ? name.substring(0, i) + "...  " : name + "  ";
            }
        }

        public String getName() {
            return this.name;
        }

        @Deprecated
        public String getShortName() {
            return this.shortName;
        }

        public CompoundEdit getCompoundEdit() {
            return this.edit;
        }
    }
}

