/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.tool;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kiyut.sketsa.canvas.CanvasBackground;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.io.DefaultFileFilter;
import kiyut.sketsa.util.IOUtilities;
import kiyut.swing.button.ColorChooserButton;

public class CanvasBackgroundPane
extends JPanel {
    private ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.tool.CanvasBackgroundPane");
    private VectorCanvas canvas;
    private JButton browseButton;
    private ButtonGroup buttonGroup1;
    private JButton colorButton;
    private JComboBox horizontalCombo;
    private JRadioButton imageFileRadio;
    private JRadioButton imageNoneRadio;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField pathField;
    private JComboBox verticalCombo;

    public CanvasBackgroundPane() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.imageNoneRadio = new JRadioButton();
        this.imageFileRadio = new JRadioButton();
        this.colorButton = new ColorChooserButton();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.pathField = new JTextField();
        this.browseButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.horizontalCombo = new JComboBox();
        this.verticalCombo = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(this.bundle.getString("CTL_BackgroundOptions.Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.buttonGroup1.add(this.imageNoneRadio);
        this.imageNoneRadio.setText(this.bundle.getString("CTL_ImageNone.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel1.add((Component)this.imageNoneRadio, gridBagConstraints);
        this.buttonGroup1.add(this.imageFileRadio);
        this.imageFileRadio.setText(this.bundle.getString("CTL_ImageFile.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.imageFileRadio, gridBagConstraints);
        this.colorButton.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 5);
        this.jPanel1.add((Component)this.colorButton, gridBagConstraints);
        this.jLabel5.setText(this.bundle.getString("CTL_Color.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(this.bundle.getString("CTL_Image.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.bundle.getString("CTL_FileOptions.Text")), BorderFactory.createEmptyBorder(0, 12, 12, 12)));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel2.setText(this.bundle.getString("CTL_File.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.pathField.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel2.add((Component)this.pathField, gridBagConstraints);
        this.browseButton.setText(this.bundle.getString("CTL_Browse.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.browseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel3.setText(this.bundle.getString("CTL_Horizontal.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel4.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(this.bundle.getString("CTL_Vertical.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.jPanel4.add((Component)this.jLabel4, gridBagConstraints);
        this.horizontalCombo.setMaximumRowCount(3);
        this.horizontalCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Left", "Center", "Right"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.horizontalCombo, gridBagConstraints);
        this.verticalCombo.setMaximumRowCount(3);
        this.verticalCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Top", "Center", "Bottom"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel4.add((Component)this.verticalCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    private void initCustomComponents() {
        this.colorButton.setFocusPainted(false);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CanvasBackgroundPane.this.backgroundImageChanged();
            }
        };
        this.imageNoneRadio.addItemListener(itemListener);
        this.imageFileRadio.addItemListener(itemListener);
        this.imageNoneRadio.setSelected(true);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultFileFilter fileFilter = new DefaultFileFilter();
                fileFilter.addExtension("png");
                fileFilter.addExtension("jpg");
                fileFilter.addExtension("gif");
                fileFilter.setDescription("Image Files");
                JFileChooser fc = IOUtilities.getFileChooser();
                fc.setFileFilter(fileFilter);
                fc.setFileSelectionMode(0);
                int choice = fc.showOpenDialog(CanvasBackgroundPane.this);
                if (choice != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                IOUtilities.setUserDir(file);
                CanvasBackgroundPane.this.pathField.setText(file.toString());
            }
        });
    }

    public String getTitle() {
        return this.bundle.getString("CTL_Title.Text");
    }

    protected void backgroundImageChanged() {
        boolean enabled = false;
        if (this.imageFileRadio.isSelected()) {
            enabled = true;
        }
        this.colorButton.setEnabled(!enabled);
        this.pathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.horizontalCombo.setEnabled(enabled);
        this.verticalCombo.setEnabled(enabled);
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
        ((ColorChooserButton)this.colorButton).setColor(canvas.getBackground());
        CanvasBackground options = canvas.getCanvasBackground();
        if (options.getImage() == null) {
            this.imageNoneRadio.setSelected(true);
        } else {
            this.imageFileRadio.setSelected(true);
        }
        String path = options.getImagePath();
        if (path == null) {
            this.pathField.setText("");
        } else {
            this.pathField.setText(path);
        }
        int align = options.getHorizontalAlignment();
        switch (align) {
            case 2: {
                this.horizontalCombo.setSelectedIndex(0);
                break;
            }
            case 4: {
                this.horizontalCombo.setSelectedIndex(2);
                break;
            }
            default: {
                this.horizontalCombo.setSelectedIndex(1);
            }
        }
        align = options.getVerticalAlignment();
        switch (align) {
            case 1: {
                this.verticalCombo.setSelectedIndex(0);
                break;
            }
            case 3: {
                this.verticalCombo.setSelectedIndex(2);
                break;
            }
            default: {
                this.verticalCombo.setSelectedIndex(1);
            }
        }
    }

    public void updateVectorCanvas() {
        int align;
        this.canvas.setBackground(((ColorChooserButton)this.colorButton).getColor());
        CanvasBackground options = this.canvas.getCanvasBackground();
        if (this.imageNoneRadio.isSelected()) {
            options.setImage(null);
            options.setImagePath(null);
            options.setVisible(false);
            this.canvas.repaint();
            return;
        }
        String path = this.pathField.getText().trim();
        File file = new File(path);
        BufferedImage image = null;
        try {
            ImageReader reader;
            FileImageInputStream iis = new FileImageInputStream(file);
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            ImageReader imageReader = reader = it.hasNext() ? it.next() : null;
            if (reader != null) {
                reader.setInput(iis);
                image = reader.read(0);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.bundle.getString("title.text"), 0);
            return;
        }
        if (image != null) {
            options.setImage(image);
            options.setImagePath(path);
        } else {
            options.setImage(null);
            options.setImagePath(null);
        }
        int index = this.horizontalCombo.getSelectedIndex();
        switch (index) {
            case 0: {
                align = 2;
                break;
            }
            case 2: {
                align = 4;
                break;
            }
            default: {
                align = 0;
            }
        }
        options.setHorizontalAlignment(align);
        index = this.verticalCombo.getSelectedIndex();
        switch (index) {
            case 0: {
                align = 1;
                break;
            }
            case 2: {
                align = 3;
                break;
            }
            default: {
                align = 0;
            }
        }
        options.setVerticalAlignment(align);
        options.setVisible(true);
        this.canvas.repaint();
    }
}

