/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.util.prefs.Preferences;
import kiyut.sketsa.options.AbstractOptions;

public class GeneralOptions
extends AbstractOptions {
    private static GeneralOptions instance = new GeneralOptions();
    public static final String UNDO_LIMIT_PROPERTY = "undo_limit";
    public static final String DEFAULT_SVG_WIDTH_PROPERTY = "default_svg_width";
    public static final String DEFAULT_SVG_HEIGHT_PROPERTY = "default_svg_height";
    private float defaultSVGWidth;
    private float defaultSVGHeight;
    private int undoLimit;

    public static GeneralOptions getInstance() {
        return instance;
    }

    private GeneralOptions() {
        this.nodeName = "general";
        Preferences prefs = this.getPreferences();
        this.defaultSVGWidth = prefs.getFloat(DEFAULT_SVG_WIDTH_PROPERTY, 600.0f);
        this.defaultSVGHeight = prefs.getFloat(DEFAULT_SVG_HEIGHT_PROPERTY, 600.0f);
        this.undoLimit = prefs.getInt(UNDO_LIMIT_PROPERTY, 100);
    }

    public void setDefaultSVGWidth(float width) {
        float old = this.defaultSVGWidth;
        this.defaultSVGWidth = width;
        this.firePropertyChange(DEFAULT_SVG_WIDTH_PROPERTY, Float.valueOf(old), Float.valueOf(this.defaultSVGWidth));
        this.getPreferences().putFloat(DEFAULT_SVG_WIDTH_PROPERTY, this.defaultSVGWidth);
    }

    public float getDefaultSVGWidth() {
        return this.defaultSVGWidth;
    }

    public void setDefaultSVGHeight(float height) {
        float old = this.defaultSVGHeight;
        this.defaultSVGHeight = height;
        this.firePropertyChange(DEFAULT_SVG_HEIGHT_PROPERTY, Float.valueOf(old), Float.valueOf(this.defaultSVGHeight));
        this.getPreferences().putFloat(DEFAULT_SVG_HEIGHT_PROPERTY, this.defaultSVGHeight);
    }

    public float getDefaultSVGHeight() {
        return this.defaultSVGHeight;
    }

    public void setUndoLimit(int limit) {
        int old = this.undoLimit;
        this.undoLimit = limit;
        this.firePropertyChange(UNDO_LIMIT_PROPERTY, old, this.undoLimit);
        this.getPreferences().putInt(UNDO_LIMIT_PROPERTY, this.undoLimit);
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }
}

