/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import kiyut.sketsa.options.AbstractOptions;

public class FontSetOptions
extends AbstractOptions {
    private static FontSetOptions instance = new FontSetOptions();
    public static final String FONT_SET_SIZE_PROPERTY = "font_set_size";
    public static final String FONT_SET_PROPERTY = "font_set";
    private List<List<String>> fontSetList;

    public static FontSetOptions getInstance() {
        return instance;
    }

    protected FontSetOptions() {
        this.nodeName = "font-set";
        this.fontSetList = new ArrayList<List<String>>();
        this.retrieve();
    }

    public static String listToString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String obj = list.get(i);
            sb.append(", " + obj);
        }
        if (sb.length() > 0) {
            sb.delete(0, 2);
        } else {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static List<String> stringToList(String text) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(text, ",");
        while (st.hasMoreTokens()) {
            StringBuilder sb = new StringBuilder(st.nextToken().trim());
            char c = sb.charAt(0);
            if (c == '\"' || c == '\'') {
                sb.deleteCharAt(0);
            }
            if (sb.length() > 0 && ((c = sb.charAt(sb.length() - 1)) == '\"' || c == '\'')) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (sb.length() <= 0) continue;
            list.add(sb.toString());
        }
        return list;
    }

    public List<List<String>> getFontSetList() {
        return this.fontSetList;
    }

    public void setFontSetList(List<List<String>> list) {
        this.fontSetList.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.fontSetList.add(list.get(i));
        }
        this.firePropertyChange(FONT_SET_PROPERTY, null, list);
        this.store();
    }

    protected void store() {
        Preferences prefs = this.getPreferences();
        try {
            prefs.clear();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        prefs.putInt(FONT_SET_SIZE_PROPERTY, this.fontSetList.size());
        for (int i = 0; i < this.fontSetList.size(); ++i) {
            List<String> subList = this.fontSetList.get(i);
            prefs.put(FONT_SET_PROPERTY + i, FontSetOptions.listToString(subList));
        }
    }

    protected void retrieve() {
        this.fontSetList.clear();
        Preferences prefs = this.getPreferences();
        int size = prefs.getInt(FONT_SET_SIZE_PROPERTY, -1);
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        if (size > -1) {
            for (int i = 0; i < size; ++i) {
                ArrayList<String> subList = new ArrayList<String>();
                String fonts = prefs.get(FONT_SET_PROPERTY + i, "");
                StringTokenizer tokenizer = new StringTokenizer(fonts, ",");
                while (tokenizer.hasMoreTokens()) {
                    String str = tokenizer.nextToken().trim();
                    if (str.length() <= 0) continue;
                    subList.add(str);
                }
                if (subList.size() <= 0) continue;
                list.add(subList);
            }
        }
        if (list.size() == 0) {
            String[] fonts = new String[]{"Arial", "Helvetica", "sans-serif"};
            list.add(Arrays.asList(fonts));
            fonts = new String[]{"Verdana", "Arial", "Helvetica", "sans-serif"};
            list.add(Arrays.asList(fonts));
            fonts = new String[]{"Times New Roman", "Times", "Garamond", "serif"};
            list.add(Arrays.asList(fonts));
            fonts = new String[]{"Courier", "Courier New", "MS Courier New", "Prestige", "monospace"};
            list.add(Arrays.asList(fonts));
            fonts = new String[]{"Caflisch Script", "Adobe Poetica", "Sanvito", "cursive"};
            list.add(Arrays.asList(fonts));
            fonts = new String[]{"Alpha Geometrique", "Critter", "Cottonwood", "fantasy"};
            list.add(Arrays.asList(fonts));
            fonts = new String[]{"SimSun", "NSimSun", "FZShuShong-Z01", "Arial", "sans-serif"};
            list.add(Arrays.asList(fonts));
        }
        this.fontSetList = list;
    }
}

