/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.prefs.Preferences;
import kiyut.sketsa.options.AbstractOptions;
import kiyut.sketsa.options.OptionsUtilities;

public class CanvasOptions
extends AbstractOptions {
    private static CanvasOptions instance = new CanvasOptions();
    public static final String SELECTION_COLOR_PROPERTY = "selection_color";
    public static final String CANVAS_ANTI_ALIAS_PROPERTY = "canvas_anti_alias";
    public static final String GRID_COLOR_PROPERTY = "grid_color";
    public static final String GRID_SIZE_PROPERTY = "grid_size";
    public static final String GRID_STYLE_PROPERTY = "grid_style";
    public static final int GRID_STYLE_LINE = 0;
    public static final int GRID_STYLE_DOT = 1;
    public static final String HANDLE_SIZE_PROPERTY = "handle_size";
    private Color selectionColor;
    private boolean canvasAntiAlias;
    private Color gridColor;
    private int gridSize;
    private int gridStyle;
    private Stroke gridStroke;
    private int handleSize;

    public static CanvasOptions getInstance() {
        return instance;
    }

    protected CanvasOptions() {
        this.nodeName = "canvas";
        Preferences prefs = this.getPreferences();
        String value = prefs.get(SELECTION_COLOR_PROPERTY, null);
        this.selectionColor = OptionsUtilities.stringToColor(value, Color.BLUE);
        this.canvasAntiAlias = prefs.getBoolean(CANVAS_ANTI_ALIAS_PROPERTY, true);
        value = prefs.get(GRID_COLOR_PROPERTY, null);
        this.gridColor = OptionsUtilities.stringToColor(value, Color.GRAY);
        int gridColorAlpha = 128;
        if (this.gridColor.getAlpha() != 128) {
            this.gridColor = new Color(this.gridColor.getRed(), this.gridColor.getGreen(), this.gridColor.getBlue(), gridColorAlpha);
        }
        this.gridSize = prefs.getInt(GRID_SIZE_PROPERTY, 50);
        this.gridStyle = prefs.getInt(GRID_STYLE_PROPERTY, 0);
        this.gridStroke = this.createGridStroke(this.gridStyle);
        this.handleSize = prefs.getInt(HANDLE_SIZE_PROPERTY, 8);
    }

    public void setSelectionColor(Color selectionColor) {
        Color old = this.selectionColor;
        this.selectionColor = selectionColor;
        this.firePropertyChange(SELECTION_COLOR_PROPERTY, old, selectionColor);
        this.getPreferences().put(SELECTION_COLOR_PROPERTY, OptionsUtilities.colorToString(this.selectionColor));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setCanvasAntiAliased(boolean antiAlias) {
        boolean old = this.canvasAntiAlias;
        this.canvasAntiAlias = antiAlias;
        this.firePropertyChange(CANVAS_ANTI_ALIAS_PROPERTY, old, this.canvasAntiAlias);
        this.getPreferences().putBoolean(CANVAS_ANTI_ALIAS_PROPERTY, this.canvasAntiAlias);
    }

    public boolean isCanvasAntiAliased() {
        return this.canvasAntiAlias;
    }

    public void setGridColor(Color color) {
        Color old = this.gridColor;
        this.gridColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
        this.firePropertyChange(GRID_COLOR_PROPERTY, old, this.gridColor);
        this.getPreferences().put(GRID_COLOR_PROPERTY, OptionsUtilities.colorToString(this.gridColor));
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridSize(int size) {
        int old = this.gridSize;
        this.gridSize = size;
        this.firePropertyChange(GRID_SIZE_PROPERTY, old, this.gridSize);
        this.getPreferences().putInt(GRID_SIZE_PROPERTY, this.gridSize);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public Stroke getGridStroke() {
        return this.gridStroke;
    }

    public void setGridStyle(int gridStyle) {
        int old = this.gridStyle;
        this.gridStyle = gridStyle;
        this.gridStroke = this.createGridStroke(gridStyle);
        this.firePropertyChange(GRID_STYLE_PROPERTY, old, this.gridStyle);
        this.getPreferences().putInt(GRID_STYLE_PROPERTY, this.gridStyle);
    }

    public int getGridStyle() {
        float[] dash = ((BasicStroke)this.gridStroke).getDashArray();
        if (dash == null) {
            return 0;
        }
        return 1;
    }

    protected Stroke createGridStroke(int gridStyle) {
        BasicStroke stroke;
        if (gridStyle == 0) {
            stroke = new BasicStroke(1.0f);
        } else {
            float f = this.getGridSize();
            if (f > 10.0f) {
                f = 10.0f;
            }
            float[] dash = new float[]{1.0f, f - 1.0f};
            stroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
        }
        return stroke;
    }

    public void setHandleSize(int size) {
        int old = this.handleSize;
        this.handleSize = size;
        this.firePropertyChange(HANDLE_SIZE_PROPERTY, old, this.handleSize);
        this.getPreferences().putInt(HANDLE_SIZE_PROPERTY, this.handleSize);
    }

    public int getHandleSize() {
        return this.handleSize;
    }
}

