/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.loaders;

import java.awt.EventQueue;
import java.io.IOException;
import kiyut.sketsa.loaders.SVGDataLoader;
import kiyut.sketsa.loaders.SVGDataNode;
import kiyut.sketsa.loaders.SVGEditorSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

public class SVGDataObject
extends MultiDataObject {
    protected SVGDocument svgDocument;
    protected EventListener domListener;
    protected SVGEditorSupport editorSupport;

    public SVGDataObject(FileObject pf, SVGDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, (MultiFileLoader)loader);
        this.setEditorSupport(new SVGEditorSupport(this));
        this.domListener = new EventListener(){

            @Override
            public void handleEvent(Event evt) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!SVGDataObject.this.isModified()) {
                            SVGDataObject.this.setModified(true);
                        }
                    }
                });
            }
        };
    }

    protected Node createNodeDelegate() {
        return new SVGDataNode(this);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    void setEditorSupport(SVGEditorSupport editorSupport) {
        CookieSet cookies = this.getCookieSet();
        if (this.editorSupport != null) {
            cookies.remove((Node.Cookie)this.editorSupport);
        }
        this.editorSupport = editorSupport;
        if (editorSupport != null) {
            cookies.add((Node.Cookie)editorSupport);
        }
    }

    void addCookie(Node.Cookie cookie) {
        this.getCookieSet().add(cookie);
    }

    void removeCookie(Node.Cookie cookie) {
        this.getCookieSet().remove(cookie);
    }

    public void setSVGDocument(SVGDocument doc) {
        this.setSVGDocument(doc, false);
    }

    public void setSVGDocument(SVGDocument doc, boolean replace) {
        SVGDocument old = this.svgDocument;
        if (old != null) {
            this.removeDOMEventListener((EventTarget)((Object)old.getDocumentElement()));
            if (!old.equals(doc)) {
                this.setModified(true);
            }
        }
        this.svgDocument = doc;
        if (this.svgDocument != null) {
            this.addDOMEventListener((EventTarget)((Object)this.svgDocument.getDocumentElement()));
        }
        if (replace) {
            this.setSVGDocument(doc);
            this.editorSupport.replaceSVGDocument(doc, old);
        }
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    protected void dispose() {
        if (this.svgDocument != null) {
            this.removeDOMEventListener((EventTarget)((Object)this.svgDocument.getDocumentElement()));
        }
        this.svgDocument = null;
        this.domListener = null;
        super.dispose();
    }

    private void addDOMEventListener(EventTarget et) {
        et.addEventListener("DOMAttrModified", this.domListener, false);
        et.addEventListener("DOMNodeInserted", this.domListener, false);
        et.addEventListener("DOMNodeRemoved", this.domListener, false);
        et.addEventListener("DOMCharacterDataModified", this.domListener, false);
    }

    private void removeDOMEventListener(EventTarget et) {
        et.removeEventListener("DOMAttrModified", this.domListener, false);
        et.removeEventListener("DOMNodeInserted", this.domListener, false);
        et.removeEventListener("DOMNodeRemoved", this.domListener, false);
        et.removeEventListener("DOMCharacterDataModified", this.domListener, false);
    }
}

