/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool.point;

import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.tool.point.AbstractPointTool;
import kiyut.sketsa.canvas.tool.point.PathSegment;
import kiyut.sketsa.canvas.tool.point.PointShape;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.GeomUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;

public class RemovePointTool
extends AbstractPointTool {
    @Override
    public void endTool() {
        if (this.canvas != null) {
            this.canvas.getCanvasSelection().setEnabledVisible(true, true, true);
        }
    }

    @Override
    public void startTool() {
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.canvas.repaint();
        this.fireMessageReceived(0, "Click on point to remove point");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        int startX = evt.getX();
        int startY = evt.getY();
        this.model.setSelectedPoint(null);
        this.model.setSelectedPathSegment(null);
        this.model.setSelectedElement(null);
        boolean found = false;
        int size = this.model.size();
        for (int i = 0; i < size; ++i) {
            List<PathSegment> pathSegmentList = this.model.getPathSegmentList(i);
            for (int j = 0; j < pathSegmentList.size(); ++j) {
                PointShape point;
                PathSegment pathSegment = pathSegmentList.get(j);
                if (pathSegment.getType() == 1 || !(point = (PointShape)pathSegment.getPoint(0)).contains(startX, startY)) continue;
                this.model.setSelectedElement(this.model.get(i));
                this.model.setSelectedPathSegment(pathSegment);
                this.model.setSelectedPoint(point);
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            return;
        }
        SVGElement selectedElement = this.model.getSelectedElement();
        PointShape selectedPoint = this.model.getSelectedPoint();
        if (selectedPoint != null && selectedElement != null) {
            ArrayList<Rectangle2D> list = new ArrayList<Rectangle2D>(2);
            GraphicsNode gn = this.canvas.getModel().getGraphicsNode(this.model.getSelectedElement());
            if (gn != null) {
                AffineTransform at = gn.getGlobalTransform();
                Shape shape = gn.getBounds();
                shape = at.createTransformedShape(shape);
                list.add((Rectangle2D)shape);
            }
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Remove Point");
            try {
                this.updateDOM();
            }
            finally {
                undoManager.end();
            }
            gn = this.canvas.getModel().getGraphicsNode(this.model.getSelectedElement());
            if (gn != null) {
                AffineTransform at = gn.getGlobalTransform();
                Shape shape = gn.getBounds();
                shape = at.createTransformedShape(shape);
                list.add((Rectangle2D)shape);
            }
            Rectangle2D bounds = GeomUtilities.getBounds2D(list);
            this.canvas.refresh(bounds);
        }
    }

    private void updateDOM() {
        SVGElement element = this.model.getSelectedElement();
        if (element instanceof SVGRectElement) {
            return;
        }
        if (element instanceof SVGEllipseElement) {
            return;
        }
        if (element instanceof SVGCircleElement) {
            return;
        }
        if (element instanceof SVGLineElement) {
            return;
        }
        if (element instanceof SVGPolylineElement) {
            this.updateSVGPolylineElement((SVGPolylineElement)element);
        } else if (element instanceof SVGPolygonElement) {
            this.updateSVGPolygonElement((SVGPolygonElement)element);
        } else if (element instanceof SVGPathElement) {
            this.updateSVGPathElement((SVGPathElement)element);
        }
        SVGElement selectedElement = this.model.getSelectedElement();
        if (selectedElement != null) {
            int indexOf = this.model.indexOf(selectedElement);
            this.model.updatePointList(indexOf);
        }
        this.model.setSelectedPoint(null);
        this.model.setSelectedPathSegment(null);
        this.model.setSelectedElement(null);
    }

    private void updateSVGPolylineElement(SVGPolylineElement polylineElement) {
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)polylineElement)).indexOf(pathSegment);
        SVGPointList svgPointList = polylineElement.getPoints();
        svgPointList.removeItem(indexOf);
        if (svgPointList.getNumberOfItems() < 2) {
            Node parent = polylineElement.getParentNode();
            parent.removeChild((Node)polylineElement);
            this.model.remove((SVGElement)polylineElement);
        }
    }

    private void updateSVGPolygonElement(SVGPolygonElement polygonElement) {
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)polygonElement)).indexOf(pathSegment);
        SVGPointList svgPointList = polygonElement.getPoints();
        svgPointList.removeItem(indexOf);
        if (svgPointList.getNumberOfItems() < 2) {
            Node parent = polygonElement.getParentNode();
            parent.removeChild((Node)polygonElement);
            this.model.remove((SVGElement)polygonElement);
        }
    }

    private void updateSVGPathElement(SVGPathElement pathElement) {
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)pathElement)).indexOf(pathSegment);
        SVGPathSegList segList = pathElement.getPathSegList();
        SVGPathSeg svgPathSeg = segList.getItem(indexOf);
        short type = svgPathSeg.getPathSegType();
        if (type == 2 || type == 3) {
            PointShape nextPoint = null;
            try {
                int i = this.model.getPathSegmentList(this.model.indexOf((SVGElement)pathElement)).indexOf(pathSegment);
                PathSegment nextPathSegment = this.model.getPathSegmentList(this.model.indexOf((SVGElement)pathElement)).get(i + 1);
                nextPoint = (PointShape)nextPathSegment.getPoint(0);
            }
            catch (Exception ex) {
                nextPoint = null;
            }
            if (nextPoint != null) {
                double[] srcPts = new double[2];
                double[] dstPts = new double[2];
                srcPts[0] = nextPoint.getX();
                srcPts[1] = nextPoint.getY();
                AffineTransform at = this.canvas.getTransform();
                GraphicsNode gn = this.canvas.getModel().getGraphicsNode(this.model.getSelectedElement());
                if (gn != null) {
                    AffineTransform globalAt = gn.getGlobalTransform();
                    at.concatenate(globalAt);
                    try {
                        at = at.createInverse();
                    }
                    catch (NoninvertibleTransformException ex) {
                        // empty catch block
                    }
                }
                at.transform(srcPts, 0, dstPts, 0, 1);
                SVGPathSegMovetoAbs newSVGPathSeg = pathElement.createSVGPathSegMovetoAbs((float)dstPts[0], (float)dstPts[1]);
                segList.replaceItem((SVGPathSeg)newSVGPathSeg, indexOf + 1);
            }
            segList.removeItem(indexOf);
        } else {
            segList.removeItem(indexOf);
        }
        SVGPathSegList pathSegList = pathElement.getPathSegList();
        if (pathSegList.getNumberOfItems() < 2) {
            Node parent = pathElement.getParentNode();
            parent.removeChild((Node)pathElement);
            this.model.remove((SVGElement)pathElement);
        }
    }
}

