/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool.point;

import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.point.PathSegment;
import kiyut.sketsa.canvas.tool.point.PointShape;
import kiyut.sketsa.options.CanvasOptions;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;

public class PointToolModel {
    private static PointToolModel instance;
    private Map<SVGElement, List<PathSegment>> pathSegmentListMap = new HashMap<SVGElement, List<PathSegment>>();
    private Map<SVGElement, Shape> outlineMap = new HashMap<SVGElement, Shape>();
    private List<SVGElement> elementList = new ArrayList<SVGElement>();
    private VectorCanvas canvas;
    private PointShape selectedPoint;
    private PathSegment selectedPathSegment;
    private SVGElement selectedElement;
    private ComponentAdapter canvasComponentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent evt) {
            PointToolModel.this.refresh();
        }
    };

    public static synchronized PointToolModel getInstance() {
        if (instance == null) {
            instance = new PointToolModel();
        }
        return instance;
    }

    private PointToolModel() {
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        VectorCanvas oldCanvas = this.canvas;
        if (oldCanvas != null) {
            oldCanvas.removeComponentListener(this.canvasComponentListener);
        }
        this.canvas = canvas;
        this.refresh();
        if (canvas != null) {
            canvas.addComponentListener(this.canvasComponentListener);
        }
    }

    public Shape getOutline(int index) {
        SVGElement element = this.get(index);
        return this.outlineMap.get(element);
    }

    public List<PathSegment> getPathSegmentList(int index) {
        SVGElement element = this.get(index);
        return this.pathSegmentListMap.get(element);
    }

    public void clear() {
        this.pathSegmentListMap.clear();
        this.outlineMap.clear();
        this.elementList.clear();
        this.selectedElement = null;
        this.selectedPathSegment = null;
        this.selectedPoint = null;
    }

    public void refresh() {
        this.clear();
        if (this.canvas == null) {
            return;
        }
        List<SVGElement> selectionList = this.canvas.getCanvasSelection().getSelectionList();
        for (int i = 0; i < selectionList.size(); ++i) {
            SVGElement element = selectionList.get(i);
            if (!(element instanceof SVGRectElement) && !(element instanceof SVGLineElement) && !(element instanceof SVGCircleElement) && !(element instanceof SVGEllipseElement) && !(element instanceof SVGPolygonElement) && !(element instanceof SVGPolylineElement) && !(element instanceof SVGPathElement)) continue;
            this.add(element);
            this.updatePointList(this.indexOf(element));
        }
    }

    public void remove(SVGElement element) {
        this.pathSegmentListMap.remove(element);
        this.outlineMap.remove(element);
        this.elementList.remove(element);
        if (element.equals(this.selectedElement)) {
            this.selectedElement = null;
            this.selectedPathSegment = null;
            this.selectedPoint = null;
        }
    }

    public void updateOutline(int index) {
        SVGElement element = this.get(index);
        List<PathSegment> pathSegmentList = this.getPathSegmentList(index);
        Shape outline = this.generateOutline(element, pathSegmentList);
        this.outlineMap.put(element, outline);
    }

    public void updatePointList(int index) {
        SVGElement element = this.get(index);
        CanvasModel model = this.canvas.getModel();
        AffineTransform canvasAt = this.canvas.getTransform();
        GraphicsNode gn = model.getGraphicsNode(element);
        if (gn != null && gn instanceof ShapeNode) {
            ShapeNode shapeNode = (ShapeNode)gn;
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(shapeNode.getGlobalTransform());
            this.pathSegmentListMap.put(element, this.generatePathSegmentList(element, at));
            this.outlineMap.remove(element);
        }
    }

    public void add(SVGElement element) {
        int indexOf = this.elementList.indexOf(element);
        if (indexOf < 0) {
            indexOf = this.elementList.size();
        }
        this.elementList.add(indexOf, element);
    }

    public int indexOf(SVGElement element) {
        return this.elementList.indexOf(element);
    }

    public SVGElement get(int index) {
        return this.elementList.get(index);
    }

    public int size() {
        return this.elementList.size();
    }

    public void setSelectedPoint(PointShape point) {
        this.selectedPoint = point;
    }

    public PointShape getSelectedPoint() {
        return this.selectedPoint;
    }

    public void setSelectedPathSegment(PathSegment pathSegment) {
        this.selectedPathSegment = pathSegment;
    }

    public PathSegment getSelectedPathSegment() {
        return this.selectedPathSegment;
    }

    public void setSelectedElement(SVGElement element) {
        this.selectedElement = element;
    }

    public SVGElement getSelectedElement() {
        return this.selectedElement;
    }

    public Shape getSelectedOutline() {
        return this.outlineMap.get(this.getSelectedElement());
    }

    private List<PathSegment> generatePathSegmentList(SVGElement element, AffineTransform at) {
        ArrayList<PathSegment> pathSegmentList;
        block24: {
            double[] dstPts;
            double[] srcPts;
            int size;
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block23: {
                                    pathSegmentList = new ArrayList<PathSegment>();
                                    CanvasOptions prefs = CanvasOptions.getInstance();
                                    size = prefs.getHandleSize();
                                    srcPts = new double[16];
                                    dstPts = new double[16];
                                    if (!(element instanceof SVGRectElement)) break block23;
                                    SVGRectElement elt = (SVGRectElement)element;
                                    SVGLength eX = elt.getX().getBaseVal();
                                    SVGLength eY = elt.getY().getBaseVal();
                                    SVGLength eW = elt.getWidth().getBaseVal();
                                    SVGLength eH = elt.getHeight().getBaseVal();
                                    SVGLength eRx = elt.getRx().getBaseVal();
                                    SVGLength eRy = elt.getRy().getBaseVal();
                                    srcPts[0] = eX.getValue() + eRx.getValue();
                                    srcPts[1] = eY.getValue();
                                    srcPts[2] = eX.getValue() + eW.getValue() - eRx.getValue();
                                    srcPts[3] = eY.getValue();
                                    srcPts[4] = eX.getValue() + eW.getValue();
                                    srcPts[5] = eY.getValue() + eRy.getValue();
                                    srcPts[6] = eX.getValue() + eW.getValue();
                                    srcPts[7] = eY.getValue() + eH.getValue() - eRy.getValue();
                                    srcPts[8] = eX.getValue() + eW.getValue() - eRx.getValue();
                                    srcPts[9] = eY.getValue() + eH.getValue();
                                    srcPts[10] = eX.getValue() + eRx.getValue();
                                    srcPts[11] = eY.getValue() + eH.getValue();
                                    srcPts[12] = eX.getValue();
                                    srcPts[13] = eY.getValue() + eH.getValue() - eRy.getValue();
                                    srcPts[14] = eX.getValue();
                                    srcPts[15] = eY.getValue() + eRy.getValue();
                                    at.transform(srcPts, 0, dstPts, 0, 8);
                                    for (int i = 0; i < dstPts.length; i += 2) {
                                        PathSegment pathSegment = new PathSegment();
                                        pathSegment.setType((short)0);
                                        pathSegmentList.add(pathSegment);
                                        PointShape point = new PointShape(dstPts[i], dstPts[i + 1], size);
                                        pathSegment.addPoint(point);
                                    }
                                    break block24;
                                }
                                if (!(element instanceof SVGEllipseElement)) break block25;
                                SVGEllipseElement elt = (SVGEllipseElement)element;
                                SVGLength eCx = elt.getCx().getBaseVal();
                                SVGLength eCy = elt.getCy().getBaseVal();
                                SVGLength eRx = elt.getRx().getBaseVal();
                                SVGLength eRy = elt.getRy().getBaseVal();
                                srcPts[0] = eCx.getValue();
                                srcPts[1] = eCy.getValue() - eRy.getValue();
                                srcPts[2] = eCx.getValue() + eRx.getValue();
                                srcPts[3] = eCy.getValue();
                                srcPts[4] = eCx.getValue();
                                srcPts[5] = eCy.getValue() + eRy.getValue();
                                srcPts[6] = eCx.getValue() - eRx.getValue();
                                srcPts[7] = eCy.getValue();
                                at.transform(srcPts, 0, dstPts, 0, 4);
                                for (int i = 0; i < dstPts.length; i += 2) {
                                    PathSegment pathSegment = new PathSegment();
                                    pathSegment.setType((short)0);
                                    pathSegmentList.add(pathSegment);
                                    PointShape point = new PointShape(dstPts[i], dstPts[i + 1], size);
                                    pathSegment.addPoint(point);
                                }
                                break block24;
                            }
                            if (!(element instanceof SVGCircleElement)) break block26;
                            SVGCircleElement elt = (SVGCircleElement)element;
                            SVGLength eCx = elt.getCx().getBaseVal();
                            SVGLength eCy = elt.getCy().getBaseVal();
                            SVGLength eRx = elt.getR().getBaseVal();
                            SVGLength eRy = elt.getR().getBaseVal();
                            srcPts[0] = eCx.getValue();
                            srcPts[1] = eCy.getValue() - eRy.getValue();
                            srcPts[2] = eCx.getValue() + eRx.getValue();
                            srcPts[3] = eCy.getValue();
                            srcPts[4] = eCx.getValue();
                            srcPts[5] = eCy.getValue() + eRy.getValue();
                            srcPts[6] = eCx.getValue() - eRx.getValue();
                            srcPts[7] = eCy.getValue();
                            at.transform(srcPts, 0, dstPts, 0, 4);
                            for (int i = 0; i < dstPts.length; i += 2) {
                                PathSegment pathSegment = new PathSegment();
                                pathSegment.setType((short)0);
                                pathSegmentList.add(pathSegment);
                                PointShape point = new PointShape(dstPts[i], dstPts[i + 1], size);
                                pathSegment.addPoint(point);
                            }
                            break block24;
                        }
                        if (!(element instanceof SVGLineElement)) break block27;
                        SVGLineElement elt = (SVGLineElement)element;
                        SVGLength eX1 = elt.getX1().getBaseVal();
                        SVGLength eY1 = elt.getY1().getBaseVal();
                        SVGLength eX2 = elt.getX2().getBaseVal();
                        SVGLength eY2 = elt.getY2().getBaseVal();
                        srcPts[0] = eX1.getValue();
                        srcPts[1] = eY1.getValue();
                        srcPts[2] = eX2.getValue();
                        srcPts[3] = eY2.getValue();
                        at.transform(srcPts, 0, dstPts, 0, 2);
                        PathSegment pathSegment = new PathSegment();
                        pathSegment.setType((short)0);
                        pathSegmentList.add(pathSegment);
                        PointShape point = new PointShape(dstPts[0], dstPts[1], size);
                        pathSegment.addPoint(point);
                        pathSegment = new PathSegment();
                        pathSegment.setType((short)0);
                        pathSegmentList.add(pathSegment);
                        point = new PointShape(dstPts[2], dstPts[3], size);
                        pathSegment.addPoint(point);
                        break block24;
                    }
                    if (!(element instanceof SVGPolylineElement)) break block28;
                    SVGPolylineElement elt = (SVGPolylineElement)element;
                    SVGPointList pList = elt.getPoints();
                    for (int j = 0; j < pList.getNumberOfItems(); ++j) {
                        SVGPoint p = pList.getItem(j);
                        srcPts[0] = p.getX();
                        srcPts[1] = p.getY();
                        at.transform(srcPts, 0, dstPts, 0, 1);
                        PathSegment pathSegment = new PathSegment();
                        pathSegment.setType((short)0);
                        pathSegmentList.add(pathSegment);
                        PointShape point = new PointShape(dstPts[0], dstPts[1], size);
                        pathSegment.addPoint(point);
                    }
                    break block24;
                }
                if (!(element instanceof SVGPolygonElement)) break block29;
                SVGPolygonElement elt = (SVGPolygonElement)element;
                SVGPointList pList = elt.getPoints();
                for (int j = 0; j < pList.getNumberOfItems(); ++j) {
                    SVGPoint p = pList.getItem(j);
                    srcPts[0] = p.getX();
                    srcPts[1] = p.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    PathSegment pathSegment = new PathSegment();
                    pathSegment.setType((short)0);
                    pathSegmentList.add(pathSegment);
                    PointShape point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                }
                break block24;
            }
            if (!(element instanceof SVGPathElement)) break block24;
            SVGPathElement elt = (SVGPathElement)element;
            SVGPathSegList segList = elt.getPathSegList();
            double[] lastPts = new double[]{0.0, 0.0};
            srcPts[0] = 0.0;
            srcPts[1] = 0.0;
            for (int j = 0; j < segList.getNumberOfItems(); ++j) {
                SVGPathSegLinetoAbs line;
                SVGPathSegCurvetoQuadraticAbs quad;
                SVGPathSegCurvetoCubicAbs cubic;
                SVGPathSegArcAbs arc;
                PointShape point;
                SVGPathSegMovetoAbs moveTo;
                SVGPathSeg pathSeg = segList.getItem(j);
                short type = pathSeg.getPathSegType();
                PathSegment pathSegment = new PathSegment();
                pathSegment.setType(type);
                pathSegmentList.add(pathSegment);
                if (type == 2) {
                    moveTo = (SVGPathSegMovetoAbs)pathSeg;
                    srcPts[0] = moveTo.getX();
                    srcPts[1] = moveTo.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 3) {
                    moveTo = (SVGPathSegMovetoRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)moveTo.getX();
                    srcPts[1] = lastPts[1] + (double)moveTo.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 10) {
                    arc = (SVGPathSegArcAbs)pathSeg;
                    srcPts[0] = arc.getX();
                    srcPts[1] = arc.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 11) {
                    arc = (SVGPathSegArcRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)arc.getX();
                    srcPts[1] = lastPts[1] + (double)arc.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 6) {
                    cubic = (SVGPathSegCurvetoCubicAbs)pathSeg;
                    srcPts[0] = cubic.getX();
                    srcPts[1] = cubic.getY();
                    srcPts[2] = cubic.getX1();
                    srcPts[3] = cubic.getY1();
                    srcPts[4] = cubic.getX2();
                    srcPts[5] = cubic.getY2();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 3);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    point = new PointShape(dstPts[2], dstPts[3], size);
                    pathSegment.addPoint(point);
                    point = new PointShape(dstPts[4], dstPts[5], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 7) {
                    cubic = (SVGPathSegCurvetoCubicRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)cubic.getX();
                    srcPts[1] = lastPts[1] + (double)cubic.getY();
                    srcPts[2] = lastPts[0] + (double)cubic.getX1();
                    srcPts[3] = lastPts[1] + (double)cubic.getY1();
                    srcPts[4] = lastPts[0] + (double)cubic.getX2();
                    srcPts[5] = lastPts[1] + (double)cubic.getY2();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 3);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    point = new PointShape(dstPts[2], dstPts[3], size);
                    pathSegment.addPoint(point);
                    point = new PointShape(dstPts[4], dstPts[5], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 16) {
                    cubic = (SVGPathSegCurvetoCubicSmoothAbs)pathSeg;
                    srcPts[0] = cubic.getX();
                    srcPts[1] = cubic.getY();
                    srcPts[2] = cubic.getX2();
                    srcPts[3] = cubic.getY2();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 2);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    point = new PointShape(dstPts[2], dstPts[3], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 17) {
                    cubic = (SVGPathSegCurvetoCubicSmoothRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)cubic.getX();
                    srcPts[1] = lastPts[1] + (double)cubic.getY();
                    srcPts[2] = lastPts[0] + (double)cubic.getX2();
                    srcPts[3] = lastPts[1] + (double)cubic.getY2();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 2);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    point = new PointShape(dstPts[2], dstPts[3], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 8) {
                    quad = (SVGPathSegCurvetoQuadraticAbs)pathSeg;
                    srcPts[0] = quad.getX();
                    srcPts[1] = quad.getY();
                    srcPts[2] = quad.getX1();
                    srcPts[3] = quad.getY1();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 2);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    point = new PointShape(dstPts[2], dstPts[3], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 9) {
                    quad = (SVGPathSegCurvetoQuadraticRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)quad.getX();
                    srcPts[1] = lastPts[1] + (double)quad.getY();
                    srcPts[2] = lastPts[0] + (double)quad.getX1();
                    srcPts[3] = lastPts[1] + (double)quad.getY1();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 2);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    point = new PointShape(dstPts[2], dstPts[3], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 18) {
                    quad = (SVGPathSegCurvetoQuadraticSmoothAbs)pathSeg;
                    srcPts[0] = quad.getX();
                    srcPts[1] = quad.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 2);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 19) {
                    quad = (SVGPathSegCurvetoQuadraticSmoothRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)quad.getX();
                    srcPts[1] = lastPts[1] + (double)quad.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 2);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 4) {
                    line = (SVGPathSegLinetoAbs)pathSeg;
                    srcPts[0] = line.getX();
                    srcPts[1] = line.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 12) {
                    line = (SVGPathSegLinetoHorizontalAbs)pathSeg;
                    srcPts[0] = line.getX();
                    lastPts[0] = srcPts[0];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 13) {
                    line = (SVGPathSegLinetoHorizontalRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)line.getX();
                    lastPts[0] = srcPts[0];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 5) {
                    line = (SVGPathSegLinetoRel)pathSeg;
                    srcPts[0] = lastPts[0] + (double)line.getX();
                    srcPts[1] = lastPts[1] + (double)line.getY();
                    lastPts[0] = srcPts[0];
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type == 14) {
                    line = (SVGPathSegLinetoVerticalAbs)pathSeg;
                    srcPts[1] = line.getY();
                    lastPts[1] = srcPts[1];
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    point = new PointShape(dstPts[0], dstPts[1], size);
                    pathSegment.addPoint(point);
                    continue;
                }
                if (type != 15) continue;
                line = (SVGPathSegLinetoVerticalAbs)pathSeg;
                srcPts[1] = lastPts[1] + (double)line.getY();
                lastPts[1] = srcPts[1];
                at.transform(srcPts, 0, dstPts, 0, 1);
                point = new PointShape(dstPts[0], dstPts[1], size);
                pathSegment.addPoint(point);
            }
        }
        return pathSegmentList;
    }

    private Shape generateOutline(SVGElement element, List<PathSegment> pathSegmentList) {
        if (pathSegmentList.size() <= 0) {
            return null;
        }
        Object outline = null;
        if (element instanceof SVGRectElement) {
            double x = pathSegmentList.get(7).getPoint(0).getX();
            double y = pathSegmentList.get(0).getPoint(0).getY();
            double w = pathSegmentList.get(2).getPoint(0).getX() - pathSegmentList.get(7).getPoint(0).getX();
            double h = pathSegmentList.get(0).getPoint(0).getY() - pathSegmentList.get(5).getPoint(0).getY();
            double rx = pathSegmentList.get(0).getPoint(0).getX() - x;
            double ry = pathSegmentList.get(7).getPoint(0).getY() - y;
            RoundRectangle2D.Double r = new RoundRectangle2D.Double(x, y, w, h, rx, ry);
            outline = r;
        } else if (element instanceof SVGLineElement) {
            double x1 = pathSegmentList.get(0).getPoint(0).getX();
            double y1 = pathSegmentList.get(0).getPoint(0).getY();
            double x2 = pathSegmentList.get(1).getPoint(0).getX();
            double y2 = pathSegmentList.get(1).getPoint(0).getY();
            Line2D.Double l = new Line2D.Double(x1, y1, x2, y2);
            outline = l;
        } else if (element instanceof SVGEllipseElement || element instanceof SVGCircleElement) {
            double cx = pathSegmentList.get(0).getPoint(0).getX();
            double cy = pathSegmentList.get(1).getPoint(0).getY();
            double rx = pathSegmentList.get(1).getPoint(0).getX();
            double ry = pathSegmentList.get(2).getPoint(0).getY();
            Ellipse2D.Double e = new Ellipse2D.Double();
            e.setFrameFromCenter(cx, cy, rx, ry);
            outline = e;
        } else if (element instanceof SVGPolylineElement || element instanceof SVGPolygonElement) {
            GeneralPath path = new GeneralPath();
            Point2D point = pathSegmentList.get(0).getPoint(0);
            path.moveTo((float)point.getX(), (float)point.getY());
            for (int i = 1; i < pathSegmentList.size(); ++i) {
                point = pathSegmentList.get(i).getPoint(0);
                path.lineTo((float)point.getX(), (float)point.getY());
            }
            if (element instanceof SVGPolygonElement) {
                path.closePath();
            }
            outline = path;
        } else if (element instanceof SVGPathElement) {
            ExtendedGeneralPath path;
            outline = path = new ExtendedGeneralPath();
            for (int j = 0; j < pathSegmentList.size(); ++j) {
                double cpy1;
                double cpx1;
                double y;
                double x;
                Point2D point;
                PathSegment pathSeg = pathSegmentList.get(j);
                short type = pathSeg.getType();
                if (type == 2 || type == 3) {
                    point = pathSeg.getPoint(0);
                    path.moveTo((float)point.getX(), (float)point.getY());
                    continue;
                }
                if (type == 1) {
                    path.closePath();
                    continue;
                }
                if (type == 4 || type == 12 || type == 13 || type == 5 || type == 14 || type == 15) {
                    point = pathSeg.getPoint(0);
                    path.lineTo((float)point.getX(), (float)point.getY());
                    continue;
                }
                if (type == 6 || type == 7) {
                    point = pathSeg.getPoint(0);
                    x = point.getX();
                    y = point.getY();
                    point = pathSeg.getPoint(1);
                    cpx1 = point.getX();
                    cpy1 = point.getY();
                    point = pathSeg.getPoint(2);
                    double cpx2 = point.getX();
                    double cpy2 = point.getY();
                    path.curveTo((float)cpx1, (float)cpy1, (float)cpx2, (float)cpy2, (float)x, (float)y);
                    continue;
                }
                if (type == 16 || type == 17) {
                    PathSegment prevPathSeg;
                    short prevType;
                    point = pathSeg.getPoint(0);
                    x = point.getX();
                    y = point.getY();
                    point = pathSeg.getPoint(1);
                    double cpx2 = point.getX();
                    double cpy2 = point.getY();
                    double cpx12 = x;
                    double cpy12 = y;
                    if (j - 1 >= 0 && ((prevType = (prevPathSeg = pathSegmentList.get(j - 1)).getType()) == 6 || prevType == 7)) {
                        point = (PointShape)prevPathSeg.getPoint(0);
                        double midx = point.getX();
                        double midy = point.getY();
                        point = (PointShape)prevPathSeg.getPoint(prevPathSeg.getPointCount() - 1);
                        cpx12 = midx + (midx - point.getX());
                        cpy12 = midy + (midy - point.getY());
                    }
                    path.curveTo((float)cpx12, (float)cpy12, (float)cpx2, (float)cpy2, (float)x, (float)y);
                    continue;
                }
                if (type == 8 || type == 9) {
                    point = pathSeg.getPoint(0);
                    x = point.getX();
                    y = point.getY();
                    point = pathSeg.getPoint(1);
                    cpx1 = point.getX();
                    cpy1 = point.getY();
                    path.quadTo((float)cpx1, (float)cpy1, (float)x, (float)y);
                    continue;
                }
                if (type == 18 || type == 19) {
                    PathSegment prevPathSeg;
                    short prevType;
                    point = pathSeg.getPoint(0);
                    x = point.getX();
                    y = point.getY();
                    cpx1 = x;
                    cpy1 = y;
                    if (j - 1 >= 0 && ((prevType = (prevPathSeg = pathSegmentList.get(j - 1)).getType()) == 8 || prevType == 9)) {
                        point = (PointShape)prevPathSeg.getPoint(0);
                        double midx = point.getX();
                        double midy = point.getY();
                        point = (PointShape)prevPathSeg.getPoint(prevPathSeg.getPointCount() - 1);
                        cpx1 = midx + (midx - point.getX());
                        cpy1 = midy + (midy - point.getY());
                    }
                    path.quadTo((float)cpx1, (float)cpy1, (float)x, (float)y);
                    continue;
                }
                if (type != 10 && type != 11) continue;
                point = pathSeg.getPoint(0);
                x = point.getX();
                y = point.getY();
                path.lineTo((float)x, (float)y);
            }
        }
        return outline;
    }
}

