/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool.point;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.List;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.canvas.tool.point.PathSegment;
import kiyut.sketsa.canvas.tool.point.PointShape;
import kiyut.sketsa.canvas.tool.point.PointTool;
import kiyut.sketsa.canvas.tool.point.PointToolModel;
import org.w3c.dom.svg.SVGElement;

public abstract class AbstractPointTool
extends AbstractTool
implements PointTool {
    protected VectorCanvas canvas;
    protected PointToolModel model;
    protected Stroke stroke = new BasicStroke(1.0f);

    public AbstractPointTool() {
        this.model = PointToolModel.getInstance();
    }

    @Override
    public void paint(Graphics2D g2d) {
        int indexOf;
        Shape outline;
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(this.stroke);
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        SVGElement selectedElement = this.model.getSelectedElement();
        if (selectedElement != null && (outline = this.model.getOutline(indexOf = this.model.indexOf(selectedElement))) != null) {
            g2d.draw(outline);
        }
        for (int i = 0; i < this.model.size(); ++i) {
            List<PathSegment> pathSegmentList = this.model.getPathSegmentList(i);
            if (pathSegmentList == null) continue;
            PointShape point = null;
            PointShape prevPoint = null;
            PointShape ctrlPoint = null;
            for (int j = 0; j < pathSegmentList.size(); ++j) {
                PathSegment pathSegment = pathSegmentList.get(j);
                if (pathSegment.getType() == 1) {
                    prevPoint = point;
                    continue;
                }
                prevPoint = point;
                point = (PointShape)pathSegment.getPoint(0);
                g2d.fill(point);
                if (pathSegment != this.model.getSelectedPathSegment()) continue;
                if (pathSegment.getPointCount() == 3) {
                    ctrlPoint = (PointShape)pathSegment.getPoint(1);
                    g2d.draw(ctrlPoint);
                    if (prevPoint != null) {
                        g2d.drawLine((int)ctrlPoint.x, (int)ctrlPoint.y, (int)prevPoint.x, (int)prevPoint.y);
                    }
                    ctrlPoint = (PointShape)pathSegment.getPoint(2);
                    g2d.draw(ctrlPoint);
                    if (point == null) continue;
                    g2d.drawLine((int)ctrlPoint.x, (int)ctrlPoint.y, (int)point.x, (int)point.y);
                    continue;
                }
                for (int k = 1; k < pathSegment.getPointCount(); ++k) {
                    ctrlPoint = (PointShape)pathSegment.getPoint(k);
                    g2d.draw(ctrlPoint);
                    if (point == null) continue;
                    g2d.drawLine((int)ctrlPoint.x, (int)ctrlPoint.y, (int)point.x, (int)point.y);
                }
            }
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
        this.model.setVectorCanvas(canvas);
    }

    @Override
    public PointToolModel getModel() {
        return this.model;
    }

    @Override
    public void endTool() {
        this.model.clear();
    }
}

