/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.tool.ZoomTool;

public class ZoomOutTool
extends ZoomTool {
    private Cursor zoomOutCursor;

    public ZoomOutTool() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Dimension dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            Image cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/canvas/tool/zoom-out-cursor32.png"));
            this.zoomOutCursor = toolkit.createCustomCursor(cursorImage, new Point(12, 12), "ZOOM_OUT_CURSOR");
        }
        catch (Exception e) {
            this.zoomOutCursor = Cursor.getDefaultCursor();
        }
    }

    @Override
    public void startTool() {
        super.startTool();
        this.canvas.setCursor(this.zoomOutCursor);
        this.fireMessageReceived(0, "Click on canvas to Zoom Out");
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        double newZoomFactor;
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        double zoomFactor = this.canvas.getZoomFactor();
        int index = this.presetZoomFactor.length;
        for (int i = this.presetZoomFactor.length - 1; i >= 0; --i) {
            double preset = this.presetZoomFactor[i];
            if (!(zoomFactor > preset)) continue;
            index = i;
            break;
        }
        if (index < this.presetZoomFactor.length && zoomFactor > (newZoomFactor = this.presetZoomFactor[index])) {
            this.canvas.setZoomFactor(newZoomFactor);
        }
    }
}

