/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.undo.DOMUndoManager;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;

public class SkewTool
extends AbstractTool {
    private static final int SKEW_TYPE_NONE = -1;
    private static final int SKEW_TYPE_X = 1;
    private static final int SKEW_TYPE_Y = 2;
    private VectorCanvas canvas;
    private Stroke stroke = new BasicStroke(1.0f);
    private Cursor skewXCursor;
    private Cursor skewYCursor;
    private int startX;
    private int startY;
    private int newX;
    private int newY;
    private List<SVGElement> selectionList = new ArrayList<SVGElement>();
    private List<Shape> outlineList = new ArrayList<Shape>();
    private List<Shape> newOutlineList = new ArrayList<Shape>();
    private boolean skewing = false;
    private int skewType = -1;

    public SkewTool() {
        Image cursorImage;
        Dimension dim;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/canvas/tool/skew-x-cursor32.png"));
            this.skewXCursor = toolkit.createCustomCursor(cursorImage, new Point(16, 16), "SKEW_X_CURSOR");
        }
        catch (Exception ex) {
            this.skewXCursor = Cursor.getDefaultCursor();
        }
        try {
            dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/canvas/tool/skew-y-cursor32.png"));
            this.skewYCursor = toolkit.createCustomCursor(cursorImage, new Point(16, 16), "SKEW_Y_CURSOR");
        }
        catch (Exception ex) {
            this.skewYCursor = Cursor.getDefaultCursor();
        }
    }

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        if (this.skewing) {
            g2d.setStroke(this.stroke);
            for (int i = 0; i < this.newOutlineList.size(); ++i) {
                Shape shape = this.newOutlineList.get(i);
                g2d.draw(shape);
            }
        } else {
            g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
            Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
            Rectangle2D r = border.get(Integer.toString(0));
            g2d.draw(r);
            Rectangle2D corner = border.get(Integer.toString(2));
            g2d.fill(corner);
            corner = border.get(Integer.toString(4));
            g2d.fill(corner);
            corner = border.get(Integer.toString(6));
            g2d.fill(corner);
            corner = border.get(Integer.toString(8));
            g2d.fill(corner);
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        if (this.canvas.getCursor().getType() != 0) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.skewing = false;
        this.canvas.repaint();
        this.fireMessageReceived(0, "Drag to skew selection using Transform Matrix");
    }

    @Override
    public void endTool() {
        this.selectionList.clear();
        this.outlineList.clear();
        this.newOutlineList.clear();
    }

    private void updateDOM() {
        if (this.selectionList.isEmpty()) {
            return;
        }
        double[] values = new double[6];
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        AffineTransform rotateAt = this.createTransform();
        CanvasModel model = this.canvas.getModel();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            GraphicsNode gn;
            SVGElement element = this.selectionList.get(i);
            if (!(element instanceof SVGTransformable) || (gn = model.getGraphicsNode(element)) == null) continue;
            AffineTransform curAt = (AffineTransform)canvasAt.clone();
            curAt.concatenate(gn.getGlobalTransform());
            if (element instanceof SVGUseElement) {
                SVGUseElement elt = (SVGUseElement)element;
                SVGLength ex = elt.getX().getBaseVal();
                SVGLength ey = elt.getY().getBaseVal();
                float useX = ex.getValue();
                float useY = ey.getValue();
                AffineTransform useAt = AffineTransform.getTranslateInstance(-useX, -useY);
                curAt.concatenate(useAt);
            }
            AffineTransform at = new AffineTransform(rotateAt);
            at.concatenate(curAt);
            try {
                AffineTransform invAt = curAt.createInverse();
                invAt.concatenate(at);
                at = invAt;
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            at.getMatrix(values);
            SVGMatrix matrix = model.getSVGSVGElement().createSVGMatrix();
            matrix.setA((float)values[0]);
            matrix.setB((float)values[1]);
            matrix.setC((float)values[2]);
            matrix.setD((float)values[3]);
            matrix.setE((float)values[4]);
            matrix.setF((float)values[5]);
            SVGTransform transform = model.getSVGSVGElement().createSVGTransformFromMatrix(matrix);
            SVGTransformList transformList = ((SVGTransformable)element).getTransform().getBaseVal();
            transformList.appendItem(transform);
            transformList.consolidate();
        }
    }

    private void updateOutline() {
        this.newOutlineList.clear();
        AffineTransform at = this.createTransform();
        for (int i = 0; i < this.outlineList.size(); ++i) {
            Shape shape = this.outlineList.get(i);
            shape = at.createTransformedShape(shape);
            this.newOutlineList.add(shape);
        }
    }

    protected AffineTransform createTransform() {
        double shx = 0.0;
        double shy = 0.0;
        Rectangle2D r = this.canvas.getCanvasSelection().getSelectionBounds2D();
        if (this.skewType == 1) {
            shx = (double)(this.newX - this.startX) * 0.01;
        } else if (this.skewType == 2) {
            shy = (double)(this.newY - this.startY) * 0.01;
        }
        AffineTransform newAt = new AffineTransform();
        newAt.translate(r.getX(), r.getY());
        newAt.shear(shx, shy);
        newAt.translate(-r.getX(), -r.getY());
        return newAt;
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        if (this.skewing && !this.selectionList.isEmpty()) {
            this.updateOutline();
            this.canvas.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        int type = -1;
        Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
        Rectangle2D r = null;
        for (int i = 2; i <= 8; i += 2) {
            r = border.get(Integer.toString(i));
            if (!r.contains(x, y)) continue;
            type = i;
            if (i > 0) break;
        }
        if (type == 2 || type == 8) {
            this.skewType = 1;
            this.canvas.setCursor(this.skewXCursor);
        } else if (type == 4 || type == 6) {
            this.skewType = 2;
            this.canvas.setCursor(this.skewYCursor);
        } else {
            this.skewType = -1;
            this.canvas.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.startX = gridSize * Math.round((float)this.startX / (float)gridSize);
            this.startY = gridSize * Math.round((float)this.startY / (float)gridSize);
        }
        this.newX = this.startX;
        this.newY = this.startY;
        this.outlineList.clear();
        this.newOutlineList.clear();
        if (this.skewType != 1 && this.skewType != 2) {
            this.skewing = false;
            return;
        }
        this.skewing = true;
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        CanvasModel model = this.canvas.getModel();
        this.selectionList = CanvasUtilities.getGraphicsElement(this.canvas.getCanvasSelection().getSelectionList());
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGElement elt = this.selectionList.get(i);
            GraphicsNode gn = model.getGraphicsNode(elt);
            if (gn == null) continue;
            Shape shape = gn.getOutline();
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(gn.getGlobalTransform());
            shape = at.createTransformedShape(shape);
            this.outlineList.add(shape);
        }
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.outlineList.clear();
        this.newOutlineList.clear();
        if (this.skewing) {
            Cursor prevCursor = this.canvas.getCursor();
            this.canvas.setCursor(Cursor.getPredefinedCursor(3));
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Transform skew selections");
            try {
                this.updateDOM();
                this.canvas.refresh();
            }
            finally {
                undoManager.end();
                this.canvas.getCanvasSelection().updateBorder();
                this.skewing = false;
                this.selectionList.clear();
                this.canvas.setCursor(prevCursor);
                this.canvas.repaint();
            }
        }
    }
}

