/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.options.CanvasOptions;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.util.GeomUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegClosePath;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGStylable;

public class PencilTool
extends AbstractTool {
    protected VectorCanvas canvas;
    protected Paint strokePaint;
    protected Paint fillPaint = null;
    protected Stroke stroke = new BasicStroke(this.strokeWidth);
    protected float strokeWidth = 1.0f;
    private Rectangle2D initHandle;
    private GeneralPath path;

    public PencilTool() {
        this.strokePaint = Color.BLACK;
        this.path = new GeneralPath();
        this.reset();
    }

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.strokePaint);
        g2d.setStroke(this.stroke);
        if (this.initHandle != null) {
            g2d.fill(this.initHandle);
        }
        g2d.draw(this.path);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public void setStrokePaint(Paint strokePaint) {
        this.strokePaint = strokePaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void endTool() {
        this.reset();
    }

    @Override
    public void startTool() {
        this.reset();
        this.canvas.getCanvasSelection().setEnabledVisible(false, true, false);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.fireMessageReceived(0, "Draw Freeform");
    }

    private void reset() {
        this.initHandle = null;
        this.path.reset();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.path.lineTo(evt.getX(), evt.getY());
        Rectangle r = this.path.getBounds();
        this.canvas.repaint(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (this.initHandle == null) {
            CanvasOptions prefs = CanvasOptions.getInstance();
            int handleSize = prefs.getHandleSize() / 2;
            this.initHandle = new Rectangle2D.Float();
            this.initHandle.setFrameFromCenter(evt.getX(), evt.getY(), evt.getX() - handleSize, evt.getY() - handleSize);
        }
        this.path.moveTo(evt.getX(), evt.getY());
        this.canvas.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (this.path.getBounds2D().isEmpty()) {
            return;
        }
        if (this.initHandle.contains(evt.getPoint())) {
            this.path.closePath();
        }
        this.path = this.simplify(this.path);
        this.path = this.convertToCurve(this.path);
        CanvasModel model = this.canvas.getModel();
        SVGElement element = this.createSVGElement();
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Draw Freeform");
        model.appendChild((Element)element);
        undoManager.end();
        ArrayList<SVGElement> selectionList = new ArrayList<SVGElement>(1);
        selectionList.add(element);
        this.canvas.getCanvasSelection().setSelectionList(selectionList);
        this.reset();
        this.canvas.refresh();
    }

    private SVGElement createSVGElement() {
        String str;
        CanvasModel model = this.canvas.getModel();
        SVGDocument svgDocument = model.getSVGDocument();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGElement element = (SVGElement)svgDocument.createElementNS(svgNS, "path");
        SVGStylable stylable = (SVGStylable)element;
        if (this.strokePaint != null) {
            if (this.strokePaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.strokePaint);
                DOMUtilities.updateProperty(stylable, null, "stroke", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "stroke", "none");
        }
        if (this.fillPaint != null) {
            if (this.fillPaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.fillPaint);
                DOMUtilities.updateProperty(stylable, null, "fill", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "fill", "none");
        }
        PathIterator pi = this.path.getPathIterator(null);
        float[] coords = new float[6];
        SVGPathElement pathElement = (SVGPathElement)element;
        while (!pi.isDone()) {
            int segment = pi.currentSegment(coords);
            if (segment == 0) {
                SVGPathSegMovetoAbs svgMoveTo = pathElement.createSVGPathSegMovetoAbs(coords[0], coords[1]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgMoveTo);
            } else if (segment == 4) {
                SVGPathSegClosePath svgClosePath = pathElement.createSVGPathSegClosePath();
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgClosePath);
            } else if (segment == 3) {
                SVGPathSegCurvetoCubicAbs svgCubic = pathElement.createSVGPathSegCurvetoCubicAbs(coords[4], coords[5], coords[0], coords[1], coords[2], coords[3]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgCubic);
            }
            pi.next();
        }
        return element;
    }

    private GeneralPath simplify(GeneralPath path) {
        ArrayList<Point2D> pointList = new ArrayList<Point2D>();
        ArrayList<Point2D> simplifyList = new ArrayList<Point2D>();
        PathIterator pi = path.getPathIterator(null);
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int segment = pi.currentSegment(coords);
            if (segment == 0) {
                pointList.add(new Point2D.Float(coords[0], coords[1]));
            } else if (segment == 4) {
                Point2D p = (Point2D)pointList.get(0);
                pointList.add((Point2D)p.clone());
            } else if (segment == 1) {
                pointList.add(new Point2D.Float(coords[0], coords[1]));
            } else if (segment == 2) {
                pointList.add(new Point2D.Float(coords[2], coords[3]));
            } else if (segment == 3) {
                pointList.add(new Point2D.Float(coords[4], coords[5]));
            }
            pi.next();
        }
        GeomUtilities.simplify(2.0, pointList, simplifyList);
        GeneralPath newPath = new GeneralPath();
        Point2D start = (Point2D)simplifyList.get(0);
        newPath.moveTo((float)start.getX(), (float)start.getY());
        for (int i = 1; i < simplifyList.size() - 1; ++i) {
            Point2D point = (Point2D)simplifyList.get(i);
            newPath.lineTo((float)point.getX(), (float)point.getY());
        }
        Point2D end = (Point2D)simplifyList.get(simplifyList.size() - 1);
        if (end.equals(start)) {
            newPath.closePath();
        } else {
            newPath.lineTo((float)end.getX(), (float)end.getY());
        }
        return newPath;
    }

    private GeneralPath convertToCurve(GeneralPath path) {
        GeneralPath newPath = new GeneralPath();
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            // empty catch block
        }
        PathIterator pi = path.getPathIterator(null);
        float[] tempCoords = new float[6];
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int segment = pi.currentSegment(tempCoords);
            at.transform(tempCoords, 0, coords, 0, 3);
            if (segment == 0) {
                newPath.moveTo(coords[0], coords[1]);
            } else if (segment == 4) {
                newPath.closePath();
            } else if (segment == 1) {
                newPath.curveTo(coords[0], coords[1], coords[0], coords[1], coords[0], coords[1]);
            }
            pi.next();
        }
        return newPath;
    }
}

