/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.List;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractSelectionTool;
import org.w3c.dom.svg.SVGElement;

public class LassoTool
extends AbstractSelectionTool {
    protected VectorCanvas canvas;
    protected GeneralPath path = new GeneralPath();

    public LassoTool() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Dimension dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            Image cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/tool_default_selection_cursor32.png"));
            this.cursor = toolkit.createCustomCursor(cursorImage, new Point(11, 7), "DEFAULT_SELECTION_CURSOR");
        }
        catch (Exception ex) {
            this.cursor = Cursor.getDefaultCursor();
        }
    }

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
        g2d.draw(this.path);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        this.canvas.getCanvasSelection().setEnabledVisible(true, true, true);
        if (this.canvas.getCursor() != this.cursor) {
            this.canvas.setCursor(this.cursor);
        }
        this.path.reset();
        this.fireMessageReceived(0, "Lasso selection. Press escape to clear selection");
        this.canvas.repaint();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.path.reset();
        this.path.moveTo(evt.getX(), evt.getY());
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        List<SVGElement> list;
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.path.closePath();
        Cursor prevCursor = this.canvas.getCursor();
        this.canvas.setCursor(Cursor.getPredefinedCursor(3));
        try {
            List<SVGElement> oldList;
            if (this.path.getBounds2D().isEmpty()) {
                list = CanvasUtilities.getSVGElementAt(this.canvas, evt.getPoint(), true);
                if (list.size() > 1) {
                    SVGElement o = list.get(0);
                    list.clear();
                    list.add(o);
                }
            } else {
                list = CanvasUtilities.getSVGElementAt(this.canvas, this.path, true);
            }
            if ((evt.getModifiersEx() & 0x40) == 64 && (oldList = this.canvas.getCanvasSelection().getSelectionList()) != null && list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    SVGElement obj = list.get(i);
                    int indexOf = oldList.indexOf(obj);
                    if (indexOf >= 0) continue;
                    oldList.add(obj);
                }
                list = oldList;
            }
            this.path.reset();
        }
        finally {
            this.canvas.setCursor(prevCursor);
        }
        List<SVGElement> selectionList = CanvasUtilities.getGraphicsElement(list);
        this.canvas.getCanvasSelection().setSelectionList(selectionList);
        this.canvas.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.path.lineTo(evt.getX(), evt.getY());
        Rectangle r = this.path.getBounds();
        this.canvas.repaint(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
    }
}

