/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.SVGSelectableNodeFilter;
import kiyut.sketsa.canvas.VectorCanvas;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGGElement;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGTRefElement;
import org.w3c.dom.svg.SVGTSpanElement;
import org.w3c.dom.svg.SVGTextElement;
import org.w3c.dom.svg.SVGUseElement;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class CanvasUtilities {
    public static boolean isSelectableGraphicsElement(Element elt) {
        boolean selectable = false;
        if (elt instanceof SVGRectElement || elt instanceof SVGCircleElement || elt instanceof SVGEllipseElement || elt instanceof SVGLineElement || elt instanceof SVGPolylineElement || elt instanceof SVGPolygonElement || elt instanceof SVGPathElement || elt instanceof SVGImageElement || elt instanceof SVGUseElement || elt instanceof SVGTextElement || elt instanceof SVGTSpanElement || elt instanceof SVGTRefElement || elt instanceof SVGSVGElement) {
            selectable = true;
        }
        return selectable;
    }

    public static boolean isSelectableContainerElement(Element elt) {
        boolean selectable = false;
        if (elt instanceof SVGSVGElement || elt instanceof SVGGElement || elt instanceof SVGAElement) {
            selectable = true;
        }
        return selectable;
    }

    public static boolean isSelectableElement(Element elt) {
        boolean selectable = false;
        if (CanvasUtilities.isSelectableGraphicsElement(elt)) {
            selectable = true;
        } else if (CanvasUtilities.isSelectableContainerElement(elt)) {
            selectable = true;
        }
        return selectable;
    }

    public static List<SVGElement> getSVGElementAt(VectorCanvas canvas, Shape shape, boolean direct) {
        SVGSelectableNodeFilter filter = new SVGSelectableNodeFilter();
        SVGDocument doc = canvas.getSVGDocument();
        DocumentTraversal travelsal = (DocumentTraversal)doc;
        TreeWalker treeWalker = travelsal.createTreeWalker(doc.getDocumentElement(), 1, filter, false);
        ArrayList<SVGElement> list = new ArrayList<SVGElement>();
        CanvasUtilities.getSVGElementAt(canvas, shape, direct, treeWalker, list);
        return list;
    }

    private static void getSVGElementAt(VectorCanvas canvas, Shape shape, boolean direct, TreeWalker treeWalker, List<SVGElement> list) {
        Node n = treeWalker.getCurrentNode();
        Node child = treeWalker.lastChild();
        while (child != null) {
            if (direct) {
                CanvasUtilities.getSVGElementAt(canvas, shape, direct, treeWalker, list);
            }
            SVGElement elt = (SVGElement)child;
            if (!direct || !CanvasUtilities.isSelectableContainerElement((Element)elt)) {
                AffineTransform tmpAt;
                Shape ts;
                GraphicsNode gn;
                CanvasModel model = canvas.getModel();
                AffineTransform at = canvas.getTransform();
                if (elt instanceof SVGRectElement || elt instanceof SVGEllipseElement || elt instanceof SVGCircleElement || elt instanceof SVGLineElement || elt instanceof SVGPolylineElement || elt instanceof SVGPolygonElement || elt instanceof SVGPathElement) {
                    gn = model.getGraphicsNode(elt);
                    if (gn instanceof ShapeNode) {
                        Shape ts2;
                        ShapeNode sn = (ShapeNode)gn;
                        try {
                            ts2 = sn.getSensitiveArea();
                        }
                        catch (NullPointerException ex) {
                            ts2 = null;
                        }
                        if (ts2 != null) {
                            AffineTransform tmpAt2 = (AffineTransform)at.clone();
                            tmpAt2.concatenate(gn.getGlobalTransform());
                            ts2 = tmpAt2.createTransformedShape(ts2);
                            Rectangle2D bounds = shape.getBounds2D();
                            if (direct) {
                                if (!ts2.contains(bounds) && ts2.intersects(bounds)) {
                                    list.add(elt);
                                }
                            } else if (ts2.intersects(bounds)) {
                                list.add(elt);
                            }
                        }
                    }
                } else if (elt instanceof SVGTextElement || elt instanceof SVGImageElement || elt instanceof SVGUseElement) {
                    gn = model.getGraphicsNode(elt);
                    if (gn != null && (ts = gn.getOutline()) != null) {
                        tmpAt = (AffineTransform)at.clone();
                        tmpAt.concatenate(gn.getGlobalTransform());
                        ts = tmpAt.createTransformedShape(ts);
                        if (ts.intersects(shape.getBounds2D())) {
                            list.add(elt);
                        }
                    }
                } else if (CanvasUtilities.isSelectableContainerElement((Element)elt) && (gn = model.getGraphicsNode(elt)) != null && (ts = gn.getOutline()) != null) {
                    tmpAt = (AffineTransform)at.clone();
                    tmpAt.concatenate(gn.getGlobalTransform());
                    ts = tmpAt.createTransformedShape(ts);
                    if (ts.intersects(shape.getBounds2D())) {
                        list.add(elt);
                    }
                }
            }
            child = treeWalker.previousSibling();
        }
        treeWalker.setCurrentNode(n);
    }

    public static List<SVGElement> getSVGElementAt(VectorCanvas canvas, Point2D point, boolean direct) {
        SVGSelectableNodeFilter filter = new SVGSelectableNodeFilter();
        SVGDocument doc = canvas.getSVGDocument();
        DocumentTraversal travelsal = (DocumentTraversal)doc;
        TreeWalker treeWalker = travelsal.createTreeWalker(doc.getDocumentElement(), 1, filter, false);
        ArrayList<SVGElement> list = new ArrayList<SVGElement>();
        CanvasUtilities.getSVGElementAt(canvas, point, direct, treeWalker, list);
        return list;
    }

    private static void getSVGElementAt(VectorCanvas canvas, Point2D point, boolean direct, TreeWalker treeWalker, List<SVGElement> list) {
        Node n = treeWalker.getCurrentNode();
        Node child = treeWalker.lastChild();
        while (child != null) {
            if (direct) {
                CanvasUtilities.getSVGElementAt(canvas, point, direct, treeWalker, list);
            }
            SVGElement elt = (SVGElement)child;
            if (!direct || !CanvasUtilities.isSelectableContainerElement((Element)elt)) {
                AffineTransform tmpAt;
                Shape ts;
                GraphicsNode gn;
                CanvasModel model = canvas.getModel();
                AffineTransform at = canvas.getTransform();
                if (elt instanceof SVGRectElement || elt instanceof SVGEllipseElement || elt instanceof SVGCircleElement || elt instanceof SVGLineElement || elt instanceof SVGPolylineElement || elt instanceof SVGPolygonElement || elt instanceof SVGPathElement) {
                    gn = model.getGraphicsNode(elt);
                    if (gn instanceof ShapeNode) {
                        Shape ts2;
                        ShapeNode sn = (ShapeNode)gn;
                        try {
                            ts2 = sn.getSensitiveArea();
                        }
                        catch (NullPointerException ex) {
                            ts2 = null;
                        }
                        if (ts2 != null) {
                            AffineTransform tmpAt2 = (AffineTransform)at.clone();
                            tmpAt2.concatenate(gn.getGlobalTransform());
                            ts2 = tmpAt2.createTransformedShape(ts2);
                            if (ts2.contains(point)) {
                                list.add(elt);
                            }
                        }
                    }
                } else if (elt instanceof SVGTextElement || elt instanceof SVGImageElement || elt instanceof SVGUseElement) {
                    gn = model.getGraphicsNode(elt);
                    if (gn != null && (ts = gn.getOutline()) != null) {
                        tmpAt = (AffineTransform)at.clone();
                        tmpAt.concatenate(gn.getGlobalTransform());
                        ts = tmpAt.createTransformedShape(ts);
                        if (ts.contains(point)) {
                            list.add(elt);
                        }
                    }
                } else if (CanvasUtilities.isSelectableContainerElement((Element)elt) && (gn = model.getGraphicsNode(elt)) != null && (ts = gn.getOutline()) != null) {
                    tmpAt = (AffineTransform)at.clone();
                    tmpAt.concatenate(gn.getGlobalTransform());
                    ts = tmpAt.createTransformedShape(ts);
                    if (ts.contains(point)) {
                        list.add(elt);
                    }
                }
            }
            child = treeWalker.previousSibling();
        }
        treeWalker.setCurrentNode(n);
    }

    public static List<SVGElement> getGraphicsElement(List<SVGElement> source) {
        ArrayList<SVGElement> dest = new ArrayList<SVGElement>();
        for (int i = 0; i < source.size(); ++i) {
            SVGElement elt = source.get(i);
            if (CanvasUtilities.isSelectableGraphicsElement((Element)elt)) {
                dest.add(elt);
                continue;
            }
            if (!CanvasUtilities.isSelectableContainerElement((Element)elt)) continue;
            SVGSelectableNodeFilter filter = new SVGSelectableNodeFilter();
            Document doc = elt.getOwnerDocument();
            DocumentTraversal travelsal = (DocumentTraversal)((Object)doc);
            TreeWalker treeWalker = travelsal.createTreeWalker((Node)elt, 1, filter, false);
            CanvasUtilities.getGraphicsElement(treeWalker, dest);
        }
        return dest;
    }

    private static void getGraphicsElement(TreeWalker treeWalker, List<SVGElement> list) {
        Node n = treeWalker.getCurrentNode();
        Node child = treeWalker.lastChild();
        while (child != null) {
            SVGElement elt = (SVGElement)child;
            if (CanvasUtilities.isSelectableContainerElement((Element)elt)) {
                CanvasUtilities.getGraphicsElement(treeWalker, list);
            } else if (CanvasUtilities.isSelectableGraphicsElement((Element)elt)) {
                list.add(elt);
            }
            child = treeWalker.previousSibling();
        }
        treeWalker.setCurrentNode(n);
    }

    public static SVGTextElement getSVGTextElementAt(VectorCanvas canvas, Point2D point) {
        SVGSelectableNodeFilter filter = new SVGSelectableNodeFilter();
        SVGDocument doc = canvas.getSVGDocument();
        DocumentTraversal travelsal = (DocumentTraversal)doc;
        TreeWalker treeWalker = travelsal.createTreeWalker(doc.getDocumentElement(), 1, filter, false);
        ArrayList<SVGElement> list = new ArrayList<SVGElement>();
        CanvasUtilities.getSVGTextElementAt(canvas, point, treeWalker, list);
        SVGTextElement elt = null;
        if (!list.isEmpty()) {
            elt = (SVGTextElement)list.get(0);
        }
        return elt;
    }

    private static void getSVGTextElementAt(VectorCanvas canvas, Point2D point, TreeWalker treeWalker, List<SVGElement> list) {
        Node n = treeWalker.getCurrentNode();
        Node child = treeWalker.lastChild();
        while (child != null) {
            CanvasUtilities.getSVGTextElementAt(canvas, point, treeWalker, list);
            SVGElement elt = (SVGElement)child;
            if (elt instanceof SVGTextElement) {
                Shape ts;
                CanvasModel model = canvas.getModel();
                AffineTransform at = canvas.getTransform();
                GraphicsNode gn = model.getGraphicsNode(elt);
                if (gn != null && (ts = gn.getBounds()) != null) {
                    AffineTransform tmpAt = (AffineTransform)at.clone();
                    tmpAt.concatenate(gn.getGlobalTransform());
                    ts = tmpAt.createTransformedShape(ts);
                    if (ts.contains(point)) {
                        list.add(elt);
                        break;
                    }
                }
            }
            child = treeWalker.previousSibling();
        }
        treeWalker.setCurrentNode(n);
    }
}

