/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import javax.swing.JOptionPane;
import kiyut.sketsa.canvas.EditorUserAgent;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.options.GeneralOptions;
import org.apache.batik.bridge.UserAgentAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class CanvasUserAgent
extends UserAgentAdapter
implements EditorUserAgent {
    protected Dimension2D viewportSize;
    protected VectorCanvas canvas;
    protected float pxToMM;
    protected Exception exception;

    public CanvasUserAgent(VectorCanvas canvas) {
        this.canvas = canvas;
        double dpi = 96.0;
        this.pxToMM = (float)(1.0 / dpi * 25.4);
    }

    public Dimension2D getViewportSize() {
        if (this.viewportSize == null) {
            this.viewportSize = new Dimension();
        }
        GeneralOptions opts = GeneralOptions.getInstance();
        int w = (int)opts.getDefaultSVGWidth();
        int h = (int)opts.getDefaultSVGHeight();
        this.viewportSize.setSize(w, h);
        return this.viewportSize;
    }

    public void displayMessage(String message) {
    }

    public void displayError(String message) {
        JOptionPane.showMessageDialog(this.canvas, message, "Message", 1);
    }

    public synchronized void displayError(Exception ex) {
        this.exception = ex;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void exceptionHandled() {
        this.exception = null;
    }

    public void showAlert(String message) {
    }

    public float getPixelUnitToMillimeter() {
        return this.pxToMM;
    }

    public SVGDocument getBrokenLinkDocument(Element e, String url, String message) {
        return this.canvas.getModel().getBrokenLinkDocument(e, url, message);
    }
}

