/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.event.CanvasSelectionEvent;
import kiyut.sketsa.canvas.event.CanvasSelectionListener;
import kiyut.sketsa.canvas.tool.MoveTool;
import kiyut.sketsa.canvas.tool.SelectionTool;
import kiyut.sketsa.canvas.tool.TextTool;
import kiyut.sketsa.canvas.tool.Tool;
import kiyut.sketsa.options.CanvasOptions;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGTextElement;

public class CanvasSelection {
    private EventListenerList listenerList = new EventListenerList();
    private List<SVGElement> selectionList = new ArrayList<SVGElement>();
    private Map<String, Rectangle2D> border = new HashMap<String, Rectangle2D>();
    private Paint strokePaint;
    private Stroke dashed;
    private int insetsWidth = 6;
    private boolean enabled = false;
    private boolean boundsVisible = true;
    private boolean handlesVisible = false;
    private VectorCanvas canvas;
    private SelectionTool selectionTool;
    private Tool cursorTool;

    public CanvasSelection() {
        for (int i = 0; i <= 9; ++i) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            this.border.put(Integer.toString(i), r);
        }
        this.resetBorder();
        float[] dash1 = new float[]{4.0f};
        this.dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
        CanvasOptions prefs = CanvasOptions.getInstance();
        this.strokePaint = prefs.getSelectionColor();
    }

    public void paint(Graphics2D g2d) {
        if (!this.boundsVisible && this.handlesVisible) {
            return;
        }
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        CanvasOptions prefs = CanvasOptions.getInstance();
        this.strokePaint = prefs.getSelectionColor();
        g2d.setPaint(this.strokePaint);
        g2d.setStroke(this.dashed);
        if (this.boundsVisible) {
            Rectangle2D r = this.border.get(Integer.toString(0));
            g2d.draw(r);
        }
        if (this.handlesVisible) {
            for (int i = 1; i <= 9; ++i) {
                Rectangle2D handle = this.border.get(Integer.toString(i));
                g2d.fill(handle);
            }
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public VectorCanvas getVectorCanvas() {
        return this.canvas;
    }

    public void setSelectionTool(SelectionTool tool) {
        this.selectionTool = tool;
    }

    public SelectionTool getSelectionTool() {
        return this.selectionTool;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public Stroke getStroke() {
        return this.dashed;
    }

    public void addSelectionListener(CanvasSelectionListener listener) {
        this.listenerList.add(CanvasSelectionListener.class, listener);
    }

    public void removeSelectionListener(CanvasSelectionListener listener) {
        this.listenerList.remove(CanvasSelectionListener.class, listener);
    }

    private void fireValueChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        CanvasSelectionEvent event = new CanvasSelectionEvent(this, this.selectionList);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CanvasSelectionListener.class) continue;
            ((CanvasSelectionListener)listeners[i + 1]).valueChanged(event);
        }
    }

    private void fireBorderChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        CanvasSelectionEvent event = new CanvasSelectionEvent(this, this.selectionList);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CanvasSelectionListener.class) continue;
            ((CanvasSelectionListener)listeners[i + 1]).borderChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        Cursor prevCursor = this.canvas.getCursor();
        this.canvas.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.selectionList != null) {
                this.selectionList.clear();
            }
            this.resetBorder();
            this.fireValueChanged();
            this.fireBorderChanged();
        }
        finally {
            this.canvas.setCursor(prevCursor);
        }
    }

    protected void resetBorder() {
        for (int i = 0; i <= 9; ++i) {
            Rectangle2D r = this.border.get(Integer.toString(i));
            r.setRect(-1.0, -1.0, -1.0, -1.0);
        }
    }

    public void setBoundsVisible(boolean boundsVisible) {
        this.boundsVisible = boundsVisible;
    }

    public boolean isBoundsVisible() {
        return this.boundsVisible;
    }

    public void setHandlesVisible(boolean handlesVisible) {
        this.handlesVisible = handlesVisible;
    }

    public boolean isHandlessVisible() {
        return this.handlesVisible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated
    public void setEnabledVisible(boolean enabled, boolean visible) {
        this.setEnabledVisible(enabled, visible, visible);
    }

    public void setEnabledVisible(boolean enabled, boolean boundsVisible, boolean handleVisible) {
        this.setEnabled(enabled);
        this.setBoundsVisible(boundsVisible);
        this.setHandlesVisible(handleVisible);
    }

    public void setVisible(boolean boundsVisible, boolean handleVisible) {
        this.setBoundsVisible(boundsVisible);
        this.setHandlesVisible(handleVisible);
    }

    public List<SVGElement> getSelectionList() {
        return this.selectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionList(List<SVGElement> selectionList) {
        if (selectionList == null) {
            this.clearSelection();
            return;
        }
        Cursor prevCursor = this.canvas.getCursor();
        this.canvas.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.selectionList = selectionList;
            this.fireValueChanged();
            this.updateBorder();
        }
        finally {
            this.canvas.setCursor(prevCursor);
        }
    }

    public Map<String, Rectangle2D> getBorder() {
        return this.border;
    }

    public Rectangle2D getSelectionBounds2D() {
        if (this.selectionList == null) {
            return null;
        }
        if (this.selectionList.size() <= 0) {
            return null;
        }
        RectangularShape bounds = null;
        AffineTransform at = (AffineTransform)this.canvas.getTransform().clone();
        CanvasModel model = this.canvas.getModel();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            Shape shape;
            SVGElement elt = this.selectionList.get(i);
            GraphicsNode gn = model.getGraphicsNode(elt);
            if (gn == null || (shape = gn.getOutline()) == null) continue;
            AffineTransform tmpAt = (AffineTransform)at.clone();
            tmpAt.concatenate(gn.getGlobalTransform());
            shape = tmpAt.createTransformedShape(shape);
            if (bounds == null) {
                bounds = shape.getBounds2D();
            }
            Rectangle2D.union(shape.getBounds2D(), (Rectangle2D)bounds, (Rectangle2D)bounds);
        }
        if (bounds != null) {
            if (bounds.getWidth() < 3.0) {
                ((Rectangle2D)bounds).setRect(bounds.getX() - 1.0, bounds.getY(), 3.0, bounds.getHeight());
            }
            if (bounds.getHeight() < 3.0) {
                ((Rectangle2D)bounds).setRect(bounds.getX(), bounds.getY() - 1.0, bounds.getWidth(), 3.0);
            }
        }
        return bounds;
    }

    @Deprecated
    public Rectangle2D getSelectionBounds2D(boolean includeInsets) {
        Rectangle2D bounds = this.getSelectionBounds2D();
        if (bounds != null) {
            Rectangle2D r = bounds.getBounds2D();
            if (includeInsets) {
                r.setRect(r.getX() - (double)this.insetsWidth, r.getY() - (double)this.insetsWidth, r.getWidth() + (double)(this.insetsWidth * 2), r.getHeight() + (double)(this.insetsWidth * 2));
            }
            bounds = r;
        }
        return bounds;
    }

    public void updateBorder() {
        Rectangle2D r = this.getSelectionBounds2D();
        if (r == null) {
            this.resetBorder();
            this.fireBorderChanged();
            return;
        }
        Rectangle2D bounds = this.border.get(Integer.toString(0));
        bounds.setRect(r);
        double x = r.getX();
        double y = r.getY();
        double w = r.getWidth();
        double h = r.getHeight();
        CanvasOptions prefs = CanvasOptions.getInstance();
        int size = prefs.getHandleSize() / 2;
        double cx = x;
        double cy = y;
        Rectangle2D handle = this.border.get(Integer.toString(1));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        cx = x + w / 2.0;
        cy = y;
        handle = this.border.get(Integer.toString(2));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        cx = x + w;
        cy = y;
        handle = this.border.get(Integer.toString(3));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        cx = x;
        cy = y + h / 2.0;
        handle = this.border.get(Integer.toString(4));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        cx = x + w / 2.0;
        cy = y + h / 2.0;
        handle = this.border.get(Integer.toString(5));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        cx = x + w;
        cy = y + h / 2.0;
        handle = this.border.get(Integer.toString(6));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        cx = x;
        cy = y + h;
        handle = this.border.get(Integer.toString(7));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        cx = x + w / 2.0;
        cy = y + h;
        handle = this.border.get(Integer.toString(8));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        cx = x + w;
        cy = y + h;
        handle = this.border.get(Integer.toString(9));
        handle.setFrameFromCenter(cx, cy, cx - (double)size, cy - (double)size);
        this.fireBorderChanged();
    }

    protected void updateCanvasTool(Tool tool) {
        Tool oldTool = this.canvas.getTool();
        if (oldTool != tool) {
            this.canvas.setTool(tool);
        }
    }

    public void keyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode == 27) {
            this.setSelectionList(new ArrayList<SVGElement>(0));
            if (this.canvas != null) {
                this.canvas.repaint();
            }
        } else if (keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40) {
            MoveTool tool = this.selectionTool.getMoveTool();
            this.updateCanvasTool(tool);
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        SVGTextElement element = CanvasUtilities.getSVGTextElementAt(this.canvas, evt.getPoint());
        if (element != null) {
            TextTool textTool = new TextTool();
            this.canvas.setTool(textTool);
        }
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
        Cursor cursor;
        if (this.selectionTool == null) {
            return;
        }
        int x = evt.getX();
        int y = evt.getY();
        int type = -1;
        for (int i = 0; i <= 9; ++i) {
            Rectangle2D handle = this.border.get(Integer.toString(i));
            if (!handle.contains(x, y)) continue;
            type = i;
            if (i > 0) break;
        }
        this.cursorTool = null;
        if (type == 0) {
            this.cursorTool = this.selectionTool.getMoveTool();
            cursor = Cursor.getPredefinedCursor(13);
        } else if (type == 1) {
            this.cursorTool = this.selectionTool.getResizeTool();
            cursor = Cursor.getPredefinedCursor(6);
        } else if (type == 2) {
            this.cursorTool = this.selectionTool.getResizeTool();
            cursor = Cursor.getPredefinedCursor(8);
        } else if (type == 3) {
            this.cursorTool = this.selectionTool.getResizeTool();
            cursor = Cursor.getPredefinedCursor(7);
        } else if (type == 4) {
            this.cursorTool = this.selectionTool.getResizeTool();
            cursor = Cursor.getPredefinedCursor(10);
        } else if (type == 5) {
            this.cursorTool = this.selectionTool.getMoveTool();
            cursor = Cursor.getPredefinedCursor(13);
        } else if (type == 6) {
            this.cursorTool = this.selectionTool.getResizeTool();
            cursor = Cursor.getPredefinedCursor(11);
        } else if (type == 7) {
            this.cursorTool = this.selectionTool.getResizeTool();
            cursor = Cursor.getPredefinedCursor(4);
        } else if (type == 8) {
            this.cursorTool = this.selectionTool.getResizeTool();
            cursor = Cursor.getPredefinedCursor(9);
        } else if (type == 9) {
            this.cursorTool = this.selectionTool.getResizeTool();
            cursor = Cursor.getPredefinedCursor(5);
        } else {
            cursor = this.selectionTool.getCursor();
            this.cursorTool = this.selectionTool;
        }
        if (cursor != null) {
            this.canvas.setCursor(cursor);
        }
    }

    public void mousePressed(MouseEvent evt) {
        this.updateCanvasTool(this.cursorTool);
    }

    public void mouseReleased(MouseEvent evt) {
    }
}

