/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.geom.Dimension2D;
import java.net.URL;
import kiyut.sketsa.canvas.CanvasUserAgent;
import kiyut.sketsa.canvas.EditorUserAgent;
import kiyut.sketsa.canvas.VectorCanvas;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.DynamicGVTBuilder;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGAnimationEngine;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

public class CanvasModel {
    private VectorCanvas canvas;
    private SVGDocument svgDocument;
    private GraphicsNode root;
    private BridgeContext bridgeContext;
    private DocumentLoader documentLoader;
    private EditorUserAgent userAgent;
    private GVTBuilder gvtBuilder;

    public CanvasModel(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public void dispose() {
        if (this.bridgeContext != null) {
            this.bridgeContext.dispose();
        }
        if (this.documentLoader != null) {
            this.documentLoader.dispose();
        }
        this.bridgeContext = null;
        this.documentLoader = null;
        this.userAgent = null;
        this.gvtBuilder = null;
        this.root = null;
        this.svgDocument = null;
    }

    public void setSVGDocument(SVGDocument doc) {
        if (!(doc instanceof SVGOMDocument)) {
            throw new IllegalArgumentException("argument doc must be an instanceof SVGOMDocument");
        }
        this.svgDocument = doc;
        this.userAgent = new CanvasUserAgent(this.canvas);
        this.documentLoader = new DocumentLoader((UserAgent)this.userAgent);
        SVGOMDocument omDoc = (SVGOMDocument)doc;
        this.bridgeContext = omDoc.isSVG12() ? new SVG12BridgeContext((UserAgent)this.userAgent, this.documentLoader) : new BridgeContext((UserAgent)this.userAgent, this.documentLoader);
        this.bridgeContext.setDynamicState(2);
        this.gvtBuilder = new DynamicGVTBuilder();
        this.root = this.gvtBuilder.build(this.bridgeContext, (Document)this.svgDocument);
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    public EditorUserAgent getEditorUserAgent() {
        return this.userAgent;
    }

    public SVGAnimationEngine getAnimationEngine() {
        if (this.bridgeContext == null) {
            return null;
        }
        return this.bridgeContext.getAnimationEngine();
    }

    public GraphicsNode getRoot() {
        return this.root;
    }

    @Deprecated
    public String getSVGNameSpace() {
        return "http://www.w3.org/2000/svg";
    }

    public SVGSVGElement getSVGSVGElement() {
        return this.svgDocument.getRootElement();
    }

    public double getSVGWidth() {
        Dimension2D dim = this.bridgeContext.getDocumentSize();
        return dim.getWidth();
    }

    public double getSVGHeight() {
        Dimension2D dim = this.bridgeContext.getDocumentSize();
        return dim.getHeight();
    }

    public void appendChild(Element element) {
        SVGSVGElement svgRoot = this.svgDocument.getRootElement();
        svgRoot.appendChild(element);
    }

    public SVGElement getSVGElement(GraphicsNode graphicsNode) {
        return (SVGElement)this.bridgeContext.getElement(graphicsNode);
    }

    public GraphicsNode getGraphicsNode(SVGElement svgElement) {
        return this.bridgeContext.getGraphicsNode((Node)svgElement);
    }

    public SVGDocument getBrokenLinkDocument(Element e, String url, String message) {
        URL blURL = this.getClass().getResource("/kiyut/sketsa/BrokenLink.svg");
        DocumentLoader loader = this.bridgeContext.getDocumentLoader();
        SVGDocument doc = null;
        try {
            doc = (SVGDocument)loader.loadDocument(blURL.toString());
            if (doc == null) {
                return doc;
            }
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            Element infoE = (doc = (SVGDocument)DOMUtilities.deepCloneDocument((Document)doc, (DOMImplementation)impl)).getElementById("__More_About");
            if (infoE == null) {
                return doc;
            }
            Element titleE = doc.createElementNS("http://www.w3.org/2000/svg", "title");
            titleE.appendChild(doc.createTextNode("Broken Link"));
            Element descE = doc.createElementNS("http://www.w3.org/2000/svg", "desc");
            descE.appendChild(doc.createTextNode(message));
            infoE.insertBefore(descE, infoE.getFirstChild());
            infoE.insertBefore(titleE, descE);
        }
        catch (Exception ex) {
            throw new BridgeException(this.bridgeContext, e, "uri.image.broken", new Object[]{url, message});
        }
        return doc;
    }
}

