/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import java.awt.EventQueue;
import java.util.List;
import kiyut.sketsa.actions.AbstractEditorAction;
import kiyut.sketsa.actions.FlipHorizontalAction;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.tool.TransformPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.w3c.dom.svg.SVGElement;

public class TransformDialogAction
extends AbstractEditorAction {
    public void performAction() {
        if (this.editorCookie == null) {
            return;
        }
        VectorCanvas canvas = this.editorCookie.getVectorCanvas();
        List<SVGElement> selectionList = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (selectionList.isEmpty()) {
            String msg = NbBundle.getMessage(FlipHorizontalAction.class, (String)"MSG_SelectionEmpty.Text");
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        final TransformPane pane = new TransformPane();
        pane.setVectorCanvas(canvas);
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)pane, pane.getTitle());
        dialogDesc.setModal(true);
        Object choice = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
        if (!choice.equals(DialogDescriptor.OK_OPTION)) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                pane.updateVectorCanvas();
                pane.setVectorCanvas(null);
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(TransformDialogAction.class, (String)"CTL_TransformDialogAction");
    }
}

