/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import java.awt.EventQueue;
import java.util.List;
import kiyut.sketsa.actions.AbstractEditorAction;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.w3c.dom.svg.SVGElement;

public class MoveBottomAction
extends AbstractEditorAction {
    public void performAction() {
        if (this.editorCookie == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VectorCanvas canvas = MoveBottomAction.this.editorCookie.getVectorCanvas();
                List<SVGElement> selectionList = canvas.getCanvasSelection().getSelectionList();
                if (selectionList.isEmpty()) {
                    String msg = NbBundle.getMessage(MoveBottomAction.class, (String)"MSG_SelectionEmpty.Text");
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                DOMUndoManager undoManager = canvas.getUndoManager();
                undoManager.start("Move Bottom");
                try {
                    canvas.moveBottomSelection();
                }
                catch (Exception ex) {
                    undoManager.cancel();
                    String msg = NbBundle.getMessage(MoveBottomAction.class, (String)"MSG_CanvasException.Text");
                    String desc = ex.getMessage().trim();
                    if (desc.length() > 0) {
                        msg = msg + System.getProperty("line.separator") + desc;
                    }
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                finally {
                    undoManager.end();
                    canvas.refresh();
                }
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(MoveBottomAction.class, (String)"CTL_MoveBottomAction");
    }
}

