/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import kiyut.sketsa.options.MRUFilesOptions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class MRUFilesAction
extends CallableSystemAction {
    public void performAction() {
    }

    public String getName() {
        return NbBundle.getMessage(MRUFilesAction.class, (String)"CTL_MRUFilesAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getMenuPresenter() {
        MRUFilesMenu menu = new MRUFilesMenu(this.getName());
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)this.getName());
        return menu;
    }

    class MRUFilesMenu
    extends JMenu
    implements DynamicMenuContent {
        public MRUFilesMenu(String s) {
            super(s);
            MRUFilesOptions opts = MRUFilesOptions.getInstance();
            opts.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!evt.getPropertyName().equals("MRUFileList")) {
                        return;
                    }
                    MRUFilesMenu.this.updateMenu();
                }
            });
            this.updateMenu();
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        private void updateMenu() {
            this.removeAll();
            MRUFilesOptions opts = MRUFilesOptions.getInstance();
            List<String> list = opts.getMRUFileList();
            for (int i = 0; i < list.size(); ++i) {
                String name = list.get(i);
                Action action = this.createAction(name);
                action.putValue("Name", name);
                JMenuItem menuItem = new JMenuItem(action);
                this.add(menuItem);
            }
        }

        private Action createAction(String actionCommand) {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MRUFilesMenu.this.menuItemActionPerformed(e);
                }
            };
            action.putValue("ActionCommandKey", actionCommand);
            return action;
        }

        private void menuItemActionPerformed(ActionEvent evt) {
            String command = evt.getActionCommand();
            File file = new File(command);
            try {
                DataObject data = DataObject.find((FileObject)FileUtil.toFileObject((File)file));
                OpenCookie cookie = (OpenCookie)data.getCookie(OpenCookie.class);
                cookie.open();
            }
            catch (Exception ex) {
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

