/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.WeakHashMap;
import javax.swing.JMenuItem;
import kiyut.sketsa.cookies.SVGEditorCookie;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.actions.BooleanStateAction;

public abstract class AbstractEditorBooleanStateAction
extends BooleanStateAction {
    protected Lookup context;
    protected Lookup.Result<SVGEditorCookie> result;
    protected LookupListener editorCookieLookupListener;
    protected SVGEditorCookie editorCookie;
    private WeakHashMap<JMenuItem, WeakReference<JMenuItem>> menuItemsMap = new WeakHashMap();

    public AbstractEditorBooleanStateAction() {
        this(Utilities.actionsGlobalContext());
    }

    private AbstractEditorBooleanStateAction(Lookup context) {
        this.setBooleanState(false);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractEditorBooleanStateAction.this.propertyChange(evt);
            }
        });
        this.editorCookieLookupListener = new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                AbstractEditorBooleanStateAction.this.editorCookieLookupListenerResultChanged(lookupEvent);
            }
        };
        this.result = context.lookupResult(SVGEditorCookie.class);
        this.result.addLookupListener(this.editorCookieLookupListener);
        this.editorCookieLookupListenerResultChanged(null);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected abstract void propertyChange(PropertyChangeEvent var1);

    protected void editorCookieLookupListenerResultChanged(LookupEvent evt) {
        boolean b;
        Collection c = this.result.allInstances();
        if (!c.isEmpty()) {
            this.editorCookie = (SVGEditorCookie)c.iterator().next();
        } else if (this.editorCookie != null && !this.editorCookie.isOpened()) {
            this.editorCookie = null;
            this.setBooleanState(false);
        }
        boolean bl = b = this.editorCookie != null;
        if (this.isEnabled() != b) {
            this.setEnabled(b);
        }
    }

    public JMenuItem getMenuPresenter() {
        JMenuItem menuItem = super.getMenuPresenter();
        this.menuItemsMap.put(menuItem, new WeakReference<JMenuItem>(menuItem));
        return menuItem;
    }

    public void setBooleanState(boolean value) {
        super.setBooleanState(value);
        for (JMenuItem menuItem : this.menuItemsMap.keySet()) {
            menuItem.setSelected(value);
        }
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        for (JMenuItem menuItem : this.menuItemsMap.keySet()) {
            menuItem.setEnabled(value);
        }
    }
}

