/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa;

import java.awt.Image;
import java.util.ResourceBundle;
import org.openide.windows.WindowManager;

public class Application {
    private String name;
    private String fullName;
    private String version;
    private String buildNumber;
    private boolean beta = false;
    private Image iconImage;
    private ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getName());
    private static Application instance = new Application();

    private Application() {
        this.name = this.bundle.getString("title");
        this.fullName = this.bundle.getString("title.full");
        this.version = this.bundle.getString("version");
        this.buildNumber = this.bundle.getString("buildnumber");
        if (this.version.indexOf("beta") != -1) {
            this.beta = true;
        }
    }

    public static String getMessage(String resName) {
        return Application.instance.bundle.getString(resName);
    }

    public static String getName() {
        return Application.instance.name;
    }

    public static String getFullName() {
        return Application.instance.fullName;
    }

    public static String getFullNameVersion() {
        return Application.instance.fullName + " " + Application.instance.version;
    }

    public static String getVersion() {
        return Application.instance.version;
    }

    public static String getBuildNumber() {
        return Application.instance.buildNumber;
    }

    public static boolean isBeta() {
        return Application.instance.beta;
    }

    public static Image getIconImage() {
        if (Application.instance.iconImage == null) {
            Application.instance.iconImage = WindowManager.getDefault().getMainWindow().getIconImage();
        }
        return Application.instance.iconImage;
    }
}

