/*
 * Decompiled with CFR 0.152.
 */
package org.java.ayatana;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.ImageIcon;

public final class AyatanaDesktop {
    private static String toHexadecimal(byte[] digest) {
        String hash = "";
        for (byte aux : digest) {
            int b = aux & 0xFF;
            if (Integer.toHexString(b).length() == 1) {
                hash = hash + "0";
            }
            hash = hash + Integer.toHexString(b);
        }
        return hash;
    }

    public static String getMD5Checksum(InputStream input) {
        try {
            int read;
            byte[] buff = new byte[1024];
            MessageDigest md = MessageDigest.getInstance("MD5");
            while ((read = input.read(buff)) > 0) {
                md.update(buff, 0, read);
            }
            return AyatanaDesktop.toHexadecimal(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSupported() {
        if (!"true".equals(System.getProperty("jayatana.force"))) {
            if (!System.getProperty("os.name").contains("Linux")) {
                return false;
            }
            if (!"Unity".equals(System.getenv("XDG_CURRENT_DESKTOP"))) {
                return false;
            }
            String version = System.getProperty("java.version");
            version = version.substring(0, version.indexOf(".", version.indexOf(".") + 1));
            try {
                float iversion = Float.parseFloat(version);
                if (System.getProperty("java.vm.name").contains("OpenJDK") && iversion < 1.7f) {
                    return false;
                }
                if (iversion < 1.6f) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean tryInstallIcon(String name, URL urlIcon) {
        return AyatanaDesktop.tryInstallIcon(name, "hicolor", urlIcon);
    }

    public static boolean tryInstallIcon(String name, String theme, URL urlIcon) {
        if (!AyatanaDesktop.isSupported()) {
            return false;
        }
        ImageIcon icon = new ImageIcon(urlIcon);
        if (icon.getIconHeight() != icon.getIconWidth()) {
            throw new RuntimeException("the icon is not 1:1");
        }
        switch (icon.getIconWidth()) {
            case 16: 
            case 24: 
            case 32: 
            case 48: 
            case 128: 
            case 256: {
                break;
            }
            default: {
                throw new RuntimeException("invalid size icon, only support 16x16 24x24 32x32 48x48 128x128 256x256");
            }
        }
        String urlIconName = urlIcon.toString();
        String extensionIconName = urlIconName.substring(urlIconName.lastIndexOf(".") + 1);
        File iconFile = new File(System.getProperty("user.home"), ".local/share/icons/" + theme + "/" + icon.getIconWidth() + "x" + icon.getIconWidth() + "/apps/" + name + "." + extensionIconName);
        if (iconFile.exists() && iconFile.isFile()) {
            String iconSourceMD5;
            String iconTargetMD5;
            try {
                FileInputStream fis = new FileInputStream(iconFile);
                iconTargetMD5 = AyatanaDesktop.getMD5Checksum(fis);
                fis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                InputStream inputSource = urlIcon.openStream();
                iconSourceMD5 = AyatanaDesktop.getMD5Checksum(inputSource);
                inputSource.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!iconSourceMD5.equals(iconTargetMD5)) {
                iconFile.getParentFile().mkdirs();
                try {
                    int read;
                    InputStream input = urlIcon.openStream();
                    FileOutputStream fos = new FileOutputStream(iconFile);
                    byte[] buff = new byte[1024];
                    while ((read = input.read(buff)) > 0) {
                        fos.write(buff, 0, read);
                    }
                    fos.flush();
                    fos.close();
                    input.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    Runtime.getRuntime().exec("xdg-icon-resource forceupdate");
                }
                catch (IOException e) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        iconFile.getParentFile().mkdirs();
        try {
            int read;
            InputStream input = urlIcon.openStream();
            FileOutputStream fos = new FileOutputStream(iconFile);
            byte[] buff = new byte[1024];
            while ((read = input.read(buff)) > 0) {
                fos.write(buff, 0, read);
            }
            fos.flush();
            fos.close();
            input.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Runtime.getRuntime().exec("xdg-icon-resource forceupdate");
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }
}

