/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.ButtonCellEditor;
import org.netbeans.modules.options.keymap.ButtonCellRenderer;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.Popupable;
import org.netbeans.modules.options.keymap.ProfilesPanel;
import org.netbeans.modules.options.keymap.ShortcutCellPanel;
import org.netbeans.modules.options.keymap.ShortcutListener;
import org.netbeans.modules.options.keymap.ShortcutPopupPanel;
import org.netbeans.modules.options.keymap.SpecialkeyPanel;
import org.netbeans.modules.options.keymap.TableSorter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KeymapPanel
extends JPanel
implements ActionListener,
Popupable {
    private static final int SEARCH_DELAY_TIME_LONG = 300;
    private static final int SEARCH_DELAY_TIME_SHORT = 20;
    private volatile KeymapViewModel keymapModel;
    private TableSorter sorter;
    private JPopupMenu popup = new JPopupMenu();
    private Popup searchPopup;
    private SpecialkeyPanel specialkeyList;
    private JTable actionsTable;
    private JComboBox cbProfile;
    private JScrollPane jScrollPane1;
    private JLabel lProfile;
    private JList liShortcuts;
    private JButton manageButton;
    private JButton moreButton;
    private JTextField searchField;
    private JLabel searchLabel;
    private JTextField searchSCField;
    private JLabel searchSCLabel;
    private JScrollPane spShortcuts;

    public KeymapPanel() {
        this.sorter = new TableSorter(this.getModel());
        this.initComponents();
        this.specialkeyList = new SpecialkeyPanel(this, this.searchSCField);
        this.sorter.setTableHeader(this.actionsTable.getTableHeader());
        this.sorter.getTableHeader().setReorderingAllowed(false);
        this.actionsTable.setSelectionMode(0);
        this.actionsTable.setAutoscrolls(true);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.getModel().setSearchText(KeymapPanel.this.searchField.getText());
                KeymapPanel.this.getModel().update();
            }
        };
        final Timer searchDelayTimer = new Timer(300, al);
        searchDelayTimer.setRepeats(false);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                KeymapPanel.this.searchSCField.setText("");
                ((ShortcutListener)KeymapPanel.this.searchSCField.getKeyListeners()[0]).clear();
                if (KeymapPanel.this.searchField.getText().length() > 3) {
                    searchDelayTimer.setInitialDelay(20);
                }
                searchDelayTimer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (KeymapPanel.this.searchField.getText().length() > 3) {
                    searchDelayTimer.setInitialDelay(300);
                }
                searchDelayTimer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                KeymapPanel.this.searchSCField.setText("");
                KeymapPanel.this.getModel().setSearchText(KeymapPanel.this.searchField.getText());
                KeymapPanel.this.getModel().update();
            }
        });
        this.searchSCField.addKeyListener(new ShortcutListener(false));
        ActionListener al2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeymapPanel.this.narrowByShortcut();
            }
        };
        final Timer searchDelayTimer2 = new Timer(20, al2);
        searchDelayTimer2.setRepeats(false);
        this.searchSCField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                KeymapPanel.this.searchField.setText("");
                searchDelayTimer2.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                searchDelayTimer2.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                searchDelayTimer2.restart();
            }
        });
        this.actionsTable.addMouseListener(new ButtonCellMouseListener(this.actionsTable));
        this.actionsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 525 && e.getKeyCode() != 113) {
                    return;
                }
                int leadRow = KeymapPanel.this.actionsTable.getSelectionModel().getLeadSelectionIndex();
                int leadColumn = KeymapPanel.this.actionsTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (leadRow != -1 && leadColumn != -1 && !KeymapPanel.this.actionsTable.isEditing()) {
                    KeymapPanel.this.showPopupMenu(leadRow, leadColumn, -1, -1);
                    e.consume();
                }
            }
        });
        TableColumn column = this.actionsTable.getColumnModel().getColumn(1);
        column.setCellEditor(new ButtonCellEditor(this.getModel()));
        column.setCellRenderer(new ButtonCellRenderer(this.actionsTable.getDefaultRenderer(ButtonCellRenderer.class)));
        this.setColumnWidths();
        this.popup.add(new ShortcutPopupPanel(this.actionsTable, this.popup));
        this.cbProfile.addActionListener(this);
        this.manageButton.addActionListener(this);
    }

    private void narrowByShortcut() {
        if (this.searchSCField.getText().length() != 0) {
            final String searchText = this.searchSCField.getText();
            this.getModel().runWithoutEvents(new Runnable(){

                @Override
                public void run() {
                    KeymapPanel.this.getModel().getDataVector().removeAllElements();
                    for (String categorySet : KeymapPanel.this.getModel().getCategories().keySet()) {
                        for (String category : KeymapPanel.this.getModel().getCategories().get(categorySet)) {
                            for (Object o : KeymapPanel.this.getModel().getItems(category)) {
                                if (!(o instanceof ShortcutAction)) continue;
                                ShortcutAction sca = (ShortcutAction)o;
                                String[] shortcuts = KeymapPanel.this.getModel().getShortcuts(sca);
                                for (int i = 0; i < shortcuts.length; ++i) {
                                    String shortcut = shortcuts[i];
                                    if (!KeymapPanel.this.searched(shortcut, searchText)) continue;
                                    KeymapPanel.this.getModel().addRow(new Object[]{new ActionHolder(sca, false), shortcut, category, ""});
                                }
                            }
                        }
                    }
                }
            });
            this.getModel().fireTableDataChanged();
        } else {
            this.getModel().update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeymapViewModel getModel() {
        if (this.keymapModel == null) {
            KeymapViewModel tmpModel = new KeymapViewModel();
            KeymapPanel keymapPanel = this;
            synchronized (keymapPanel) {
                if (this.keymapModel == null) {
                    this.keymapModel = tmpModel;
                }
            }
        }
        return this.keymapModel;
    }

    void applyChanges() {
        this.stopCurrentCellEditing();
        this.getModel().apply();
    }

    void cancel() {
        this.stopCurrentCellEditing();
        if (this.keymapModel == null) {
            return;
        }
        this.keymapModel.cancel();
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.getModel().isChanged();
    }

    void update() {
        this.getModel().refreshActions();
        this.getModel().setSearchText("");
        this.searchSCField.setText("");
        ((ShortcutListener)this.searchSCField.getKeyListeners()[0]).clear();
        this.searchField.setText("");
        this.getModel().update();
        this.refreshProfileCombo();
    }

    private void refreshProfileCombo() {
        String currentProfile = this.getModel().getCurrentProfile();
        List<String> keymaps = this.getModel().getProfiles();
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(keymaps.toArray());
        this.cbProfile.setModel(model);
        this.cbProfile.setSelectedItem(currentProfile);
    }

    private void stopCurrentCellEditing() {
        int row = this.actionsTable.getEditingRow();
        int col = this.actionsTable.getEditingColumn();
        if (row != -1) {
            this.actionsTable.getCellEditor(row, col).stopCellEditing();
        }
    }

    private boolean searched(String shortcut, String searchText) {
        return searchText.length() == 0 || shortcut.startsWith(searchText) || shortcut.contains(searchText);
    }

    private void setColumnWidths() {
        TableColumn column = null;
        block6: for (int i = 0; i < this.actionsTable.getColumnCount(); ++i) {
            column = this.actionsTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(250);
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(175);
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(60);
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(60);
                }
            }
        }
    }

    private void initComponents() {
        this.lProfile = new JLabel();
        this.cbProfile = new JComboBox();
        this.manageButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.actionsTable = new KeymapTable();
        this.spShortcuts = new JScrollPane();
        this.liShortcuts = new JList();
        this.searchField = new JTextField();
        this.searchLabel = new JLabel();
        this.searchSCLabel = new JLabel();
        this.searchSCField = new JTextField();
        this.moreButton = new JButton();
        this.lProfile.setLabelFor(this.cbProfile);
        Mnemonics.setLocalizedText((JLabel)this.lProfile, (String)NbBundle.getMessage(KeymapPanel.class, (String)"CTL_Keymap_Name"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(KeymapPanel.class, (String)"CTL_Duplicate"));
        this.actionsTable.setModel(this.sorter);
        this.jScrollPane1.setViewportView(this.actionsTable);
        this.spShortcuts.setViewportView(this.liShortcuts);
        this.searchField.setText(NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchField.text"));
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText((JLabel)this.searchLabel, (String)NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchLabel.text"));
        this.searchSCLabel.setLabelFor(this.searchSCField);
        Mnemonics.setLocalizedText((JLabel)this.searchSCLabel, (String)NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchSCLabel.text"));
        this.searchSCField.setText(NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchSCField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.moreButton.text"));
        this.moreButton.setBorder(BorderFactory.createEtchedBorder());
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeymapPanel.this.moreButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 577, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(103, Short.MAX_VALUE).addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchSCLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchSCField, -2, 125, -2).addGap(0, 0, 0).addComponent(this.moreButton)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spShortcuts, -2, 175, -2).addGroup(layout.createSequentialGroup().addComponent(this.lProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbProfile, 0, 379, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manageButton)))))).addGap(0, 0, 0)));
        layout.linkSize(0, this.searchField, this.searchSCField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lProfile).addComponent(this.cbProfile, -2, -1, -2).addComponent(this.manageButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moreButton).addComponent(this.searchSCField, -2, -1, -2).addComponent(this.searchSCLabel).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchLabel)).addGap(12, 12, 12).addComponent(this.jScrollPane1, -1, 321, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.spShortcuts, -2, 0, -2).addContainerGap()));
        this.searchField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KeymapPanel.class, (String)"KeymapPanel.searchField.AccessibleContext.accessibleDescription"));
    }

    private void moreButtonActionPerformed(ActionEvent evt) {
        JComponent tf = (JComponent)evt.getSource();
        Point p = new Point(tf.getX(), tf.getY());
        SwingUtilities.convertPointToScreen(p, this);
        this.searchPopup = PopupFactory.getSharedInstance().getPopup(this, this.specialkeyList, p.x, p.y);
        this.searchPopup.show();
    }

    @Override
    public Popup getPopup() {
        return this.searchPopup;
    }

    private boolean showPopupMenu(int row, int col, int x, int y) {
        JTable table = this.actionsTable;
        if (col != 1) {
            return false;
        }
        Object valueAt = table.getValueAt(row, col);
        ShortcutCellPanel scCell = (ShortcutCellPanel)table.getCellRenderer(row, col).getTableCellRendererComponent(table, valueAt, true, true, row, col);
        Rectangle cellRect = table.getCellRect(row, col, false);
        JButton button = scCell.getButton();
        if (x < 0 || x > cellRect.x + cellRect.width - button.getWidth()) {
            boolean isShortcutSet = scCell.getTextField().getText().length() != 0;
            final ShortcutPopupPanel panel = (ShortcutPopupPanel)this.popup.getComponents()[0];
            panel.setDisplayAddAlternative(isShortcutSet);
            panel.setRow(row);
            if (x == -1 || y == -1) {
                x = button.getX() + 1;
                y = button.getY() + 1;
            }
            this.popup.show(table, x, y);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    panel.requestFocus();
                }
            });
            this.popup.requestFocus();
            return true;
        }
        return false;
    }

    static String loc(String key) {
        return NbBundle.getMessage(KeymapPanel.class, (String)key);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cbProfile) {
            String profile = (String)this.cbProfile.getSelectedItem();
            if (profile != null) {
                this.getModel().setCurrentProfile(profile);
            }
            this.getModel().update();
        } else if (source == this.manageButton) {
            Map<String, Map<ShortcutAction, Set<String>>> modifiedProfiles = this.getModel().getModifiedProfiles();
            Set<String> deletedProfiles = this.getModel().getDeletedProfiles();
            ProfilesPanel profilesPanel = new ProfilesPanel(this);
            DialogDescriptor dd = new DialogDescriptor((Object)profilesPanel, NbBundle.getMessage(KeymapPanel.class, (String)"CTL_Manage_Keymap_Profiles"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (dd.getValue().equals(DialogDescriptor.OK_OPTION)) {
                String selectedProfile = profilesPanel.getSelectedProfile();
                this.getModel().setCurrentProfile(selectedProfile);
                this.refreshProfileCombo();
            } else {
                this.getModel().setModifiedProfiles(modifiedProfiles);
                this.getModel().setDeletedProfiles(deletedProfiles);
            }
        }
    }

    class ButtonCellMouseListener
    implements MouseListener {
        private JTable table;

        public ButtonCellMouseListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void forwardEvent(MouseEvent e) {
            int col;
            Point p = new Point(e.getX(), e.getY());
            int row = this.table.rowAtPoint(p);
            if (KeymapPanel.this.showPopupMenu(row, col = this.table.columnAtPoint(p), e.getX(), e.getY())) {
                e.consume();
            }
        }
    }

    private class KeymapTable
    extends JTable {
        int lastRow;
        int lastColumn;
        private String selectedActionId;

        private KeymapTable() {
        }

        @Override
        public boolean editCellAt(int row, int column) {
            this.lastRow = row;
            this.lastColumn = column;
            boolean editCellAt = super.editCellAt(row, column);
            ((DefaultCellEditor)this.getCellEditor(this.lastRow, this.lastColumn)).getComponent().requestFocus();
            return editCellAt;
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (!this.isEditing()) {
                super.processKeyEvent(e);
            } else {
                Component component = ((DefaultCellEditor)this.getCellEditor(this.lastRow, this.lastColumn)).getComponent();
                component.requestFocus();
                component.dispatchEvent(new KeyEvent(component, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar()));
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (!e.getValueIsAdjusting()) {
                int index = this.getSelectedRow();
                this.selectedActionId = this.getActionId(index);
            }
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            String aid = this.selectedActionId;
            int colIndex = this.getSelectedColumn();
            super.sorterChanged(e);
            this.restoreSelection(aid, colIndex);
        }

        private void restoreSelection(String id, int colIndex) {
            if (id == null) {
                this.clearSelection();
                return;
            }
            TableModel tm = this.getModel();
            for (int i = 0; i < tm.getRowCount(); ++i) {
                ActionHolder ah = (ActionHolder)tm.getValueAt(i, 0);
                if (ah == null || !id.equals(ah.getAction().getId())) continue;
                this.changeSelection(i, colIndex, false, false);
                break;
            }
        }

        private String getActionId(int modelIndex) {
            ActionHolder h;
            if (modelIndex >= 0 && modelIndex < this.getModel().getRowCount() && (h = (ActionHolder)this.getModel().getValueAt(modelIndex, 0)) != null) {
                ShortcutAction sa = h.getAction();
                return sa.getId();
            }
            return null;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            String aid = this.selectedActionId;
            int colIndex = this.getSelectedColumn();
            super.tableChanged(e);
            this.restoreSelection(aid, colIndex);
        }
    }
}

