/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.toolbox;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.tool.DropperTool;
import kiyut.sketsa.canvas.tool.SelectionTool;
import kiyut.sketsa.cookies.SVGEditorCookie;
import kiyut.sketsa.event.MessageEvent;
import kiyut.sketsa.event.MessageListener;
import kiyut.sketsa.loaders.SVGEditorSupport;
import kiyut.sketsa.loaders.event.SVGEditorSupportEvent;
import kiyut.sketsa.loaders.event.SVGEditorSupportListenerAdapter;
import kiyut.sketsa.windows.canvas.CanvasTopComponent;
import kiyut.sketsa.windows.toolbox.AbstractToolAction;
import kiyut.swing.button.ComboToggleButton;
import org.openide.awt.UndoRedo;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ToolboxTopComponent", persistenceType=0)
public final class ToolboxTopComponent
extends TopComponent {
    private static final String ITEM_FOLDER_NAME = "Sketsa/Toolbox/Items";
    private Lookup.Result<SVGEditorCookie> result;
    private LookupListener editorCookieLookupListener;
    private UndoRedo undoRedo;
    private SVGEditorCookie editorCookie;
    private ButtonGroup buttonGroup;
    private Dimension itemComponentSize;
    private Insets itemComponentMargin;
    private ToolMessageListener toolMessageListener;
    private ToolItemListener toolItemListener;
    private AbstractToolAction selectedToolAction;
    private List<AbstractToolAction> actionToolList;

    private ToolboxTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ToolboxTopComponent.class, (String)"CTL_ToolboxTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ToolboxTopComponent.class, (String)"HINT_ToolboxTopComponent"));
        this.initCustomComponents();
        this.editorCookieLookupListener = new LookupListener(){

            public void resultChanged(LookupEvent evt) {
                ToolboxTopComponent.this.editorCookieLookupListenerResultChanged(evt);
            }
        };
        SVGEditorSupport.getListenerRegistry().addListener(new SVGEditorSupportListenerAdapter(){

            @Override
            public void documentReverted(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            @Override
            public void documentReplaced(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            @Override
            public void documentClosed(SVGEditorSupportEvent evt) {
                this.lookupListenerResultChanged(evt);
            }

            private void lookupListenerResultChanged(SVGEditorSupportEvent evt) {
                TopComponent tc = evt.getTopComponent();
                if (tc != null) {
                    Lookup.Result r = tc.getLookup().lookupResult(SVGEditorCookie.class);
                    ToolboxTopComponent.this.editorCookieLookupListenerResultChanged(null);
                }
            }
        });
        this.result = Utilities.actionsGlobalContext().lookupResult(SVGEditorCookie.class);
        this.result.addLookupListener(this.editorCookieLookupListener);
    }

    private void initComponents() {
        this.setLayout(new FlowLayout());
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public UndoRedo getUndoRedo() {
        if (this.undoRedo == null) {
            return super.getUndoRedo();
        }
        return this.undoRedo;
    }

    private void initCustomComponents() {
        this.itemComponentSize = new Dimension(28, 28);
        this.itemComponentMargin = new Insets(2, 2, 2, 2);
        this.toolMessageListener = new ToolMessageListener();
        this.toolItemListener = new ToolItemListener();
        this.actionToolList = new ArrayList<AbstractToolAction>();
        this.buildToolboxItems();
        FileObject fo = FileUtil.getConfigRoot().getFileObject(ITEM_FOLDER_NAME);
        fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){
            private boolean valid = false;

            public void fileFolderCreated(FileEvent fe) {
                this.rebuiltToolbox();
            }

            public void fileDataCreated(FileEvent fe) {
                this.rebuiltToolbox();
            }

            public void fileChanged(FileEvent fe) {
                this.rebuiltToolbox();
            }

            public void fileDeleted(FileEvent fe) {
                this.rebuiltToolbox();
            }

            public void fileRenamed(FileRenameEvent fe) {
                this.rebuiltToolbox();
            }

            public void fileAttributeChanged(FileAttributeEvent fe) {
                this.rebuiltToolbox();
            }

            public void rebuiltToolbox() {
                this.valid = false;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (valid) {
                            return;
                        }
                        ToolboxTopComponent.this.buildToolboxItems();
                        valid = true;
                    }
                });
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolboxTopComponent.this.setMinimumSize(new Dimension(50, 50));
                        ToolboxTopComponent.this.revalidate();
                    }
                });
            }
        });
    }

    private void editorCookieLookupListenerResultChanged(LookupEvent evt) {
        Collection c = this.result.allInstances();
        if (!c.isEmpty()) {
            SVGEditorCookie cookie = (SVGEditorCookie)c.iterator().next();
            if (cookie.isOpened()) {
                this.editorCookie = cookie;
                this.updateToolActionEditorCookie(false);
                this.undoRedo = cookie.getUndoRedo();
            } else {
                this.editorCookie = null;
                this.undoRedo = null;
            }
        }
    }

    private void updateToolActionEditorCookie(boolean forceUpdate) {
        if (this.editorCookie == null) {
            return;
        }
        CanvasTopComponent canvasTC = this.editorCookie.getVectorCanvasTopComponent();
        if (canvasTC == null) {
            return;
        }
        if (!forceUpdate && canvasTC.getVectorCanvas().getTool() instanceof DropperTool) {
            return;
        }
        if (this.selectedToolAction == null) {
            canvasTC.getVectorCanvas().setTool(null);
        } else {
            canvasTC.getVectorCanvas().setTool(this.selectedToolAction.getTool());
            if (this.selectedToolAction.getTool() instanceof SelectionTool) {
                SelectionTool selectionTool = (SelectionTool)this.selectedToolAction.getTool();
                canvasTC.getVectorCanvas().getCanvasSelection().setSelectionTool(selectionTool);
            }
        }
    }

    private void removeAllItems() {
        for (int i = 0; i < this.actionToolList.size(); ++i) {
            AbstractToolAction action = this.actionToolList.get(i);
            action.setSVGEditorCookie(null);
            action.getTool().removeMessageListener(this.toolMessageListener);
        }
        this.actionToolList.clear();
        this.removeAll();
        this.selectedToolAction = null;
        this.clearSelectedButton();
        if (this.editorCookie == null) {
            return;
        }
        CanvasTopComponent canvasTC = this.editorCookie.getVectorCanvasTopComponent();
        if (canvasTC != null) {
            canvasTC.getVectorCanvas().setTool(null);
        }
    }

    private void clearSelectedButton() {
        if (this.buttonGroup != null) {
            this.buttonGroup.clearSelection();
        }
        this.selectedToolAction = null;
        this.updateToolActionEditorCookie(false);
    }

    private void buildToolboxItems() {
        FileObject fo = FileUtil.getConfigRoot().getFileObject(ITEM_FOLDER_NAME);
        if (fo == null) {
            return;
        }
        this.removeAllItems();
        this.buttonGroup = new ButtonGroup();
        this.buildToolboxItems(fo, (JComponent)((Object)this), this.buttonGroup);
        this.clearSelectedButton();
        this.revalidate();
        this.repaint();
    }

    private void buildToolboxItems(FileObject fo, JComponent comp, ButtonGroup buttonGroup) {
        DataFolder df = DataFolder.findFolder((FileObject)fo);
        DataObject[] childs = df.getChildren();
        for (int i = 0; i < childs.length; ++i) {
            Object instanceObj;
            DataObject dob = childs[i];
            if (dob.getPrimaryFile().isFolder()) {
                FileObject childFo = childs[i].getPrimaryFile();
                ComboToggleButton comboButton = new ComboToggleButton();
                this.configureToolboxItem(comboButton);
                this.buildToolboxItems(childFo, comboButton.getPopupMenu(), new ButtonGroup());
                comboButton.addItemListener(this.toolItemListener);
                comboButton.addActionListener(this.toolItemListener);
                MenuElement[] menuItems = comboButton.getPopupMenu().getSubElements();
                if (menuItems != null) {
                    for (int v = 0; v < menuItems.length; ++v) {
                        if (!(menuItems[v] instanceof JRadioButtonMenuItem)) continue;
                        JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)menuItems[v];
                        menuItem.setSelected(true);
                        break;
                    }
                }
                comp.add(comboButton);
                buttonGroup.add(comboButton);
                continue;
            }
            InstanceCookie ck = (InstanceCookie)dob.getCookie(InstanceCookie.class);
            try {
                instanceObj = ck.instanceCreate();
            }
            catch (Exception ex) {
                instanceObj = null;
                Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            if (!(instanceObj instanceof AbstractToolAction)) {
                Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
                logger.log(Level.WARNING, "Toolbox Item should be instanceof AbstractToolAction");
                continue;
            }
            AbstractToolAction action = (AbstractToolAction)((Object)instanceObj);
            AbstractButton toolComp = null;
            if (comp.equals((Object)this)) {
                toolComp = new JToggleButton((Action)((Object)action));
                this.configureToolboxItem(toolComp);
                toolComp.setToolTipText(action.getName());
            } else {
                toolComp = new JRadioButtonMenuItem((Action)((Object)action));
            }
            if (toolComp == null) continue;
            comp.add(toolComp);
            buttonGroup.add(toolComp);
            this.actionToolList.add(action);
            toolComp.addItemListener(this.toolItemListener);
            toolComp.addActionListener(this.toolItemListener);
            action.getTool().addMessageListener(this.toolMessageListener);
        }
    }

    private void configureToolboxItem(AbstractButton button) {
        button.setText("");
        button.setMargin(this.itemComponentMargin);
        button.setPreferredSize(this.itemComponentSize);
        button.setMaximumSize(this.itemComponentSize);
        button.setFocusPainted(false);
        button.setRolloverEnabled(true);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AbstractButton btn = (AbstractButton)evt.getSource();
                if (!btn.isSelected()) {
                    btn.setBorderPainted(true);
                    btn.setContentAreaFilled(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AbstractButton btn = (AbstractButton)evt.getSource();
                if (!btn.isSelected()) {
                    btn.setBorderPainted(false);
                    btn.setContentAreaFilled(false);
                }
            }
        });
        button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AbstractButton btn = (AbstractButton)evt.getSource();
                if (evt.getStateChange() == 1) {
                    btn.setBorderPainted(true);
                    btn.setContentAreaFilled(true);
                } else {
                    btn.setBorderPainted(false);
                    btn.setContentAreaFilled(false);
                }
            }
        });
    }

    private class ToolItemListener
    implements ItemListener,
    ActionListener {
        private ToolItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() != 1) {
                AbstractButton button = (AbstractButton)evt.getItemSelectable();
                AbstractToolAction action = (AbstractToolAction)((Object)button.getAction());
                this.toolInvoked(action, false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractButton button = (AbstractButton)evt.getSource();
            AbstractToolAction action = (AbstractToolAction)((Object)button.getAction());
            this.toolInvoked(action, true);
        }

        private void toolInvoked(AbstractToolAction action, boolean selected) {
            if (selected) {
                ToolboxTopComponent.this.selectedToolAction = action;
                ToolboxTopComponent.this.updateToolActionEditorCookie(true);
            } else {
                action.setSVGEditorCookie(null);
            }
        }
    }

    private class ToolMessageListener
    implements MessageListener {
        private ToolMessageListener() {
        }

        @Override
        public void messageReceived(MessageEvent evt) {
            if (ToolboxTopComponent.this.editorCookie == null) {
                return;
            }
            ToolboxTopComponent.this.editorCookie.getVectorCanvasTopComponent().setStatusText(evt.getMessage());
        }
    }
}

