/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.DropperTool;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.properties.AbstractGraphicsProperties;
import kiyut.swing.button.ColorChooserButton;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGColor;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPaint;
import org.w3c.dom.svg.SVGStylable;

public class FillProperties
extends AbstractGraphicsProperties {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.properties.FillProperties");
    private static final int PAINT_TYPE_NONE = 0;
    private static final int PAINT_TYPE_COLOR = 1;
    private static final int PAINT_TYPE_URI = 2;
    private boolean refreshing;
    private boolean editing;
    private DropperTool dropperTool;
    private JButton dropperButton;
    private JScrollPane jScrollPane1;
    private JPanel mainPane;
    private JTextField opacityField;
    private JButton paintColorButton;
    private JRadioButton paintTypeBlankRadio;
    private JRadioButton paintTypeNoneRadio;
    private JComboBox paintURICombo;
    private JComboBox ruleCombo;

    public FillProperties() {
        this.initComponents();
        this.initCustomComponents();
        this.refreshing = false;
        this.editing = false;
    }

    private void initComponents() {
        ButtonGroup paintButtonGroup = new ButtonGroup();
        this.paintTypeBlankRadio = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.mainPane = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.paintTypeNoneRadio = new JRadioButton();
        this.paintColorButton = new ColorChooserButton();
        this.paintURICombo = new JComboBox();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.dropperButton = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.ruleCombo = new JComboBox();
        this.opacityField = new JTextField();
        JPanel jPanel3 = new JPanel();
        paintButtonGroup.add(this.paintTypeBlankRadio);
        this.setLayout(new BorderLayout());
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.mainPane.setLayout(new GridBagLayout());
        jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_Paint.Text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        jPanel1.setLayout(new GridBagLayout());
        paintButtonGroup.add(this.paintTypeNoneRadio);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        jPanel1.add((Component)this.paintTypeNoneRadio, gridBagConstraints);
        this.paintColorButton.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        jPanel1.add((Component)this.paintColorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel1.add((Component)this.paintURICombo, gridBagConstraints);
        jLabel1.setText(bundle.getString("CTL_Color.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        jPanel1.add((Component)jLabel1, gridBagConstraints);
        jLabel4.setText(bundle.getString("CTL_URI.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        jPanel1.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText(bundle.getString("CTL_None.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel1.add((Component)jLabel5, gridBagConstraints);
        this.dropperButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/canvas/tool/dropper.png")));
        this.dropperButton.setMargin(new Insets(2, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel1.add((Component)this.dropperButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.mainPane.add((Component)jPanel1, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_Properties.Text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        jPanel2.setLayout(new GridBagLayout());
        jLabel2.setText(bundle.getString("CTL_Rule.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText(bundle.getString("CTL_Opacity.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.ruleCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"nonzero", "evenodd"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        jPanel2.add((Component)this.ruleCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel2.add((Component)this.opacityField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.mainPane.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.mainPane.add((Component)jPanel3, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.mainPane);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void initCustomComponents() {
        this.paintTypeNoneRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillProperties.this.paintTypeNoneRadioActionPerformed(evt);
            }
        });
        this.paintColorButton.setFocusPainted(false);
        this.paintColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillProperties.this.paintColorButtonActionPerformed(evt);
            }
        });
        this.dropperButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillProperties.this.dropperButtonActionPerformed(evt);
            }
        });
        this.paintURICombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FillProperties.this.paintURIComboItemStateChanged(evt);
            }
        });
        this.ruleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FillProperties.this.ruleComboItemStateChanged(evt);
            }
        });
        this.opacityField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillProperties.this.opacityFieldActionPerformed(evt);
            }
        });
        String prototypeDisplayValue = "none";
        this.paintURICombo.setPrototypeDisplayValue(prototypeDisplayValue);
        this.ruleCombo.setPrototypeDisplayValue(prototypeDisplayValue);
        this.dropperTool = new DropperTool();
        this.dropperTool.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FillProperties.this.dropperPropertyChange(evt);
            }
        });
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        super.setVectorCanvas(canvas);
        this.dropperTool.setVectorCanvas(canvas);
    }

    @Override
    public void refresh() {
        if (this.editing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        this.refreshing = true;
        SVGPaint paintType = null;
        Color paintColor = null;
        String paintURI = null;
        String rule = null;
        String opacity = null;
        boolean multiPaintType = false;
        boolean multiPaintColor = false;
        boolean multiPaintURI = false;
        boolean multiRule = false;
        boolean multiOpacity = false;
        this.refreshURIData();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            String str;
            SVGElement element;
            if (!(this.selectionList.get(i) instanceof SVGElement) || !((element = (SVGElement)this.selectionList.get(i)) instanceof SVGStylable)) continue;
            ViewCSS viewCSS = (ViewCSS)((Object)element.getOwnerDocument().getDocumentElement());
            CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle((Element)element, null);
            if (!multiPaintType) {
                try {
                    int type2;
                    int type1;
                    SVGPaint svgPaint = (SVGPaint)computedStyle.getPropertyCSSValue("fill");
                    if (paintType == null) {
                        paintType = svgPaint;
                    }
                    if ((type1 = this.determineFillType(paintType)) == (type2 = this.determineFillType(svgPaint))) {
                        if (type1 == 1) {
                            Color color = null;
                            if (svgPaint.getPaintType() == 1) {
                                color = ColorConvertion.getColor((SVGColor)svgPaint);
                            } else if (svgPaint.getPaintType() == 102) {
                                color = ColorConvertion.getColor(svgPaint.getCssText());
                            }
                            if (paintColor == null) {
                                paintColor = color;
                            }
                            if (!paintColor.equals(color)) {
                                multiPaintColor = true;
                            }
                        } else if (type1 == 2) {
                            String str2 = computedStyle.getPropertyValue("fill");
                            int indexOf = str2.lastIndexOf("#");
                            str2 = str2.substring(indexOf + 1, str2.length() - 1);
                            if (paintURI == null) {
                                paintURI = str2;
                            }
                            if (!paintURI.equals(str2)) {
                                multiPaintURI = true;
                            }
                        }
                    } else {
                        multiPaintType = true;
                        multiPaintColor = true;
                        multiPaintURI = true;
                    }
                }
                catch (DOMException ex) {
                    multiPaintType = true;
                    multiPaintColor = true;
                    multiPaintURI = true;
                }
            }
            if (!multiRule) {
                try {
                    str = computedStyle.getPropertyValue("fill-rule");
                    if (rule == null) {
                        rule = str;
                    }
                    if (!rule.equals(str)) {
                        multiRule = true;
                    }
                }
                catch (DOMException dex) {
                    multiRule = true;
                }
            }
            if (multiOpacity) continue;
            try {
                str = computedStyle.getPropertyValue("fill-opacity");
                if (opacity == null) {
                    opacity = str;
                }
                if (opacity.equals(str)) continue;
                multiOpacity = true;
                continue;
            }
            catch (DOMException dex) {
                multiOpacity = true;
            }
        }
        if (!multiPaintType) {
            if (paintType.getPaintType() == 101) {
                this.paintTypeNoneRadio.setSelected(true);
            } else {
                this.paintTypeBlankRadio.setSelected(true);
            }
        } else {
            this.paintTypeBlankRadio.setSelected(true);
        }
        if (!multiPaintType && !multiPaintColor && paintColor != null) {
            ((ColorChooserButton)this.paintColorButton).setColor(paintColor);
        } else {
            ((ColorChooserButton)this.paintColorButton).setColor(null);
        }
        if (!multiPaintType && !multiPaintURI && paintURI != null) {
            this.paintURICombo.setSelectedItem(paintURI);
        } else {
            this.paintURICombo.setSelectedIndex(-1);
        }
        if (!multiRule && rule != null) {
            if (rule.equalsIgnoreCase("nonzero")) {
                this.ruleCombo.setSelectedIndex(0);
            } else if (rule.equalsIgnoreCase("evenodd")) {
                this.ruleCombo.setSelectedIndex(1);
            } else {
                this.ruleCombo.setSelectedIndex(-1);
            }
        } else {
            this.ruleCombo.setSelectedIndex(-1);
        }
        if (!multiOpacity && opacity != null) {
            this.opacityField.setText(opacity);
        } else {
            this.opacityField.setText("");
        }
        this.refreshing = false;
    }

    private void refreshURIData() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.paintURICombo.getModel();
        model.removeAllElements();
        SVGDocument doc = this.canvas.getSVGDocument();
        NodeList nodeList = doc.getElementsByTagNameNS("http://www.w3.org/2000/svg", "linearGradient");
        this.addToModel(nodeList);
        nodeList = doc.getElementsByTagNameNS("http://www.w3.org/2000/svg", "radialGradient");
        this.addToModel(nodeList);
        nodeList = doc.getElementsByTagNameNS("http://www.w3.org/2000/svg", "pattern");
        this.addToModel(nodeList);
    }

    private void addToModel(NodeList nodeList) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.paintURICombo.getModel();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SVGElement elt = (SVGElement)nodeList.item(i);
            model.addElement(elt.getId());
        }
    }

    private int determineFillType(SVGPaint svgPaint) {
        int paintType = -1;
        switch (svgPaint.getPaintType()) {
            case 101: {
                paintType = 0;
                break;
            }
            case 1: 
            case 2: 
            case 102: {
                paintType = 1;
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                paintType = 2;
                break;
            }
        }
        return paintType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeFillColor(Color color) {
        String attr = "fill";
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Fill color");
        try {
            String str = ColorConvertion.toHexString(color);
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, str);
            }
            this.paintTypeBlankRadio.setSelected(true);
            this.paintURICombo.setSelectedIndex(-1);
            ((ColorChooserButton)this.paintColorButton).setColor(color);
        }
        catch (Exception ex) {
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTypeNoneRadioActionPerformed(ActionEvent evt) {
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Fill none");
        String attr = "fill";
        try {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, "none");
            }
            ((ColorChooserButton)this.paintColorButton).setColor(null);
            this.paintURICombo.setSelectedIndex(-1);
        }
        catch (DOMException ex) {
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }

    private void paintColorButtonActionPerformed(ActionEvent evt) {
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        Color newColor = ((ColorChooserButton)this.paintColorButton).getColor();
        if (newColor == null) {
            return;
        }
        this.changeFillColor(newColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintURIComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        String newUri = (String)combo.getSelectedItem();
        String attr = "fill";
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Fill URI");
        try {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                if (newUri == null) {
                    DOMUtilities.updateProperty((SVGStylable)node, null, attr, "none");
                    continue;
                }
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, "url(#" + newUri + ")");
            }
            this.paintTypeBlankRadio.setSelected(true);
            ((ColorChooserButton)this.paintColorButton).setColor(null);
        }
        catch (Exception ex) {
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }

    private void dropperButtonActionPerformed(ActionEvent evt) {
        if (this.canvas == null) {
            return;
        }
        this.canvas.setTool(this.dropperTool);
        this.canvas.repaint();
    }

    private void dropperPropertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("color")) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        Color newColor = this.dropperTool.getColor();
        if (newColor == null) {
            return;
        }
        this.changeFillColor(newColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ruleComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        int index = combo.getSelectedIndex();
        String attr = "fill-rule";
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Fill rule");
        try {
            block9: for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                switch (index) {
                    case 0: {
                        DOMUtilities.updateProperty((SVGStylable)node, null, attr, null);
                        continue block9;
                    }
                    case 1: {
                        DOMUtilities.updateProperty((SVGStylable)node, null, attr, "evenodd");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void opacityFieldActionPerformed(ActionEvent evt) {
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        String attr = "fill-opacity";
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Fill opacity");
        try {
            boolean isDefault = false;
            String str = this.opacityField.getText().trim();
            Number number = DataTypeUtilities.validateNumber(str);
            if (number.floatValue() < 0.0f || number.floatValue() > 1.0f) {
                throw new RuntimeException("Valid opacity value 0.0(fully transparent) - 1.0(fully opaque)");
            }
            if (number.floatValue() == 1.0f) {
                isDefault = true;
            }
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                if (isDefault) {
                    DOMUtilities.updateProperty((SVGStylable)node, null, attr, null);
                    continue;
                }
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, str);
            }
        }
        catch (Exception ex) {
            this.editing = false;
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }
}

