/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.domeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.windows.domeditor.CanvasDOMTree;
import kiyut.sketsa.windows.domeditor.CharacterDataEditor;
import kiyut.sketsa.windows.domeditor.ElementEditor;
import kiyut.swing.tree.dom.DOMTree;
import kiyut.swing.tree.dom.DOMTreeModel;
import kiyut.swing.util.MenuFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class DOMEditor
extends JPanel {
    private static final String ADD_ACTION_COMMAND = "Add";
    private static final String EDIT_ACTION_COMMAND = "Edit";
    private static final String REMOVE_ACTION_COMMAND = "Remove";
    private static final String MOVE_UP_ACTION_COMMAND = "MoveUp";
    private static final String MOVE_DOWN_ACTION_COMMAND = "MoveDown";
    private static final String FIND_ACTION_COMMAND = "Find";
    private static final String SHOW_EMPTY_TEXT_ACTION_COMMAND = "ShowEmptyText";
    private static final String ADD_ELEMENT_ACTION_COMMAND = "AddElement";
    private static final String ADD_COMMENT_ACTION_COMMAND = "AddComment";
    private static final String ADD_TEXT_ACTION_COMMAND = "AddText";
    private static final String ADD_CDATA_ACTION_COMMAND = "AddCDATA";
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.domeditor.DOMEditor");
    private Map<SVGDocument, CanvasDOMTree> domTreeMap;
    private JPopupMenu addPopupMenu;
    private JToggleButton showEmptyTextButton;
    private JPanel emptyPane;
    private JScrollPane scrollPane;
    private JToolBar toolBar;

    public DOMEditor() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.emptyPane = new JPanel();
        this.toolBar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.emptyPane);
        this.add((Component)this.scrollPane, "Center");
        this.toolBar.setRollover(true);
        this.add((Component)this.toolBar, "North");
    }

    private void initCustomComponents() {
        this.emptyPane = new JPanel();
        this.domTreeMap = new HashMap<SVGDocument, CanvasDOMTree>();
        this.initActions();
    }

    private void initActions() {
        HashMap<String, Action> actionMap = new HashMap<String, Action>();
        actionMap.put(ADD_ACTION_COMMAND, new EditorAction(ADD_ACTION_COMMAND));
        actionMap.put(EDIT_ACTION_COMMAND, new EditorAction(EDIT_ACTION_COMMAND));
        actionMap.put(REMOVE_ACTION_COMMAND, new EditorAction(REMOVE_ACTION_COMMAND));
        actionMap.put(MOVE_UP_ACTION_COMMAND, new EditorAction(MOVE_UP_ACTION_COMMAND));
        actionMap.put(MOVE_DOWN_ACTION_COMMAND, new EditorAction(MOVE_DOWN_ACTION_COMMAND));
        actionMap.put(FIND_ACTION_COMMAND, new EditorAction(FIND_ACTION_COMMAND));
        actionMap.put(SHOW_EMPTY_TEXT_ACTION_COMMAND, new EditorAction(SHOW_EMPTY_TEXT_ACTION_COMMAND));
        actionMap.put(ADD_ELEMENT_ACTION_COMMAND, new EditorAction(ADD_ELEMENT_ACTION_COMMAND));
        actionMap.put(ADD_COMMENT_ACTION_COMMAND, new EditorAction(ADD_COMMENT_ACTION_COMMAND));
        actionMap.put(ADD_TEXT_ACTION_COMMAND, new EditorAction(ADD_TEXT_ACTION_COMMAND));
        actionMap.put(ADD_CDATA_ACTION_COMMAND, new EditorAction(ADD_CDATA_ACTION_COMMAND));
        MenuFactory.configureActionMap(bundle, actionMap);
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(ADD_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(EDIT_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(MOVE_UP_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(MOVE_DOWN_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(FIND_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(REMOVE_ACTION_COMMAND)));
        this.showEmptyTextButton = this.createToolBarToggleButton((Action)actionMap.get(SHOW_EMPTY_TEXT_ACTION_COMMAND));
        this.toolBar.add(this.showEmptyTextButton);
        this.addPopupMenu = MenuFactory.createPopupMenu(bundle, actionMap, "AddPopupMenu");
    }

    private JButton createToolBarButton(Action action) {
        JButton button = new JButton(action);
        button.setText("");
        button.setFocusable(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    private JToggleButton createToolBarToggleButton(Action action) {
        JToggleButton button = new JToggleButton(action);
        button.setText("");
        button.setFocusable(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    private void showPopup(JComponent comp) {
        if (!this.isNodeSelected()) {
            return;
        }
        this.addPopupMenu.show(comp, comp.getX() + comp.getWidth(), comp.getY());
    }

    private void edit() {
        if (!this.isNodeSelected()) {
            return;
        }
        Node node = this.getCanvasDOMTree().getLastSelectedDOMNode();
        if (node instanceof Element) {
            ElementEditor pane = new ElementEditor();
            pane.setVectorCanvas(this.getCanvasDOMTree().getVectorCanvas());
            pane.setElement((Element)node);
            Window owner = SwingUtilities.getWindowAncestor(this);
            JOptionPane.showOptionDialog(owner, pane, bundle.getString("MSG_EditElement.Title"), -1, -1, null, null, null);
            pane.setElement(null);
        } else if (node instanceof CharacterData) {
            this.editCharacterData((CharacterData)node);
        }
    }

    public void removeSelected() {
        if (!this.isNodeSelected()) {
            return;
        }
        this.getCanvasDOMTree().removeSelected();
    }

    private void find() {
        String id;
        CanvasDOMTree domTree = this.getCanvasDOMTree();
        if (domTree == null) {
            return;
        }
        String value = JOptionPane.showInputDialog(bundle.getString("MSG_Find.Text"));
        if (value != null && (id = value.trim()).length() > 0) {
            Element element = domTree.getSVGDocument().getElementById(id);
            if (element != null) {
                DOMTreeModel treeModel = (DOMTreeModel)domTree.getModel();
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treeModel.getTreeNode(element);
                TreePath treePath = new TreePath(treeNode.getPath());
                domTree.setSelectionPath(treePath);
                domTree.scrollPathToVisible(treePath);
            } else {
                Window owner = SwingUtilities.getWindowAncestor(this);
                Object[] args = new Object[]{id};
                String msg = MessageFormat.format(bundle.getString("MSG_ElementNotFound.Text"), args);
                JOptionPane.showMessageDialog(owner, msg, bundle.getString("MSG_ElementNotFound.Title"), 0);
            }
        }
    }

    private void setEmptyTextVisible(boolean b) {
        CanvasDOMTree domTree = this.getCanvasDOMTree();
        if (domTree == null) {
            return;
        }
        domTree.setEmptyTextVisible(b);
    }

    private void moveUp() {
        if (!this.isNodeSelected()) {
            return;
        }
        this.getCanvasDOMTree().moveSelectedUp();
    }

    private void moveDown() {
        if (!this.isNodeSelected()) {
            return;
        }
        this.getCanvasDOMTree().moveSelectedDown();
    }

    private void addElement() {
        if (!this.isNodeSelected()) {
            return;
        }
        Window owner = SwingUtilities.getWindowAncestor(this);
        String str = JOptionPane.showInputDialog(owner, bundle.getString("MSG_AddElement.Text"), bundle.getString("MSG_AddElement.Title"), 3);
        if (str == null) {
            str = "";
        }
        if ((str = str.trim()).length() > 0) {
            Element element;
            CanvasDOMTree domTree = this.getCanvasDOMTree();
            SVGDocument doc = domTree.getSVGDocument();
            try {
                String svgNS = "http://www.w3.org/2000/svg";
                element = doc.createElementNS(svgNS, str);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(owner, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
                element = null;
            }
            if (element != null) {
                ElementEditor pane = new ElementEditor();
                pane.setVectorCanvas(this.getCanvasDOMTree().getVectorCanvas());
                pane.setElement(element);
                boolean failed = true;
                while (failed) {
                    int choice = JOptionPane.showOptionDialog(owner, pane, bundle.getString("MSG_EditElement.Title"), 2, -1, null, null, null);
                    if (choice == 0) {
                        try {
                            domTree.addToSelected(element);
                            failed = false;
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(owner, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
                        }
                        continue;
                    }
                    failed = false;
                }
            }
        }
    }

    private void addCharacterData(short type) {
        CanvasDOMTree domTree = this.getCanvasDOMTree();
        SVGDocument doc = domTree.getSVGDocument();
        CharacterData characterData = null;
        if (type == 8) {
            characterData = doc.createComment("comment");
        } else if (type == 3) {
            characterData = doc.createTextNode("text");
        } else if (type == 4) {
            characterData = doc.createCDATASection("");
        }
        Window owner = SwingUtilities.getWindowAncestor(this);
        int choice = this.editCharacterData(characterData);
        if (choice != 0) {
            return;
        }
        try {
            if (type == 8) {
                domTree.addAboveSelected(characterData);
            } else {
                domTree.addToSelected(characterData);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(owner, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
    }

    private int editCharacterData(CharacterData characterData) {
        Window owner = SwingUtilities.getWindowAncestor(this);
        String title = null;
        short type = characterData.getNodeType();
        if (type == 8) {
            title = bundle.getString("MSG_EditComment.Title");
        } else if (type == 3) {
            title = bundle.getString("MSG_EditText.Title");
        } else if (type == 4) {
            title = bundle.getString("MSG_EditCDATA.Title");
        }
        CharacterDataEditor editor = new CharacterDataEditor();
        editor.setCharacterData(characterData);
        int choice = JOptionPane.showOptionDialog(owner, editor, title, -1, -1, null, null, null);
        if (choice == 0) {
            characterData.setNodeValue(editor.getText());
            if (type != 8) {
                this.getCanvasDOMTree().getVectorCanvas().refresh();
            }
        }
        return choice;
    }

    private CanvasDOMTree getCanvasDOMTree() {
        Component comp = this.scrollPane.getViewport().getView();
        if (comp instanceof CanvasDOMTree) {
            return (CanvasDOMTree)comp;
        }
        return null;
    }

    private boolean isNodeSelected() {
        CanvasDOMTree domTree = this.getCanvasDOMTree();
        if (domTree == null) {
            return false;
        }
        Node selectedNode = domTree.getLastSelectedDOMNode();
        if (selectedNode == null) {
            JOptionPane.showMessageDialog(this, bundle.getString("MSG_NoNodeSelected.Text"), bundle.getString("MSG_NoNodeSelected.Title"), 0);
            return false;
        }
        return true;
    }

    public void putVectorCanvas(VectorCanvas canvas) {
        if (canvas == null) {
            return;
        }
        SVGDocument doc = canvas.getSVGDocument();
        CanvasDOMTree domTree = this.domTreeMap.get(doc);
        if (domTree == null) {
            domTree = new CanvasDOMTree(canvas);
            this.domTreeMap.put(doc, domTree);
            domTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        DOMEditor.this.edit();
                    }
                }
            });
        }
        this.showEmptyTextButton.setSelected(domTree.isEmptyTextVisible());
        this.scrollPane.setViewportView(domTree);
        this.revalidate();
        this.repaint();
    }

    public void removeVectorCanvas(VectorCanvas canvas) {
        if (canvas == null) {
            return;
        }
        SVGDocument doc = canvas.getSVGDocument();
        DOMTree domTree = this.domTreeMap.remove(doc);
        if (domTree != null) {
            ((CanvasDOMTree)domTree).setSVGDocument(null);
        }
        this.scrollPane.setViewportView(this.emptyPane);
    }

    private class EditorAction
    extends AbstractAction {
        public EditorAction(String name) {
            super(name);
            this.putValue("ActionCommandKey", name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final String command = evt.getActionCommand();
            final JComponent comp = (JComponent)evt.getSource();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (command.equalsIgnoreCase(DOMEditor.ADD_ACTION_COMMAND)) {
                        DOMEditor.this.showPopup(comp);
                    } else if (command.equalsIgnoreCase(DOMEditor.EDIT_ACTION_COMMAND)) {
                        DOMEditor.this.edit();
                    } else if (command.equalsIgnoreCase(DOMEditor.REMOVE_ACTION_COMMAND)) {
                        DOMEditor.this.removeSelected();
                    } else if (command.equalsIgnoreCase(DOMEditor.FIND_ACTION_COMMAND)) {
                        DOMEditor.this.find();
                    } else if (command.equalsIgnoreCase(DOMEditor.SHOW_EMPTY_TEXT_ACTION_COMMAND)) {
                        boolean b = ((JToggleButton)comp).isSelected();
                        DOMEditor.this.setEmptyTextVisible(b);
                    } else if (command.equalsIgnoreCase(DOMEditor.ADD_ELEMENT_ACTION_COMMAND)) {
                        DOMEditor.this.addElement();
                    } else if (command.equalsIgnoreCase(DOMEditor.ADD_COMMENT_ACTION_COMMAND)) {
                        DOMEditor.this.addCharacterData((short)8);
                    } else if (command.equalsIgnoreCase(DOMEditor.ADD_TEXT_ACTION_COMMAND)) {
                        DOMEditor.this.addCharacterData((short)3);
                    } else if (command.equalsIgnoreCase(DOMEditor.ADD_CDATA_ACTION_COMMAND)) {
                        DOMEditor.this.addCharacterData((short)4);
                    } else if (command.equalsIgnoreCase(DOMEditor.MOVE_UP_ACTION_COMMAND)) {
                        DOMEditor.this.moveUp();
                    } else if (command.equalsIgnoreCase(DOMEditor.MOVE_DOWN_ACTION_COMMAND)) {
                        DOMEditor.this.moveDown();
                    }
                }
            });
        }
    }
}

