/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.gradient;

import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.windows.defs.gradient.SVGPaintNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPaint;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class SVGGradientUtilities {
    public static void updateReferenceElement(SVGElement element, String newId) {
        String baseUri = element.getBaseURI();
        String fragment = element.getId();
        String newBaseUri = baseUri;
        String newFragment = newId;
        Document doc = element.getOwnerDocument();
        element.setId(newId);
        SVGGradientUtilities.updateReferenceElement(baseUri, fragment, newBaseUri, newFragment, doc);
    }

    public static void updateReferenceElement(String baseUri, String fragment, String newBaseUri, String newFragment, Document doc) {
        SVGPaintNodeFilter filter = new SVGPaintNodeFilter();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)doc);
        TreeWalker treeWalker = travelsal.createTreeWalker(doc, 1, filter, false);
        String tBaseUri = baseUri;
        String tNewBaseUri = newBaseUri;
        if (tBaseUri == null) {
            tBaseUri = "";
        }
        if (tNewBaseUri == null) {
            tNewBaseUri = "";
        }
        SVGGradientUtilities.recursiveUpdate(treeWalker, tBaseUri, fragment, tNewBaseUri, newFragment);
    }

    private static void recursiveUpdate(TreeWalker treeWalker, String baseUri, String fragment, String newBaseUri, String newFragment) {
        Node n = treeWalker.getCurrentNode();
        Node child = treeWalker.firstChild();
        while (child != null) {
            Element elt = (Element)child;
            SVGGradientUtilities.updateElement(elt, "stroke", baseUri, fragment, newBaseUri, newFragment);
            SVGGradientUtilities.updateElement(elt, "fill", baseUri, fragment, newBaseUri, newFragment);
            SVGGradientUtilities.recursiveUpdate(treeWalker, baseUri, fragment, newBaseUri, newFragment);
            child = treeWalker.nextSibling();
        }
        treeWalker.setCurrentNode(n);
    }

    private static void updateElement(Element element, String attr, String baseUri, String fragment, String newBaseUri, String newFragment) {
        String curUri;
        String oldUri;
        ViewCSS viewCSS = (ViewCSS)((Object)element.getOwnerDocument().getDocumentElement());
        CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle(element, null);
        SVGPaint svgPaint = (SVGPaint)computedStyle.getPropertyCSSValue(attr);
        short type = svgPaint.getPaintType();
        if ((type == 107 || type == 104 || type == 103 || type == 105 || type == 106) && (oldUri = svgPaint.getUri()).equalsIgnoreCase(curUri = baseUri + "#" + fragment)) {
            String newUri = "#" + newFragment;
            if (!baseUri.equals(newBaseUri)) {
                newUri = newBaseUri + newUri;
            }
            SVGStylable stylable = (SVGStylable)element;
            DOMUtilities.updateProperty(stylable, null, attr, "none");
            DOMUtilities.updateProperty(stylable, null, attr, "url(" + newUri + ")");
        }
    }
}

