/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter.primitive;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.defs.filter.primitive.AbstractFilterPrimitiveProperty;
import kiyut.swing.button.ColorChooserButton;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGColor;
import org.w3c.dom.svg.SVGFESpecularLightingElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGStylable;

public class FESpecularLightingProperty
extends AbstractFilterPrimitiveProperty {
    private boolean editing = false;
    private boolean refreshing = false;
    private JButton colorButton;
    private JPanel fillerPane;
    protected JTextField hField;
    private JComboBox inCombo;
    private JPanel jPanel1;
    protected JTextField resultField;
    protected JTextField specularConstantField;
    protected JTextField specularExponentField;
    protected JTextField surfaceScaleField;
    protected JTextField wField;
    protected JTextField xField;
    protected JTextField yField;

    public FESpecularLightingProperty() {
        this.initComponents();
        this.initEventHandler();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.yField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.wField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.hField = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.inCombo = new JComboBox();
        JLabel jLabel5 = new JLabel();
        this.resultField = new JTextField();
        this.jPanel1 = new JPanel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.colorButton = new ColorChooserButton();
        this.surfaceScaleField = new JTextField();
        this.specularConstantField = new JTextField();
        this.specularExponentField = new JTextField();
        this.fillerPane = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        jLabel1.setText("x");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.xField, gridBagConstraints);
        jLabel2.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.yField, gridBagConstraints);
        jLabel3.setText("width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.wField, gridBagConstraints);
        jLabel4.setText("height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.hField, gridBagConstraints);
        jLabel6.setText("in");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel6, gridBagConstraints);
        this.inCombo.setEditable(true);
        this.inCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"SourceGraphic", "SourceAlpha", "BackgroundImage", "BackgroundAlpha", "FillPaint", "StrokePaint"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.inCombo, gridBagConstraints);
        jLabel5.setText("result");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.resultField, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Specular Lighting"), BorderFactory.createEmptyBorder(0, 6, 6, 6)));
        this.jPanel1.setLayout(new GridBagLayout());
        jLabel7.setText("surface scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.jPanel1.add((Component)jLabel7, gridBagConstraints);
        jLabel8.setText("specular constant");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.jPanel1.add((Component)jLabel8, gridBagConstraints);
        jLabel9.setText("specular exponent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.jPanel1.add((Component)jLabel9, gridBagConstraints);
        jLabel10.setText("lighting color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel1.add((Component)jLabel10, gridBagConstraints);
        this.colorButton.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.colorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.surfaceScaleField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.specularConstantField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.specularExponentField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPane, gridBagConstraints);
    }

    private void initEventHandler() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FESpecularLightingProperty.this.updateDOM();
            }
        };
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
        this.wField.addActionListener(fieldActionHandler);
        this.hField.addActionListener(fieldActionHandler);
        this.resultField.addActionListener(fieldActionHandler);
        this.surfaceScaleField.addActionListener(fieldActionHandler);
        this.specularConstantField.addActionListener(fieldActionHandler);
        this.specularExponentField.addActionListener(fieldActionHandler);
        ItemListener itemListenerHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                FESpecularLightingProperty.this.updateDOM();
            }
        };
        this.inCombo.addItemListener(itemListenerHandler);
        ActionListener colorActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FESpecularLightingProperty.this.updateDOMColorProperty();
            }
        };
        this.colorButton.addActionListener(colorActionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGFESpecularLightingElement elt = (SVGFESpecularLightingElement)this.element;
            SVGLength length = elt.getX().getBaseVal();
            this.xField.setText(length.getValueAsString());
            length = elt.getY().getBaseVal();
            this.yField.setText(length.getValueAsString());
            length = elt.getWidth().getBaseVal();
            this.wField.setText(length.getValueAsString());
            length = elt.getHeight().getBaseVal();
            this.hField.setText(length.getValueAsString());
            String str = elt.getResult().getBaseVal();
            this.resultField.setText(str);
            str = elt.getIn1().getBaseVal();
            this.inCombo.setSelectedItem(str);
            float f = elt.getSurfaceScale().getBaseVal();
            this.surfaceScaleField.setText(Float.toString(f));
            f = elt.getSpecularConstant().getBaseVal();
            this.specularConstantField.setText(Float.toString(f));
            f = elt.getSpecularExponent().getBaseVal();
            this.specularExponentField.setText(Float.toString(f));
            SVGStylable svgStylable = (SVGStylable)this.element;
            ViewCSS viewCSS = (ViewCSS)((Object)this.element.getOwnerDocument().getDocumentElement());
            CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle((Element)this.element, null);
            SVGColor svgColor = (SVGColor)computedStyle.getPropertyCSSValue("lighting-color");
            Color color = ColorConvertion.getColor(svgColor);
            ((ColorChooserButton)this.colorButton).setColor(color);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOM() {
        if (this.refreshing) {
            return;
        }
        SVGFESpecularLightingElement elt = (SVGFESpecularLightingElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feSpecularLighting properties");
        try {
            String attrName = "x";
            String str = this.xField.getText().trim();
            String defaultStr = "0%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "y";
            str = this.yField.getText().trim();
            defaultStr = "0%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "width";
            str = this.wField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative width value is an error.");
            }
            defaultStr = "100%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "height";
            str = this.hField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative height value is an error.");
            }
            defaultStr = "100%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "result";
            str = this.resultField.getText().trim();
            if (str.length() > 0) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "in";
            str = this.inCombo.getSelectedItem().toString().trim();
            if (str.length() > 0) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "surfaceScale";
            str = this.surfaceScaleField.getText().trim();
            number = DataTypeUtilities.validateNumber(str);
            defaultStr = "1";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "specularConstant";
            str = this.specularConstantField.getText().trim();
            number = DataTypeUtilities.validateNumber(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative specular constant value is an error.");
            }
            defaultStr = "1";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "specularExponent";
            str = this.specularExponentField.getText().trim();
            number = DataTypeUtilities.validateNumber(str);
            if (number.floatValue() < 1.0f || number.floatValue() > 128.0f) {
                throw new RuntimeException("A valid specular exponent value is between 1.0 - 128.0. Larger is more shiny");
            }
            defaultStr = "1";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOMColorProperty() {
        if (this.refreshing) {
            return;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feSpecularLighting properties");
        try {
            Color newColor = ((ColorChooserButton)this.colorButton).getColor();
            String str = ColorConvertion.toHexString(newColor);
            String attrName = "lighting-color";
            SVGStylable svgStylable = (SVGStylable)this.element;
            DOMUtilities.updateProperty(svgStylable, null, attrName, str);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }
}

