/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter.primitive;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.defs.filter.primitive.AbstractFilterPrimitiveProperty;
import org.w3c.dom.svg.SVGFEMorphologyElement;
import org.w3c.dom.svg.SVGLength;

public class FEMorphologyProperty
extends AbstractFilterPrimitiveProperty {
    private boolean editing = false;
    private boolean refreshing = false;
    private JPanel fillerPane;
    protected JTextField hField;
    private JComboBox inCombo;
    private JPanel jPanel1;
    private JComboBox operatorCombo;
    private JTextField radiusXField;
    private JTextField radiusYField;
    protected JTextField resultField;
    protected JTextField wField;
    protected JTextField xField;
    protected JTextField yField;

    public FEMorphologyProperty() {
        this.initComponents();
        this.initEventHandler();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.yField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.wField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.hField = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.inCombo = new JComboBox();
        JLabel jLabel5 = new JLabel();
        this.resultField = new JTextField();
        this.jPanel1 = new JPanel();
        JLabel jLabel8 = new JLabel();
        this.operatorCombo = new JComboBox();
        JLabel jLabel9 = new JLabel();
        this.radiusXField = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.radiusYField = new JTextField();
        this.fillerPane = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new GridBagLayout());
        jLabel1.setText("x");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.xField, gridBagConstraints);
        jLabel2.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.yField, gridBagConstraints);
        jLabel3.setText("width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.wField, gridBagConstraints);
        jLabel4.setText("height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.hField, gridBagConstraints);
        jLabel6.setText("in");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel6, gridBagConstraints);
        this.inCombo.setEditable(true);
        this.inCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"SourceGraphic", "SourceAlpha", "BackgroundImage", "BackgroundAlpha", "FillPaint", "StrokePaint"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.inCombo, gridBagConstraints);
        jLabel5.setText("result");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.resultField, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Morphology"), BorderFactory.createEmptyBorder(0, 6, 6, 6)));
        this.jPanel1.setLayout(new GridBagLayout());
        jLabel8.setText("op");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.jPanel1.add((Component)jLabel8, gridBagConstraints);
        this.operatorCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"erode", "dilate"}));
        this.operatorCombo.setToolTipText("Operator");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.operatorCombo, gridBagConstraints);
        jLabel9.setText("radius x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.jPanel1.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.radiusXField, gridBagConstraints);
        jLabel7.setText("radius y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.jPanel1.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.radiusYField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPane, gridBagConstraints);
    }

    private void initEventHandler() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FEMorphologyProperty.this.updateDOM();
            }
        };
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
        this.wField.addActionListener(fieldActionHandler);
        this.hField.addActionListener(fieldActionHandler);
        this.resultField.addActionListener(fieldActionHandler);
        this.radiusXField.addActionListener(fieldActionHandler);
        this.radiusYField.addActionListener(fieldActionHandler);
        ItemListener itemListenerHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                FEMorphologyProperty.this.updateDOM();
            }
        };
        this.inCombo.addItemListener(itemListenerHandler);
        this.operatorCombo.addItemListener(itemListenerHandler);
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGFEMorphologyElement elt = (SVGFEMorphologyElement)this.element;
            SVGLength length = elt.getX().getBaseVal();
            this.xField.setText(length.getValueAsString());
            length = elt.getY().getBaseVal();
            this.yField.setText(length.getValueAsString());
            length = elt.getWidth().getBaseVal();
            this.wField.setText(length.getValueAsString());
            length = elt.getHeight().getBaseVal();
            this.hField.setText(length.getValueAsString());
            String str = elt.getResult().getBaseVal();
            this.resultField.setText(str);
            str = elt.getIn1().getBaseVal();
            this.inCombo.setSelectedItem(str);
            str = elt.getAttributeNS(null, "operator");
            for (int i = 0; i < this.operatorCombo.getItemCount(); ++i) {
                String item = this.operatorCombo.getItemAt(i).toString();
                if (!str.equalsIgnoreCase(item)) continue;
                this.operatorCombo.setSelectedIndex(i);
            }
            str = elt.getAttributeNS(null, "radius").trim();
            Number[] numbers = str.length() == 0 ? new Number[]{new Float(0.0f), new Float(0.0f)} : DataTypeUtilities.validateNumberOptional(str);
            this.radiusXField.setText(numbers[0].toString());
            this.radiusYField.setText(numbers[1].toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOM() {
        if (this.refreshing) {
            return;
        }
        SVGFEMorphologyElement elt = (SVGFEMorphologyElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change feMorphology properties");
        try {
            String attrName = "x";
            String str = this.xField.getText().trim();
            String defaultStr = "0%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "y";
            str = this.yField.getText().trim();
            defaultStr = "0%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "width";
            str = this.wField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative width value is an error.");
            }
            defaultStr = "100%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "height";
            str = this.hField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative height value is an error.");
            }
            defaultStr = "100%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "result";
            str = this.resultField.getText().trim();
            if (str.length() > 0) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "in";
            str = this.inCombo.getSelectedItem().toString().trim();
            if (str.length() > 0) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "operator";
            str = this.operatorCombo.getSelectedItem().toString().trim();
            elt.setAttributeNS(null, attrName, str);
            attrName = "radius";
            str = this.radiusXField.getText().trim() + " " + this.radiusYField.getText().trim();
            Number[] numbers = DataTypeUtilities.validateNumberOptional(str);
            float f1 = numbers[0].floatValue();
            float f2 = numbers[1].floatValue();
            if (f1 < 0.0f) {
                throw new RuntimeException("A negative radiusX value is an error.");
            }
            if (f2 < 0.0f) {
                throw new RuntimeException("A negative radiusY value is an error.");
            }
            if (f1 != f2) {
                elt.setAttributeNS(null, attrName, Float.toString(f1) + " " + Float.toString(f2));
            } else if (f1 == f2 && f1 != 0.0f) {
                elt.setAttributeNS(null, attrName, Float.toString(f1));
            } else {
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }
}

