/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.windows.defs.filter.FilterTreeCellRenderer;
import kiyut.sketsa.windows.defs.filter.FilterTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGFilterElement;
import org.w3c.dom.svg.SVGFilterPrimitiveStandardAttributes;

public class FilterTree
extends JTree {
    private VectorCanvas canvas;

    public FilterTree() {
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setModel(null);
        this.getSelectionModel().setSelectionMode(1);
        FilterTreeModel model = new FilterTreeModel();
        this.setModel(model);
        FilterTreeCellRenderer renderer = new FilterTreeCellRenderer();
        this.setCellRenderer(renderer);
    }

    public void setSVGFilterElement(VectorCanvas canvas, SVGFilterElement element) {
        this.canvas = canvas;
        FilterTreeModel model = (FilterTreeModel)this.getModel();
        model.setSVGFilterElement(element);
    }

    public SVGFilterElement getSVGFilterElement() {
        FilterTreeModel model = (FilterTreeModel)this.getModel();
        return model.getSVGFilterElement();
    }

    public void moveSelectedUp() {
        FilterTreeModel model;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (treeNode == (model = (FilterTreeModel)this.getModel()).getRoot()) {
            return;
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Move node up");
        model.moveNodeUp(treeNode);
        undoManager.end();
        Node domNode = (Node)treeNode.getUserObject();
        treeNode = (DefaultMutableTreeNode)model.getTreeNode(domNode);
        this.setSelectionPath(new TreePath(treeNode.getPath()));
    }

    public void moveSelectedDown() {
        FilterTreeModel model;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (treeNode == (model = (FilterTreeModel)this.getModel()).getRoot()) {
            return;
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Move node down");
        model.moveNodeDown(treeNode);
        undoManager.end();
        Node domNode = (Node)treeNode.getUserObject();
        treeNode = (DefaultMutableTreeNode)model.getTreeNode(domNode);
        this.setSelectionPath(new TreePath(treeNode.getPath()));
    }

    public void removeSelected() {
        FilterTreeModel model;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (treeNode == (model = (FilterTreeModel)this.getModel()).getRoot()) {
            return;
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Remove node");
        model.removeNode(treeNode);
        undoManager.end();
    }

    public void add(String name, boolean select) {
        Node domNode;
        DefaultMutableTreeNode treeNode;
        FilterTreeModel model = (FilterTreeModel)this.getModel();
        SVGFilterElement filterElt = model.getSVGFilterElement();
        Document doc = filterElt.getOwnerDocument();
        SVGElement elt = (SVGElement)doc.createElementNS("http://www.w3.org/2000/svg", name);
        if (elt instanceof SVGFilterPrimitiveStandardAttributes) {
            treeNode = (DefaultMutableTreeNode)model.getRoot();
            domNode = (Node)treeNode.getUserObject();
        } else {
            treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
            domNode = (Node)treeNode.getUserObject();
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Add node");
        domNode.appendChild((Node)elt);
        undoManager.end();
        model.reload(treeNode);
        if (select) {
            treeNode = (DefaultMutableTreeNode)model.getTreeNode((Node)elt);
            this.setSelectionPath(new TreePath(treeNode.getPath()));
        }
    }
}

