/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.util;

import java.util.HashMap;
import java.util.Map;

public class UnitConversion {
    public static final String PX = "px";
    public static final String MM = "mm";
    public static final String CM = "cm";
    public static final String IN = "in";
    public static final String PT = "pt";
    public static final String PC = "pc";
    private static final double DPI = 96.0;
    protected static final Map<String, Double> UNIT_MAP = new HashMap<String, Double>();

    public static double convert(double value, String srcUnit, String dstUnit, double dpi) {
        Double obj;
        if (srcUnit.equalsIgnoreCase(dstUnit)) {
            return value;
        }
        double val = value;
        String sUnit = srcUnit;
        String dUnit = dstUnit;
        if (PX.equalsIgnoreCase(srcUnit)) {
            val /= dpi;
            if (IN.equalsIgnoreCase(dstUnit)) {
                return val;
            }
            sUnit = IN;
        }
        if (PX.equalsIgnoreCase(dstUnit)) {
            dUnit = IN;
        }
        if ((obj = UNIT_MAP.get(sUnit + dUnit)) != null) {
            val *= obj.doubleValue();
        }
        if (PX.equalsIgnoreCase(dstUnit)) {
            val *= dpi;
        }
        return val;
    }

    static {
        UNIT_MAP.put("inpt", new Double(96.0));
        UNIT_MAP.put("inpc", new Double(6.0));
        UNIT_MAP.put("incm", new Double(2.54));
        UNIT_MAP.put("inmm", new Double(25.4));
        UNIT_MAP.put("ptin", new Double(0.010416666666666666));
        UNIT_MAP.put("ptpc", new Double(0.0625));
        UNIT_MAP.put("ptcm", new Double(0.026458333333333334));
        UNIT_MAP.put("ptmm", new Double(0.2645833333333333));
        UNIT_MAP.put("pcin", new Double(0.16666666666666666));
        UNIT_MAP.put("pcpt", new Double(16.0));
        UNIT_MAP.put("pccm", new Double(0.42333333333333334));
        UNIT_MAP.put("pcmm", new Double(4.2333333333333325));
        UNIT_MAP.put("cmin", new Double(0.39370078740157477));
        UNIT_MAP.put("cmpt", new Double(37.79527559055118));
        UNIT_MAP.put("cmpc", new Double(2.3622047244094486));
        UNIT_MAP.put("cmmm", new Double(10.0));
        UNIT_MAP.put("mmin", new Double(0.03937007874015748));
        UNIT_MAP.put("mmpt", new Double(3.779527559055118));
        UNIT_MAP.put("mmpc", new Double(0.23622047244094488));
        UNIT_MAP.put("mmcm", new Double(0.1));
    }
}

