/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.tool;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;

public class TransformPane
extends JPanel {
    public static final String TRANSFORM_TRANSLATE = "TRANSFORM_TRANSLATE";
    public static final String TRANSFORM_SCALE = "TRANSFORM_SCALE";
    public static final String TRANSFORM_ROTATE = "TRANSFORM_ROTATE";
    public static final String TRANSFORM_SKEW = "TRANSFORM_SKEW";
    public static final String TRANSFORM_MATRIX = "TRANSFORM_MATRIX";
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.tool.TransformPane");
    private String transform;
    private VectorCanvas canvas;
    private JTextField aField;
    private JTextField angleField;
    private JTextField bField;
    private ButtonGroup buttonGroup;
    private JTextField cField;
    private JPanel centerPane;
    private JTextField cxField;
    private JTextField cyField;
    private JTextField dField;
    private JTextField eField;
    private JTextField fField;
    private JPanel jPanel7;
    private JToggleButton matrixButton;
    private JPanel matrixPane;
    private JToggleButton rotateButton;
    private JPanel rotatePane;
    private JButton rotateSelectionCenterButton;
    private JToggleButton scaleButton;
    private JCheckBox scaleEqualToSxCheck;
    private JPanel scalePane;
    private JToggleButton skewButton;
    private JPanel skewPane;
    private JTextField skewXField;
    private JTextField skewYField;
    private JTextField sxField;
    private JTextField syField;
    private JToggleButton translateButton;
    private JPanel translatePane;
    private JTextField txField;
    private JTextField tyField;

    public TransformPane() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        JToolBar jToolBar1 = new JToolBar();
        this.translateButton = new JToggleButton();
        this.scaleButton = new JToggleButton();
        this.rotateButton = new JToggleButton();
        this.skewButton = new JToggleButton();
        this.matrixButton = new JToggleButton();
        this.centerPane = new JPanel();
        this.translatePane = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.txField = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.tyField = new JTextField();
        JPanel jPanel6 = new JPanel();
        this.scalePane = new JPanel();
        JLabel jLabel9 = new JLabel();
        this.sxField = new JTextField();
        JLabel jLabel10 = new JLabel();
        this.syField = new JTextField();
        JPanel jPanel8 = new JPanel();
        this.scaleEqualToSxCheck = new JCheckBox();
        this.rotatePane = new JPanel();
        JLabel jLabel11 = new JLabel();
        this.angleField = new JTextField();
        JLabel jLabel12 = new JLabel();
        this.cxField = new JTextField();
        JLabel jLabel13 = new JLabel();
        this.cyField = new JTextField();
        this.rotateSelectionCenterButton = new JButton();
        JPanel jPanel9 = new JPanel();
        this.skewPane = new JPanel();
        JLabel jLabel14 = new JLabel();
        this.skewXField = new JTextField();
        JLabel jLabel15 = new JLabel();
        this.skewYField = new JTextField();
        JPanel jPanel10 = new JPanel();
        this.matrixPane = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.aField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.cField = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.eField = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.bField = new JTextField();
        JLabel jLabel7 = new JLabel();
        this.dField = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.fField = new JTextField();
        this.jPanel7 = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setMinimumSize(new Dimension(280, 190));
        this.setLayout(new BorderLayout());
        jToolBar1.setFloatable(false);
        this.buttonGroup.add(this.translateButton);
        this.translateButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/toolbox/tool-translate24.png")));
        this.translateButton.setFocusPainted(false);
        jToolBar1.add(this.translateButton);
        this.buttonGroup.add(this.scaleButton);
        this.scaleButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/toolbox/tool-scale24.png")));
        this.scaleButton.setFocusPainted(false);
        jToolBar1.add(this.scaleButton);
        this.buttonGroup.add(this.rotateButton);
        this.rotateButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/toolbox/tool-rotate24.png")));
        this.rotateButton.setFocusPainted(false);
        jToolBar1.add(this.rotateButton);
        this.buttonGroup.add(this.skewButton);
        this.skewButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/toolbox/tool-skew24.png")));
        this.skewButton.setFocusPainted(false);
        jToolBar1.add(this.skewButton);
        this.buttonGroup.add(this.matrixButton);
        this.matrixButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/toolbox/tool-matrix24.png")));
        jToolBar1.add(this.matrixButton);
        this.add((Component)jToolBar1, "North");
        this.centerPane.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
        this.centerPane.setLayout(new CardLayout());
        this.translatePane.setLayout(new GridBagLayout());
        jLabel1.setText("tx");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.translatePane.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.translatePane.add((Component)this.txField, gridBagConstraints);
        jLabel2.setText("ty");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.translatePane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.translatePane.add((Component)this.tyField, gridBagConstraints);
        jPanel6.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.translatePane.add((Component)jPanel6, gridBagConstraints);
        this.centerPane.add((Component)this.translatePane, TRANSFORM_TRANSLATE);
        this.scalePane.setLayout(new GridBagLayout());
        jLabel9.setText("sx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.scalePane.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.scalePane.add((Component)this.sxField, gridBagConstraints);
        jLabel10.setText("sy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.scalePane.add((Component)jLabel10, gridBagConstraints);
        this.syField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.scalePane.add((Component)this.syField, gridBagConstraints);
        jPanel8.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.scalePane.add((Component)jPanel8, gridBagConstraints);
        this.scaleEqualToSxCheck.setSelected(true);
        this.scaleEqualToSxCheck.setText("equal to sx");
        this.scaleEqualToSxCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TransformPane.this.scaleEqualToSxCheckItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.scalePane.add((Component)this.scaleEqualToSxCheck, gridBagConstraints);
        this.centerPane.add((Component)this.scalePane, TRANSFORM_SCALE);
        this.rotatePane.setLayout(new GridBagLayout());
        jLabel11.setText("cy");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.rotatePane.add((Component)jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.rotatePane.add((Component)this.angleField, gridBagConstraints);
        jLabel12.setText("cx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.rotatePane.add((Component)jLabel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.rotatePane.add((Component)this.cxField, gridBagConstraints);
        jLabel13.setText("angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.rotatePane.add((Component)jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.rotatePane.add((Component)this.cyField, gridBagConstraints);
        this.rotateSelectionCenterButton.setText(bundle.getString("CTL_RotateSelectionCenter.Text"));
        this.rotateSelectionCenterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformPane.this.rotateSelectionCenterButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.rotatePane.add((Component)this.rotateSelectionCenterButton, gridBagConstraints);
        jPanel9.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rotatePane.add((Component)jPanel9, gridBagConstraints);
        this.centerPane.add((Component)this.rotatePane, TRANSFORM_ROTATE);
        this.skewPane.setLayout(new GridBagLayout());
        jLabel14.setText("skew x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.skewPane.add((Component)jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.skewPane.add((Component)this.skewXField, gridBagConstraints);
        jLabel15.setText("skew y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.skewPane.add((Component)jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.skewPane.add((Component)this.skewYField, gridBagConstraints);
        jPanel10.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.skewPane.add((Component)jPanel10, gridBagConstraints);
        this.centerPane.add((Component)this.skewPane, TRANSFORM_SKEW);
        this.matrixPane.setLayout(new GridBagLayout());
        jLabel3.setText("a");
        this.matrixPane.add((Component)jLabel3, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)this.aField, gridBagConstraints);
        jLabel4.setText("c");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.matrixPane.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)this.cField, gridBagConstraints);
        jLabel5.setText("e");
        this.matrixPane.add((Component)jLabel5, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)this.eField, gridBagConstraints);
        jLabel6.setText("b");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)this.bField, gridBagConstraints);
        jLabel7.setText("d");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)this.dField, gridBagConstraints);
        jLabel8.setText("f");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.matrixPane.add((Component)this.fField, gridBagConstraints);
        this.jPanel7.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.matrixPane.add((Component)this.jPanel7, gridBagConstraints);
        this.centerPane.add((Component)this.matrixPane, TRANSFORM_MATRIX);
        this.add((Component)this.centerPane, "Center");
    }

    private void scaleEqualToSxCheckItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.syField.setEnabled(false);
        } else {
            this.syField.setEnabled(true);
        }
    }

    private void rotateSelectionCenterButtonActionPerformed(ActionEvent evt) {
        Rectangle2D rect = this.canvas.getCanvasSelection().getSelectionBounds2D();
        if (rect != null) {
            Point2D.Double p = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
            AffineTransform at = this.canvas.getTransform(true);
            try {
                at = at.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            at.transform(p, p);
            this.cxField.setText(Float.toString((float)((Point2D)p).getX()));
            this.cyField.setText(Float.toString((float)((Point2D)p).getY()));
        }
    }

    private void initCustomComponents() {
        ActionListener transformActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformPane.this.transformButtonActionPerformed(evt);
            }
        };
        this.translateButton.addActionListener(transformActionHandler);
        this.scaleButton.addActionListener(transformActionHandler);
        this.rotateButton.addActionListener(transformActionHandler);
        this.skewButton.addActionListener(transformActionHandler);
        this.matrixButton.addActionListener(transformActionHandler);
        this.translateButton.setActionCommand(TRANSFORM_TRANSLATE);
        this.scaleButton.setActionCommand(TRANSFORM_SCALE);
        this.rotateButton.setActionCommand(TRANSFORM_ROTATE);
        this.skewButton.setActionCommand(TRANSFORM_SKEW);
        this.matrixButton.setActionCommand(TRANSFORM_MATRIX);
        Dimension size = new Dimension(220, 220);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.transform = TRANSFORM_TRANSLATE;
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVectorCanvas() {
        CanvasModel model = this.canvas.getModel();
        AffineTransform at = new AffineTransform();
        if (this.transform.equals(TRANSFORM_TRANSLATE)) {
            double tx = 0.0;
            double ty = 0.0;
            try {
                String str = this.txField.getText().trim();
                if (!str.isEmpty()) {
                    tx = Double.parseDouble(str);
                }
                if (!(str = this.tyField.getText().trim()).isEmpty()) {
                    ty = Double.parseDouble(str);
                }
                at.setToTranslation(tx, ty);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_ValueError.Title"), 0);
                return;
            }
        } else if (this.transform.equals(TRANSFORM_SCALE)) {
            Rectangle2D rect = this.canvas.getCanvasSelection().getSelectionBounds2D();
            try {
                double sx = Double.parseDouble(this.sxField.getText().trim());
                double sy = this.scaleEqualToSxCheck.isSelected() ? sx : Double.parseDouble(this.syField.getText().trim());
                at.translate(rect.getX(), rect.getY());
                at.scale(sx, sy);
                at.translate(-rect.getX(), -rect.getY());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_ValueError.Title"), 0);
                return;
            }
        } else if (this.transform.equals(TRANSFORM_ROTATE)) {
            try {
                double angle = Double.parseDouble(this.angleField.getText().trim());
                if (this.cxField.getText().trim().length() > 0 || this.cyField.getText().trim().length() > 0) {
                    double cx = Double.parseDouble(this.cxField.getText().trim());
                    double cy = Double.parseDouble(this.cyField.getText().trim());
                    at.setToRotation(Math.toRadians(angle), cx, cy);
                }
                at.setToRotation(Math.toRadians(angle));
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_ValueError.Title"), 0);
                return;
            }
        } else if (this.transform.equals(TRANSFORM_SKEW)) {
            Rectangle2D rect = this.canvas.getCanvasSelection().getSelectionBounds2D();
            try {
                double skewY;
                double skewX;
                if (this.skewXField.getText().trim().length() > 0) {
                    skewX = Double.parseDouble(this.skewXField.getText().trim());
                    skewX = Math.tan(Math.PI * skewX / 180.0);
                } else {
                    skewX = 0.0;
                }
                if (this.skewYField.getText().trim().length() > 0) {
                    skewY = Double.parseDouble(this.skewYField.getText().trim());
                    skewY = Math.tan(Math.PI * skewY / 180.0);
                } else {
                    skewY = 0.0;
                }
                at.translate(rect.getX(), rect.getY());
                at.shear(skewX, skewY);
                at.translate(-rect.getX(), -rect.getY());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_ValueError.Title"), 0);
                return;
            }
        } else if (this.transform.equals(TRANSFORM_MATRIX)) {
            try {
                double a = Double.parseDouble(this.aField.getText().trim());
                double b = Double.parseDouble(this.bField.getText().trim());
                double c = Double.parseDouble(this.cField.getText().trim());
                double d = Double.parseDouble(this.dField.getText().trim());
                double e = Double.parseDouble(this.eField.getText().trim());
                double f = Double.parseDouble(this.fField.getText().trim());
                at.setTransform(a, b, c, d, e, f);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_ValueError.Title"), 0);
                return;
            }
        } else {
            return;
        }
        double[] values = new double[6];
        at.getMatrix(values);
        List<SVGElement> selectionList = CanvasUtilities.getGraphicsElement(this.canvas.getCanvasSelection().getSelectionList());
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Apply Transform");
        try {
            for (int i = 0; i < selectionList.size(); ++i) {
                SVGElement element = selectionList.get(i);
                if (!(element instanceof SVGTransformable)) continue;
                SVGMatrix matrix = model.getSVGSVGElement().createSVGMatrix();
                matrix.setA((float)values[0]);
                matrix.setB((float)values[1]);
                matrix.setC((float)values[2]);
                matrix.setD((float)values[3]);
                matrix.setE((float)values[4]);
                matrix.setF((float)values[5]);
                SVGTransform svgTransform = model.getSVGSVGElement().createSVGTransformFromMatrix(matrix);
                SVGTransformList transformList = ((SVGTransformable)element).getTransform().getBaseVal();
                transformList.consolidate();
                transformList.insertItemBefore(svgTransform, 0);
                transformList.consolidate();
            }
        }
        finally {
            undoManager.end();
            this.canvas.refresh();
        }
    }

    public String getTitle() {
        return bundle.getString("CTL_Title.Text");
    }

    private void transformButtonActionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        CardLayout cl = (CardLayout)this.centerPane.getLayout();
        cl.show(this.centerPane, command);
        this.transform = command;
    }
}

