/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;
import kiyut.sketsa.util.ColorConvertion;

public class OptionsUtilities {
    private OptionsUtilities() {
        throw new Error("OptionsUtilities is a utility class for static methods");
    }

    public static String fontToString(Font font) {
        String fontName = font.getName();
        String fontStyle = Integer.toString(font.getStyle());
        String fontSize = Integer.toString(font.getSize());
        return fontName + ";" + fontStyle + ";" + fontSize;
    }

    public static Font stringToFont(String value) {
        StringTokenizer st = new StringTokenizer(value, ";");
        String[] strs = new String[3];
        int i = 0;
        while (st.hasMoreTokens()) {
            strs[i] = st.nextToken();
            ++i;
        }
        Font font = new Font(strs[0], Integer.parseInt(strs[1]), Integer.parseInt(strs[2]));
        return font;
    }

    public static String colorToString(Color color) {
        return ColorConvertion.toHexString(color);
    }

    public static Color stringToColor(String value) {
        return ColorConvertion.hexStringToColor(value);
    }

    public static Color stringToColor(String value, Color def) {
        Color color = ColorConvertion.hexStringToColor(value);
        if (color != null) {
            return color;
        }
        return def;
    }
}

