/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.io;

import java.io.IOException;
import java.io.Writer;
import kiyut.sketsa.io.DOMPrettyPrinter;
import kiyut.sketsa.io.NodeRange;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.IntegerKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.w3c.dom.Document;

public class DOMTranscoder
extends AbstractTranscoder {
    public static final ErrorHandler DEFAULT_ERROR_HANDLER = new ErrorHandler(){

        public void error(TranscoderException ex) throws TranscoderException {
            throw ex;
        }

        public void fatalError(TranscoderException ex) throws TranscoderException {
            throw ex;
        }

        public void warning(TranscoderException ex) throws TranscoderException {
        }
    };
    public static final TranscodingHints.Key KEY_NEWLINE = new NewlineKey();
    public static final NewlineValue VALUE_NEWLINE_CR = new NewlineValue("\r");
    public static final NewlineValue VALUE_NEWLINE_CR_LF = new NewlineValue("\r\n");
    public static final NewlineValue VALUE_NEWLINE_LF = new NewlineValue("\n");
    public static final TranscodingHints.Key KEY_FORMAT = new BooleanKey();
    public static final Boolean VALUE_FORMAT_ON = Boolean.TRUE;
    public static final Boolean VALUE_FORMAT_OFF = Boolean.FALSE;
    public static final TranscodingHints.Key KEY_TABULATION_WIDTH = new IntegerKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_WIDTH = new IntegerKey();
    public static final TranscodingHints.Key KEY_XML_DECLARATION = new StringKey();
    public static final TranscodingHints.Key KEY_PUBLIC_ID = new StringKey();
    public static final TranscodingHints.Key KEY_SYSTEM_ID = new StringKey();
    protected NodeRange nodeRange;

    public DOMTranscoder() {
        this.setErrorHandler(DEFAULT_ERROR_HANDLER);
    }

    public void setNodeRange(NodeRange nodeRange) {
        this.nodeRange = nodeRange;
    }

    public void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
        Document d = input.getDocument();
        if (d == null) {
            throw new Error("Document expected");
        }
        Writer w = output.getWriter();
        if (w == null) {
            throw new Error("Writer expected");
        }
        this.prettyPrint(d, w);
    }

    protected void prettyPrint(Document doc, Writer out) throws TranscoderException {
        try {
            String s;
            Integer i;
            Boolean b;
            DOMPrettyPrinter pp = new DOMPrettyPrinter();
            NewlineValue nlv = (NewlineValue)this.hints.get((Object)KEY_NEWLINE);
            if (nlv != null) {
                pp.setNewline(nlv.getValue());
            }
            if ((b = (Boolean)this.hints.get((Object)KEY_FORMAT)) != null) {
                pp.setFormat(b);
            }
            if ((i = (Integer)this.hints.get((Object)KEY_TABULATION_WIDTH)) != null) {
                pp.setTabulationWidth(i);
            }
            if ((i = (Integer)this.hints.get((Object)KEY_DOCUMENT_WIDTH)) != null) {
                pp.setDocumentWidth(i);
            }
            if ((s = (String)this.hints.get((Object)KEY_XML_DECLARATION)) != null) {
                pp.setXMLDeclaration(s);
            }
            if ((s = (String)this.hints.get((Object)KEY_PUBLIC_ID)) != null) {
                pp.setPublicId(s);
            }
            if ((s = (String)this.hints.get((Object)KEY_SYSTEM_ID)) != null) {
                pp.setSystemId(s);
            }
            pp.setNodeRange(this.nodeRange);
            pp.print(doc, out);
        }
        catch (IOException e) {
            this.getErrorHandler().fatalError(new TranscoderException(e.getMessage()));
        }
    }

    public static class NewlineValue {
        protected String value;

        public NewlineValue(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class NewlineKey
    extends TranscodingHints.Key {
        public boolean isCompatibleValue(Object v) {
            return v instanceof NewlineValue;
        }
    }
}

