/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool.point;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.tool.point.AbstractPointTool;
import kiyut.sketsa.canvas.tool.point.PathSegment;
import kiyut.sketsa.canvas.tool.point.PointShape;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.GeomUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;

public class MovePointTool
extends AbstractPointTool {
    private int startX;
    private int startY;
    private int newX;
    private int newY;
    private Rectangle2D bounds = new Rectangle2D.Double();

    @Override
    public void endTool() {
        if (this.canvas != null) {
            this.canvas.getCanvasSelection().setEnabledVisible(true, true, true);
        }
    }

    @Override
    public void startTool() {
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.canvas.repaint();
        this.fireMessageReceived(0, "Click on point and drag to move point");
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.newX = evt.getX();
        this.newY = evt.getY();
        SVGElement selectedElement = this.model.getSelectedElement();
        PathSegment selectedSegment = this.model.getSelectedPathSegment();
        PointShape selectedPoint = this.model.getSelectedPoint();
        if (selectedPoint != null && selectedSegment != null && (evt.getModifiersEx() & 0x40) == 64) {
            List<PathSegment> pathSegmentList;
            Point2D point = null;
            int index = selectedSegment.indexOfPoint(selectedPoint);
            if (index == 0) {
                index = this.model.indexOf(selectedElement);
                pathSegmentList = this.model.getPathSegmentList(index);
                if ((index = pathSegmentList.indexOf(selectedSegment)) == 0 && pathSegmentList.size() > 1) {
                    point = pathSegmentList.get(1).getPoint(0);
                } else if (index > 0) {
                    point = pathSegmentList.get(index - 1).getPoint(0);
                }
            } else if (selectedSegment.getPointCount() == 3) {
                if (index == 1) {
                    index = this.model.indexOf(selectedElement);
                    pathSegmentList = this.model.getPathSegmentList(index);
                    if ((index = pathSegmentList.indexOf(selectedSegment)) > 0) {
                        point = pathSegmentList.get(index - 1).getPoint(0);
                    }
                } else if (index == 2) {
                    point = selectedSegment.getPoint(0);
                }
            } else {
                point = selectedSegment.getPoint(0);
            }
            int pX = this.startX;
            int pY = this.startY;
            if (point != null) {
                pX = (int)point.getX();
                pY = (int)point.getY();
            }
            int dx = this.newX - pX;
            int dy = this.newY - pY;
            double angle = 0.0;
            angle = Math.atan2(this.newY - pY, this.newX - pX);
            if ((angle = Math.toDegrees(angle)) >= -22.5 && angle < 22.5) {
                this.newY = pY;
            } else if (angle >= 22.5 && angle < 67.5) {
                if (angle <= 45.0) {
                    this.newX = pX + dx;
                    this.newY = pY + dx;
                } else {
                    this.newX = pX + dy;
                    this.newY = pY + dy;
                }
            } else if (angle >= 67.5 && angle < 112.5) {
                this.newX = pX;
            } else if (angle >= 112.5 && angle < 157.5) {
                if (angle <= 135.0) {
                    this.newX = pX - dy;
                    this.newY = pY + dy;
                } else {
                    this.newX = pX + dx;
                    this.newY = pY - dx;
                }
            } else if (angle >= 157.5 && angle <= 180.0 || angle >= -180.0 && angle < -157.5) {
                this.newX = pX + dx;
                this.newY = pY;
            } else if (angle >= -157.5 && angle < -112.5) {
                if (angle <= -135.0) {
                    this.newX = pX + dy;
                    this.newY = pY + dy;
                } else {
                    this.newX = pX + dx;
                    this.newY = pY + dx;
                }
            } else if (angle >= -112.5 && angle < -67.5) {
                this.newX = pX;
            } else if (angle >= -67.5 && angle < -22.5) {
                if (angle <= -45.0) {
                    this.newX = pX - dy;
                    this.newY = pY + dy;
                } else {
                    this.newX = pX + dx;
                    this.newY = pY - dx;
                }
            }
        }
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        if (selectedPoint != null && selectedElement != null) {
            selectedPoint.setLocation(this.newX, this.newY);
            int index = this.model.indexOf(selectedElement);
            this.model.updateOutline(index);
            Rectangle2D newBounds = this.model.getSelectedOutline().getBounds2D();
            Rectangle2D.union(this.bounds, newBounds, this.bounds);
            Rectangle r = this.bounds.getBounds();
            this.bounds = newBounds;
            int handleSize = (int)selectedPoint.getBounds().getWidth() + 1;
            this.canvas.repaint(r.x - handleSize / 2, r.y - handleSize / 2, r.width + handleSize, r.height + handleSize);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        this.newX = this.startX;
        this.newY = this.startY;
        boolean flag = false;
        int size = this.model.size();
        for (int i = 0; i < size; ++i) {
            List<PathSegment> pathSegmentList = this.model.getPathSegmentList(i);
            block1: for (int j = 0; j < pathSegmentList.size(); ++j) {
                PathSegment pathSegment = pathSegmentList.get(j);
                for (int k = 0; k < pathSegment.getPointCount(); ++k) {
                    PointShape point = (PointShape)pathSegment.getPoint(k);
                    if (!point.contains(this.startX, this.startY)) continue;
                    this.model.setSelectedElement(this.model.get(i));
                    this.model.setSelectedPathSegment(pathSegment);
                    this.model.setSelectedPoint(point);
                    this.model.updateOutline(i);
                    flag = true;
                    continue block1;
                }
            }
            if (!flag) continue;
            this.bounds = this.model.getSelectedOutline().getBounds2D();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        SVGElement selectedElement = this.model.getSelectedElement();
        PointShape selectedPoint = this.model.getSelectedPoint();
        if (selectedPoint != null && selectedElement != null) {
            ArrayList<Rectangle2D> list = new ArrayList<Rectangle2D>(2);
            GraphicsNode gn = this.canvas.getModel().getGraphicsNode(this.model.getSelectedElement());
            if (gn != null) {
                AffineTransform at = gn.getGlobalTransform();
                Shape shape = gn.getBounds();
                shape = at.createTransformedShape(shape);
                list.add((Rectangle2D)shape);
            }
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Move Point");
            try {
                this.updateDOM();
            }
            finally {
                undoManager.end();
            }
            gn = this.canvas.getModel().getGraphicsNode(this.model.getSelectedElement());
            if (gn != null) {
                AffineTransform at = gn.getGlobalTransform();
                Shape shape = gn.getBounds();
                shape = at.createTransformedShape(shape);
                list.add((Rectangle2D)shape);
            }
            Rectangle2D bounds = GeomUtilities.getBounds2D(list);
            this.canvas.refresh(bounds);
        }
    }

    private void updateDOM() {
        SVGElement element = this.model.getSelectedElement();
        if (element instanceof SVGRectElement) {
            this.updateSVGRectElement((SVGRectElement)element);
        } else if (element instanceof SVGEllipseElement) {
            this.updateSVGEllipseElement((SVGEllipseElement)element);
        } else if (element instanceof SVGCircleElement) {
            this.updateSVGCircleElement((SVGCircleElement)element);
        } else if (element instanceof SVGLineElement) {
            this.updateSVGLineElement((SVGLineElement)element);
        } else if (element instanceof SVGPolylineElement) {
            this.updateSVGPolylineElement((SVGPolylineElement)element);
        } else if (element instanceof SVGPolygonElement) {
            this.updateSVGPolygonElement((SVGPolygonElement)element);
        } else if (element instanceof SVGPathElement) {
            this.updateSVGPathElement((SVGPathElement)element);
        }
        SVGElement selectedElement = this.model.getSelectedElement();
        PathSegment selectedPathSegment = this.model.getSelectedPathSegment();
        PointShape selectedPoint = this.model.getSelectedPoint();
        int indexOf = this.model.indexOf(selectedElement);
        int indexOfPathSegment = this.model.getPathSegmentList(indexOf).indexOf(selectedPathSegment);
        int indexOfPoint = selectedPathSegment.indexOfPoint(selectedPoint);
        this.model.updatePointList(indexOf);
        PathSegment pathSegment = this.model.getPathSegmentList(indexOf).get(indexOfPathSegment);
        PointShape point = (PointShape)pathSegment.getPoint(indexOfPoint);
        this.model.setSelectedPathSegment(pathSegment);
        this.model.setSelectedPoint(point);
    }

    private void updateSVGRectElement(SVGRectElement rectElement) {
        SVGLength eX = rectElement.getX().getBaseVal();
        SVGLength eY = rectElement.getY().getBaseVal();
        SVGLength eW = rectElement.getWidth().getBaseVal();
        SVGLength eH = rectElement.getHeight().getBaseVal();
        SVGLength eRx = rectElement.getRx().getBaseVal();
        SVGLength eRy = rectElement.getRy().getBaseVal();
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        PointShape curPoint = this.model.getSelectedPoint();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)rectElement);
        AffineTransform canvasAt = this.canvas.getTransform();
        AffineTransform at = (AffineTransform)gn.getGlobalTransform().clone();
        at.preConcatenate(canvasAt);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = curPoint.getX();
        srcPts[1] = curPoint.getY();
        at.transform(srcPts, 0, dstPts, 0, 1);
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)rectElement)).indexOf(pathSegment);
        if (indexOf == 0 || indexOf == 5) {
            float value = (float)dstPts[0] - eX.getValue();
            eRx.setValue(value);
        } else if (indexOf == 1 || indexOf == 4) {
            float value = eX.getValue() + eW.getValue() - (float)dstPts[0];
            eRx.setValue(value);
        } else if (indexOf == 7 || indexOf == 2) {
            float value = (float)dstPts[1] - eY.getValue();
            eRy.setValue(value);
        } else if (indexOf == 6 || indexOf == 3) {
            float value = eY.getValue() + eH.getValue() - (float)dstPts[1];
            eRy.setValue(value);
        }
    }

    private void updateSVGEllipseElement(SVGEllipseElement ellipseElement) {
        SVGLength eCx = ellipseElement.getCx().getBaseVal();
        SVGLength eCy = ellipseElement.getCy().getBaseVal();
        SVGLength eRx = ellipseElement.getRx().getBaseVal();
        SVGLength eRy = ellipseElement.getRy().getBaseVal();
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        PointShape curPoint = this.model.getSelectedPoint();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)ellipseElement);
        AffineTransform canvasAt = this.canvas.getTransform();
        AffineTransform at = (AffineTransform)gn.getGlobalTransform().clone();
        at.preConcatenate(canvasAt);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = curPoint.getX();
        srcPts[1] = curPoint.getY();
        at.transform(srcPts, 0, dstPts, 0, 1);
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)ellipseElement)).indexOf(pathSegment);
        if (indexOf == 0) {
            float value = eCy.getValue() - (float)dstPts[1];
            eRy.setValue(value);
        } else if (indexOf == 1) {
            float value = (float)dstPts[0] - eCx.getValue();
            eRx.setValue(value);
        } else if (indexOf == 2) {
            float value = (float)dstPts[1] - eCy.getValue();
            eRy.setValue(value);
        } else if (indexOf == 3) {
            float value = eCx.getValue() - (float)dstPts[0];
            eRx.setValue(value);
        }
    }

    private void updateSVGCircleElement(SVGCircleElement circleElement) {
        SVGLength eCx = circleElement.getCx().getBaseVal();
        SVGLength eCy = circleElement.getCy().getBaseVal();
        SVGLength eR = circleElement.getR().getBaseVal();
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        PointShape curPoint = this.model.getSelectedPoint();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)circleElement);
        AffineTransform canvasAt = this.canvas.getTransform();
        AffineTransform at = (AffineTransform)gn.getGlobalTransform().clone();
        at.preConcatenate(canvasAt);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = curPoint.getX();
        srcPts[1] = curPoint.getY();
        at.transform(srcPts, 0, dstPts, 0, 1);
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)circleElement)).indexOf(pathSegment);
        if (indexOf == 0) {
            float value = eCy.getValue() - (float)dstPts[1];
            eR.setValue(value);
        } else if (indexOf == 1) {
            float value = (float)dstPts[0] - eCx.getValue();
            eR.setValue(value);
        } else if (indexOf == 2) {
            float value = (float)dstPts[1] - eCy.getValue();
            eR.setValue(value);
        } else if (indexOf == 3) {
            float value = eCx.getValue() - (float)dstPts[0];
            eR.setValue(value);
        }
    }

    private void updateSVGLineElement(SVGLineElement lineElement) {
        PointShape point;
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        SVGLength lengthX1 = lineElement.getX1().getBaseVal();
        SVGLength lengthY1 = lineElement.getY1().getBaseVal();
        SVGLength lengthX2 = lineElement.getX2().getBaseVal();
        SVGLength lengthY2 = lineElement.getY2().getBaseVal();
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)lineElement);
        AffineTransform canvasAt = this.canvas.getTransform();
        AffineTransform at = (AffineTransform)gn.getGlobalTransform().clone();
        at.preConcatenate(canvasAt);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)lineElement)).indexOf(pathSegment);
        if (indexOf == 0) {
            point = (PointShape)pathSegment.getPoint(0);
            srcPts[0] = point.getX();
            srcPts[1] = point.getY();
            at.transform(srcPts, 0, dstPts, 0, 1);
            lengthX1.setValue((float)dstPts[0]);
            lengthY1.setValue((float)dstPts[1]);
        }
        if (indexOf == 1) {
            point = (PointShape)pathSegment.getPoint(0);
            srcPts[0] = point.getX();
            srcPts[1] = point.getY();
            at.transform(srcPts, 0, dstPts, 0, 1);
            lengthX2.setValue((float)dstPts[0]);
            lengthY2.setValue((float)dstPts[1]);
        }
    }

    private void updateSVGPolylineElement(SVGPolylineElement polylineElement) {
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        PointShape curPoint = this.model.getSelectedPoint();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)polylineElement);
        AffineTransform canvasAt = this.canvas.getTransform();
        AffineTransform at = (AffineTransform)gn.getGlobalTransform().clone();
        at.preConcatenate(canvasAt);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)polylineElement)).indexOf(pathSegment);
        PointShape point = curPoint;
        SVGPointList svgPointList = polylineElement.getPoints();
        SVGPoint p = svgPointList.getItem(indexOf);
        srcPts[0] = point.getX();
        srcPts[1] = point.getY();
        at.transform(srcPts, 0, dstPts, 0, 1);
        p.setX((float)dstPts[0]);
        p.setY((float)dstPts[1]);
    }

    private void updateSVGPolygonElement(SVGPolygonElement polygonElement) {
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        PointShape curPoint = this.model.getSelectedPoint();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)polygonElement);
        AffineTransform canvasAt = this.canvas.getTransform();
        AffineTransform at = (AffineTransform)gn.getGlobalTransform().clone();
        at.preConcatenate(canvasAt);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        int indexOf = this.model.getPathSegmentList(this.model.indexOf((SVGElement)polygonElement)).indexOf(pathSegment);
        PointShape point = curPoint;
        SVGPointList svgPointList = polygonElement.getPoints();
        SVGPoint p = svgPointList.getItem(indexOf);
        srcPts[0] = point.getX();
        srcPts[1] = point.getY();
        at.transform(srcPts, 0, dstPts, 0, 1);
        p.setX((float)dstPts[0]);
        p.setY((float)dstPts[1]);
    }

    private void updateSVGPathElement(SVGPathElement pathElement) {
        double[] lastPts = new double[2];
        double[] srcPts = new double[6];
        double[] dstPts = new double[6];
        List<PathSegment> pathSegmentList = this.model.getPathSegmentList(this.model.indexOf(this.model.getSelectedElement()));
        PathSegment pathSegment = this.model.getSelectedPathSegment();
        PointShape point = this.model.getSelectedPoint();
        int indexOf = pathSegmentList.indexOf(pathSegment);
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)pathElement);
        AffineTransform canvasAt = this.canvas.getTransform();
        AffineTransform at = (AffineTransform)gn.getGlobalTransform().clone();
        at.preConcatenate(canvasAt);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        lastPts[0] = 0.0;
        lastPts[1] = 0.0;
        SVGPathSegList segList = pathElement.getPathSegList();
        for (int j = 0; j < segList.getNumberOfItems(); ++j) {
            SVGPathSegLinetoAbs line;
            SVGPathSegCurvetoQuadraticAbs quad;
            SVGPathSegCurvetoCubicAbs cubic;
            SVGPathSegArcAbs arc;
            SVGPathSegMovetoAbs moveTo;
            SVGPathSeg pathSeg = segList.getItem(j);
            short type = pathSeg.getPathSegType();
            if (type == 2) {
                moveTo = (SVGPathSegMovetoAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    moveTo.setX((float)dstPts[0]);
                    moveTo.setY((float)dstPts[1]);
                }
                lastPts[0] = moveTo.getX();
                lastPts[1] = moveTo.getY();
                continue;
            }
            if (type == 3) {
                moveTo = (SVGPathSegMovetoRel)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    moveTo.setX((float)dstPts[0] - (float)lastPts[0]);
                    moveTo.setY((float)dstPts[1] - (float)lastPts[1]);
                }
                lastPts[0] = lastPts[0] + (double)moveTo.getX();
                lastPts[1] = lastPts[1] + (double)moveTo.getY();
                continue;
            }
            if (type == 10) {
                arc = (SVGPathSegArcAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    arc.setX((float)dstPts[0]);
                    arc.setY((float)dstPts[1]);
                }
                lastPts[0] = arc.getX();
                lastPts[1] = arc.getY();
                continue;
            }
            if (type == 11) {
                arc = (SVGPathSegArcRel)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    arc.setX((float)dstPts[0] - (float)lastPts[0]);
                    arc.setY((float)dstPts[1] - (float)lastPts[1]);
                }
                lastPts[0] = lastPts[0] + (double)arc.getX();
                lastPts[1] = lastPts[1] + (double)arc.getY();
                continue;
            }
            if (type == 6) {
                cubic = (SVGPathSegCurvetoCubicAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX((float)dstPts[0]);
                    cubic.setY((float)dstPts[1]);
                    point = (PointShape)pathSegment.getPoint(1);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX1((float)dstPts[0]);
                    cubic.setY1((float)dstPts[1]);
                    point = (PointShape)pathSegment.getPoint(2);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX2((float)dstPts[0]);
                    cubic.setY2((float)dstPts[1]);
                }
                lastPts[0] = cubic.getX();
                lastPts[1] = cubic.getY();
                continue;
            }
            if (type == 7) {
                cubic = (SVGPathSegCurvetoCubicRel)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX((float)dstPts[0] - (float)lastPts[0]);
                    cubic.setY((float)dstPts[1] - (float)lastPts[1]);
                    point = (PointShape)pathSegment.getPoint(1);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX1((float)dstPts[0] - (float)lastPts[0]);
                    cubic.setY1((float)dstPts[1] - (float)lastPts[1]);
                    point = (PointShape)pathSegment.getPoint(2);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX2((float)dstPts[0] - (float)lastPts[0]);
                    cubic.setY2((float)dstPts[1] - (float)lastPts[1]);
                }
                lastPts[0] = lastPts[0] + (double)cubic.getX();
                lastPts[1] = lastPts[1] + (double)cubic.getY();
                continue;
            }
            if (type == 16) {
                cubic = (SVGPathSegCurvetoCubicSmoothAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX((float)dstPts[0]);
                    cubic.setY((float)dstPts[1]);
                    point = (PointShape)pathSegment.getPoint(1);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX2((float)dstPts[0]);
                    cubic.setY2((float)dstPts[1]);
                }
                lastPts[0] = cubic.getX();
                lastPts[1] = cubic.getY();
                continue;
            }
            if (type == 17) {
                cubic = (SVGPathSegCurvetoCubicSmoothRel)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX((float)dstPts[0] - (float)lastPts[0]);
                    cubic.setY((float)dstPts[1] - (float)lastPts[1]);
                    point = (PointShape)pathSegment.getPoint(1);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    cubic.setX2((float)dstPts[0] - (float)lastPts[0]);
                    cubic.setY2((float)dstPts[1] - (float)lastPts[1]);
                }
                lastPts[0] = lastPts[0] + (double)cubic.getX();
                lastPts[1] = lastPts[1] + (double)cubic.getY();
                continue;
            }
            if (type == 8) {
                quad = (SVGPathSegCurvetoQuadraticAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    quad.setX((float)dstPts[0]);
                    quad.setY((float)dstPts[1]);
                    point = (PointShape)pathSegment.getPoint(1);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    quad.setX1((float)dstPts[0]);
                    quad.setY1((float)dstPts[1]);
                }
                lastPts[0] = quad.getX();
                lastPts[1] = quad.getY();
                continue;
            }
            if (type == 9) {
                quad = (SVGPathSegCurvetoQuadraticRel)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    quad.setX((float)dstPts[0] - (float)lastPts[0]);
                    quad.setY((float)dstPts[1] - (float)lastPts[1]);
                    point = (PointShape)pathSegment.getPoint(1);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    quad.setX1((float)dstPts[0] - (float)lastPts[0]);
                    quad.setY1((float)dstPts[1] - (float)lastPts[1]);
                }
                lastPts[0] = lastPts[0] + (double)quad.getX();
                lastPts[1] = lastPts[1] + (double)quad.getY();
                continue;
            }
            if (type == 18) {
                quad = (SVGPathSegCurvetoQuadraticSmoothAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    quad.setX((float)dstPts[0]);
                    quad.setY((float)dstPts[1]);
                }
                lastPts[0] = quad.getX();
                lastPts[1] = quad.getY();
                continue;
            }
            if (type == 19) {
                quad = (SVGPathSegCurvetoQuadraticSmoothRel)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    quad.setX((float)dstPts[0] - (float)lastPts[0]);
                    quad.setY((float)dstPts[1] - (float)lastPts[1]);
                }
                lastPts[0] = lastPts[0] + (double)quad.getX();
                lastPts[1] = lastPts[1] + (double)quad.getY();
                continue;
            }
            if (type == 4) {
                line = (SVGPathSegLinetoAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    line.setX((float)dstPts[0]);
                    line.setY((float)dstPts[1]);
                }
                lastPts[0] = line.getX();
                lastPts[1] = line.getY();
                continue;
            }
            if (type == 12) {
                line = (SVGPathSegLinetoHorizontalAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    line.setX((float)dstPts[0]);
                }
                lastPts[0] = line.getX();
                continue;
            }
            if (type == 13) {
                line = (SVGPathSegLinetoHorizontalRel)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    line.setX((float)dstPts[0] - (float)lastPts[0]);
                }
                lastPts[0] = lastPts[0] + (double)line.getX();
                continue;
            }
            if (type == 5) {
                line = (SVGPathSegLinetoRel)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    line.setX((float)dstPts[0] - (float)lastPts[0]);
                    line.setY((float)dstPts[1] - (float)lastPts[1]);
                }
                lastPts[0] = lastPts[0] + (double)line.getX();
                lastPts[1] = lastPts[1] + (double)line.getY();
                continue;
            }
            if (type == 14) {
                line = (SVGPathSegLinetoVerticalAbs)pathSeg;
                if (j == indexOf) {
                    point = (PointShape)pathSegment.getPoint(0);
                    srcPts[0] = point.getX();
                    srcPts[1] = point.getY();
                    at.transform(srcPts, 0, dstPts, 0, 1);
                    line.setY((float)dstPts[1]);
                }
                lastPts[1] = line.getY();
                continue;
            }
            if (type != 15) continue;
            line = (SVGPathSegLinetoVerticalAbs)pathSeg;
            if (j == indexOf) {
                point = (PointShape)pathSegment.getPoint(0);
                srcPts[0] = point.getX();
                srcPts[1] = point.getY();
                at.transform(srcPts, 0, dstPts, 0, 1);
                line.setY((float)dstPts[1] - (float)lastPts[0]);
            }
            lastPts[1] = lastPts[1] + (double)line.getY();
        }
    }
}

