/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGStylable;

public class RectangleTool
extends AbstractTool {
    private VectorCanvas canvas;
    private Rectangle2D rect = new Rectangle2D.Float();
    private Rectangle2D bounds = new Rectangle2D.Double();
    private Paint strokePaint;
    private Paint fillPaint = null;
    private Stroke stroke = new BasicStroke(this.strokeWidth);
    private float strokeWidth = 1.0f;
    private int newX;
    private int newY;
    private int startX;
    private int startY;

    public RectangleTool() {
        this.strokePaint = Color.BLACK;
    }

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        if (this.fillPaint != null) {
            g2d.setPaint(this.fillPaint);
            g2d.fill(this.rect);
        }
        g2d.setPaint(this.strokePaint);
        g2d.setStroke(this.stroke);
        g2d.draw(this.rect);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public void setStrokePaint(Paint strokePaint) {
        this.strokePaint = strokePaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void startTool() {
        this.canvas.getCanvasSelection().setEnabledVisible(false, true, false);
        this.rect.setRect(-1.0, -1.0, -1.0, -1.0);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.fireMessageReceived(0, "Click and drag to draw Rectangle");
    }

    protected void updateRect() {
        double rH;
        double rY;
        double rW;
        double rX;
        if (this.newX >= this.startX) {
            rX = this.startX;
            rW = this.newX - this.startX;
        } else {
            rX = this.newX;
            rW = this.startX - this.newX;
        }
        if (this.newY >= this.startY) {
            rY = this.startY;
            rH = this.newY - this.startY;
        } else {
            rY = this.newY;
            rH = this.startY - this.newY;
        }
        this.rect.setRect(rX, rY, rW, rH);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        if ((evt.getModifiersEx() & 0x40) == 64) {
            int dx = this.newX - this.startX;
            int dy = this.newY - this.startY;
            int d = Math.max(Math.abs(dx), Math.abs(dy));
            this.newX = dx < 0 ? this.startX + d * -1 : this.startX + d;
            this.newY = dy < 0 ? this.startY + d * -1 : this.startY + d;
        }
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        this.bounds.setRect(this.rect.getBounds());
        this.updateRect();
        this.bounds = this.bounds.createUnion(this.rect.getBounds());
        this.canvas.repaint((int)this.bounds.getX() - 1, (int)this.bounds.getY() - 1, (int)this.bounds.getWidth() + 2, (int)this.bounds.getHeight() + 2);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.startX = gridSize * Math.round((float)this.startX / (float)gridSize);
            this.startY = gridSize * Math.round((float)this.startY / (float)gridSize);
        }
        this.newX = this.startX;
        this.newY = this.startY;
        this.rect.setRect(this.startX, this.startY, 0.0, 0.0);
        this.canvas.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.updateRect();
        if (this.rect.isEmpty()) {
            return;
        }
        SVGElement element = this.createSVGElement();
        CanvasModel model = this.canvas.getModel();
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Draw Rectangle");
        model.appendChild((Element)element);
        undoManager.end();
        ArrayList<SVGElement> selectionList = new ArrayList<SVGElement>(1);
        selectionList.add(element);
        this.canvas.getCanvasSelection().setSelectionList(selectionList);
        this.startTool();
        this.canvas.refresh();
    }

    protected SVGElement createSVGElement() {
        String str;
        CanvasModel model = this.canvas.getModel();
        SVGDocument svgDocument = model.getSVGDocument();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGElement element = (SVGElement)svgDocument.createElementNS(svgNS, "rect");
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            // empty catch block
        }
        Rectangle2D r = at.createTransformedShape(this.rect).getBounds2D();
        element.setAttributeNS(null, "x", Float.toString((float)r.getX()));
        element.setAttributeNS(null, "y", Float.toString((float)r.getY()));
        element.setAttributeNS(null, "width", Float.toString((float)r.getWidth()));
        element.setAttributeNS(null, "height", Float.toString((float)r.getHeight()));
        SVGStylable stylable = (SVGStylable)element;
        if (this.strokePaint != null) {
            if (this.strokePaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.strokePaint);
                DOMUtilities.updateProperty(stylable, null, "stroke", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "stroke", "none");
        }
        if (this.fillPaint != null) {
            if (this.fillPaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.fillPaint);
                DOMUtilities.updateProperty(stylable, null, "fill", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "fill", "none");
        }
        return element;
    }
}

