/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.options.CanvasOptions;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegClosePath;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGStylable;

public class PenTool
extends AbstractTool {
    protected VectorCanvas canvas;
    protected Paint strokePaint;
    protected Paint fillPaint = null;
    protected Stroke stroke;
    protected float strokeWidth = 1.0f;
    private int x;
    private int y;
    private int startX;
    private int startY;
    private Rectangle2D initHandle;
    private Stroke dashed;
    private CubicCurve2D lastCubic;
    private CubicCurve2D cubic;
    private Rectangle2D bounds = new Rectangle2D.Double();
    private boolean appendFlag;
    private SVGElement element;

    public PenTool() {
        this.stroke = new BasicStroke(this.strokeWidth);
        this.strokePaint = Color.BLACK;
        this.reset();
        float[] dash1 = new float[]{4.0f};
        this.dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    }

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.strokePaint);
        g2d.setStroke(this.stroke);
        if (this.initHandle != null) {
            g2d.fill(this.initHandle);
        }
        g2d.draw(this.lastCubic);
        Rectangle2D.Float r = new Rectangle2D.Float();
        double dx1 = this.lastCubic.getX1();
        double dy1 = this.lastCubic.getY1();
        double dx2 = this.lastCubic.getX2();
        double dy2 = this.lastCubic.getY2();
        double x1 = this.lastCubic.getCtrlX1();
        double y1 = this.lastCubic.getCtrlY1();
        double x2 = this.lastCubic.getCtrlX2();
        double y2 = this.lastCubic.getCtrlY2();
        double rx1 = this.reflect(x1, dx1);
        double ry1 = this.reflect(y1, dy1);
        double rx2 = this.reflect(x2, dx2);
        double ry2 = this.reflect(y2, dy2);
        CanvasOptions prefs = CanvasOptions.getInstance();
        int handleSize = prefs.getHandleSize() / 2;
        r.setFrameFromCenter(x1, y1, x1 - (double)handleSize, y1 - (double)handleSize);
        g2d.draw(r);
        r.setFrameFromCenter(rx1, ry1, rx1 - (double)handleSize, ry1 - (double)handleSize);
        g2d.draw(r);
        r.setFrameFromCenter(x2, y2, x2 - (double)handleSize, y2 - (double)handleSize);
        g2d.draw(r);
        r.setFrameFromCenter(rx2, ry2, rx2 - (double)handleSize, ry2 - (double)handleSize);
        g2d.draw(r);
        g2d.setStroke(this.dashed);
        g2d.drawLine((int)x1, (int)y1, (int)rx1, (int)ry1);
        g2d.drawLine((int)x2, (int)y2, (int)rx2, (int)ry2);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public void setStrokePaint(Paint strokePaint) {
        this.strokePaint = strokePaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void startTool() {
        this.reset();
        this.canvas.getCanvasSelection().setEnabledVisible(false, true, false);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.fireMessageReceived(0, "Click and drag to draw Curve. Click on initial point to close the Curve");
    }

    private void reset() {
        this.initHandle = null;
        this.lastCubic = new CubicCurve2D.Float();
        this.cubic = new CubicCurve2D.Float();
        this.appendFlag = false;
    }

    private double reflect(double axis, double determinant) {
        double dist = axis - determinant;
        return determinant - dist;
    }

    private Rectangle2D calculateBounds(CubicCurve2D lastCubic) {
        Area area = new Area();
        area.add(new Area(lastCubic.getBounds()));
        Rectangle2D.Double r = new Rectangle2D.Double();
        CanvasOptions prefs = CanvasOptions.getInstance();
        int handleSize = prefs.getHandleSize() / 2;
        double dx2 = lastCubic.getX2();
        double dy2 = lastCubic.getY2();
        double x2 = lastCubic.getCtrlX2();
        double y2 = lastCubic.getCtrlY2();
        double rx2 = this.reflect(x2, dx2);
        double ry2 = this.reflect(y2, dy2);
        r.setFrameFromCenter(x2, y2, x2 - (double)handleSize, y2 - (double)handleSize);
        area.add(new Area(r.getBounds()));
        r.setFrameFromCenter(rx2, ry2, rx2 - (double)handleSize, ry2 - (double)handleSize);
        area.add(new Area(r.getBounds()));
        return area.getBounds2D();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.x = evt.getX();
        this.y = evt.getY();
        if ((evt.getModifiersEx() & 0x40) == 64) {
            int dx = this.x - this.startX;
            int dy = this.y - this.startY;
            double angle = 0.0;
            angle = Math.atan2(this.y - this.startY, this.x - this.startX);
            if ((angle = Math.toDegrees(angle)) >= -22.5 && angle < 22.5) {
                this.y = this.startY;
            } else if (angle >= 22.5 && angle < 67.5) {
                if (angle <= 45.0) {
                    this.x = this.startX + dx;
                    this.y = this.startY + dx;
                } else {
                    this.x = this.startX + dy;
                    this.y = this.startY + dy;
                }
            } else if (angle >= 67.5 && angle < 112.5) {
                this.x = this.startX;
            } else if (angle >= 112.5 && angle < 157.5) {
                if (angle <= 135.0) {
                    this.x = this.startX - dy;
                    this.y = this.startY + dy;
                } else {
                    this.x = this.startX + dx;
                    this.y = this.startY - dx;
                }
            } else if (angle >= 157.5 && angle <= 180.0 || angle >= -180.0 && angle < -157.5) {
                this.x = this.startX + dx;
                this.y = this.startY;
            } else if (angle >= -157.5 && angle < -112.5) {
                if (angle <= -135.0) {
                    this.x = this.startX + dy;
                    this.y = this.startY + dy;
                } else {
                    this.x = this.startX + dx;
                    this.y = this.startY + dx;
                }
            } else if (angle >= -112.5 && angle < -67.5) {
                this.x = this.startX;
            } else if (angle >= -67.5 && angle < -22.5) {
                if (angle <= -45.0) {
                    this.x = this.startX - dy;
                    this.y = this.startY + dy;
                } else {
                    this.x = this.startX + dx;
                    this.y = this.startY - dx;
                }
            }
        }
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.x = gridSize * Math.round((float)this.x / (float)gridSize);
            this.y = gridSize * Math.round((float)this.y / (float)gridSize);
        }
        this.cubic.setCurve(this.cubic.getX1(), this.cubic.getY1(), this.x, this.y, this.cubic.getCtrlX2(), this.cubic.getCtrlY2(), this.cubic.getX2(), this.cubic.getY2());
        double reflectX = this.reflect(this.x, this.cubic.getX1());
        double reflectY = this.reflect(this.y, this.cubic.getY1());
        this.lastCubic.setCurve(this.lastCubic.getX1(), this.lastCubic.getY1(), this.lastCubic.getCtrlX1(), this.lastCubic.getCtrlY1(), reflectX, reflectY, this.lastCubic.getX2(), this.lastCubic.getY2());
        Rectangle2D newBounds = this.calculateBounds(this.lastCubic);
        Rectangle2D.union(this.bounds, newBounds, this.bounds);
        Rectangle r = this.bounds.getBounds();
        this.canvas.repaint(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        this.bounds = newBounds;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (evt.getClickCount() >= 2) {
            this.startTool();
            this.canvas.refresh();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.x = evt.getX();
        this.y = evt.getY();
        this.startX = this.x;
        this.startY = this.y;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.x = gridSize * Math.round((float)this.x / (float)gridSize);
            this.y = gridSize * Math.round((float)this.y / (float)gridSize);
        }
        if (this.initHandle == null) {
            this.initHandle = new Rectangle2D.Float();
            CanvasOptions prefs = CanvasOptions.getInstance();
            int handleSize = prefs.getHandleSize() / 2;
            this.initHandle.setFrameFromCenter(this.x, this.y, this.x - handleSize, this.y - handleSize);
            this.lastCubic.setCurve(this.x, this.y, this.x, this.y, this.x, this.y, this.x, this.y);
            this.cubic.setCurve(this.x, this.y, this.x, this.y, this.x, this.y, this.x, this.y);
            this.element = this.createSVGElement();
            SVGPathSeg svgPathSeg = this.createSVGPathSegMovetoAbs(this.x, this.y);
            this.addSVGSeg(svgPathSeg);
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Draw Curve");
            CanvasModel model = this.canvas.getModel();
            model.appendChild((Element)this.element);
            undoManager.end();
            ArrayList<SVGElement> selectionList = new ArrayList<SVGElement>(1);
            selectionList.add(this.element);
            this.canvas.getCanvasSelection().setVisible(false, false);
            this.canvas.getCanvasSelection().setSelectionList(selectionList);
        } else {
            this.cubic.setCurve(this.cubic.getX1(), this.cubic.getY1(), this.cubic.getCtrlX1(), this.cubic.getCtrlY1(), this.x, this.y, this.x, this.y);
            this.lastCubic = (CubicCurve2D)this.cubic.clone();
            this.cubic.setCurve(this.lastCubic.getX2(), this.lastCubic.getY2(), this.x, this.y, this.x, this.y, this.x, this.y);
            this.appendFlag = true;
        }
        this.canvas.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (this.appendFlag) {
            SVGPathElement pathElement = (SVGPathElement)this.element;
            SVGPathSeg svgPathSeg = this.createSVGPathSegCurvetoCubicAbs(this.lastCubic);
            this.addSVGSeg(svgPathSeg);
            if (this.initHandle.contains(evt.getPoint())) {
                SVGPathSegClosePath svgClosePath = pathElement.createSVGPathSegClosePath();
                this.addSVGSeg((SVGPathSeg)svgClosePath);
            }
            this.canvas.refresh();
        }
    }

    private SVGElement createSVGElement() {
        String str;
        CanvasModel model = this.canvas.getModel();
        SVGDocument svgDocument = model.getSVGDocument();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGElement elt = (SVGElement)svgDocument.createElementNS(svgNS, "path");
        SVGStylable stylable = (SVGStylable)elt;
        if (this.strokePaint != null) {
            if (this.strokePaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.strokePaint);
                DOMUtilities.updateProperty(stylable, null, "stroke", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "stroke", "none");
        }
        if (this.fillPaint != null) {
            if (this.fillPaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.fillPaint);
                DOMUtilities.updateProperty(stylable, null, "fill", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "fill", "none");
        }
        return elt;
    }

    private void addSVGSeg(SVGPathSeg svgPathSeg) {
        SVGPathElement pathElement = (SVGPathElement)this.element;
        pathElement.getPathSegList().appendItem(svgPathSeg);
    }

    private SVGPathSeg createSVGPathSegMovetoAbs(float x, float y) {
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = x;
        srcPts[1] = y;
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 1);
        SVGPathElement pathElement = (SVGPathElement)this.element;
        SVGPathSegMovetoAbs svgMoveTo = pathElement.createSVGPathSegMovetoAbs((float)dstPts[0], (float)dstPts[1]);
        return svgMoveTo;
    }

    private SVGPathSeg createSVGPathSegCurvetoCubicAbs(CubicCurve2D cubicCurve) {
        double[] srcPts = new double[6];
        double[] dstPts = new double[6];
        srcPts[0] = cubicCurve.getX2();
        srcPts[1] = cubicCurve.getY2();
        srcPts[2] = cubicCurve.getCtrlX1();
        srcPts[3] = cubicCurve.getCtrlY1();
        srcPts[4] = cubicCurve.getCtrlX2();
        srcPts[5] = cubicCurve.getCtrlY2();
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 3);
        SVGPathElement pathElement = (SVGPathElement)this.element;
        SVGPathSegCurvetoCubicAbs svgCubic = pathElement.createSVGPathSegCurvetoCubicAbs((float)dstPts[0], (float)dstPts[1], (float)dstPts[2], (float)dstPts[3], (float)dstPts[4], (float)dstPts[5]);
        return svgCubic;
    }
}

