/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGStylable;

public class LineTool
extends AbstractTool {
    private VectorCanvas canvas;
    private Line2D line = new Line2D.Double();
    private Rectangle2D bounds = new Rectangle2D.Double();
    private Paint strokePaint;
    private Paint fillPaint = null;
    private Stroke stroke = new BasicStroke(this.strokeWidth);
    private float strokeWidth = 1.0f;
    private int x;
    private int y;
    private int lastX;
    private int lastY;
    private int startX;
    private int startY;

    public LineTool() {
        this.strokePaint = Color.BLACK;
    }

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        if (this.fillPaint != null) {
            g2d.setPaint(this.fillPaint);
            g2d.fill(this.line);
        }
        g2d.setPaint(this.strokePaint);
        g2d.setStroke(this.stroke);
        g2d.draw(this.line);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public void setStrokePaint(Paint strokePaint) {
        this.strokePaint = strokePaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void startTool() {
        this.canvas.getCanvasSelection().setEnabledVisible(false, true, false);
        this.line.setLine(-1.0, -1.0, -1.0, -1.0);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.fireMessageReceived(0, "Click and drag to draw Line");
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.lastX = this.x;
        this.lastY = this.y;
        this.x = evt.getX();
        this.y = evt.getY();
        if ((evt.getModifiersEx() & 0x40) == 64) {
            int dx = this.x - this.startX;
            int dy = this.y - this.startY;
            double angle = 0.0;
            angle = Math.atan2(this.y - this.startY, this.x - this.startX);
            if ((angle = Math.toDegrees(angle)) >= -22.5 && angle < 22.5) {
                this.y = this.startY;
            } else if (angle >= 22.5 && angle < 67.5) {
                if (angle <= 45.0) {
                    this.x = this.startX + dx;
                    this.y = this.startY + dx;
                } else {
                    this.x = this.startX + dy;
                    this.y = this.startY + dy;
                }
            } else if (angle >= 67.5 && angle < 112.5) {
                this.x = this.startX;
            } else if (angle >= 112.5 && angle < 157.5) {
                if (angle <= 135.0) {
                    this.x = this.startX - dy;
                    this.y = this.startY + dy;
                } else {
                    this.x = this.startX + dx;
                    this.y = this.startY - dx;
                }
            } else if (angle >= 157.5 && angle <= 180.0 || angle >= -180.0 && angle < -157.5) {
                this.x = this.startX + dx;
                this.y = this.startY;
            } else if (angle >= -157.5 && angle < -112.5) {
                if (angle <= -135.0) {
                    this.x = this.startX + dy;
                    this.y = this.startY + dy;
                } else {
                    this.x = this.startX + dx;
                    this.y = this.startY + dx;
                }
            } else if (angle >= -112.5 && angle < -67.5) {
                this.x = this.startX;
            } else if (angle >= -67.5 && angle < -22.5) {
                if (angle <= -45.0) {
                    this.x = this.startX - dy;
                    this.y = this.startY + dy;
                } else {
                    this.x = this.startX + dx;
                    this.y = this.startY - dx;
                }
            }
        }
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.x = gridSize * Math.round((float)this.x / (float)gridSize);
            this.y = gridSize * Math.round((float)this.y / (float)gridSize);
        }
        this.bounds.setRect(this.line.getBounds());
        this.line.setLine(this.line.getX1(), this.line.getY1(), this.line.getX2() + (double)this.x - (double)this.lastX, this.line.getY2() + (double)this.y - (double)this.lastY);
        this.bounds = this.bounds.createUnion(this.line.getBounds());
        this.canvas.repaint((int)this.bounds.getX() - 1, (int)this.bounds.getY() - 1, (int)this.bounds.getWidth() + 2, (int)this.bounds.getHeight() + 2);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        this.x = this.startX;
        this.y = this.startY;
        this.lastX = this.x;
        this.lastY = this.y;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.x = gridSize * Math.round((float)this.x / (float)gridSize);
            this.y = gridSize * Math.round((float)this.y / (float)gridSize);
        }
        this.line.setLine(this.x, this.y, this.x, this.y);
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        double dist = this.line.getP1().distance(this.line.getP2());
        if (dist >= 0.0 && dist < 1.0) {
            return;
        }
        SVGElement element = this.createSVGElement();
        CanvasModel model = this.canvas.getModel();
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Draw Line");
        try {
            model.appendChild((Element)element);
        }
        finally {
            undoManager.end();
        }
        ArrayList<SVGElement> selectionList = new ArrayList<SVGElement>(1);
        selectionList.add(element);
        this.canvas.getCanvasSelection().setSelectionList(selectionList);
        this.startTool();
        this.canvas.refresh();
    }

    protected SVGElement createSVGElement() {
        String str;
        CanvasModel model = this.canvas.getModel();
        SVGDocument svgDocument = model.getSVGDocument();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGElement element = (SVGElement)svgDocument.createElementNS(svgNS, "line");
        double[] srcPts = new double[4];
        double[] dstPts = new double[4];
        srcPts[0] = this.line.getX1();
        srcPts[1] = this.line.getY1();
        srcPts[2] = this.line.getX2();
        srcPts[3] = this.line.getY2();
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 2);
        element.setAttributeNS(null, "x1", Float.toString((float)dstPts[0]));
        element.setAttributeNS(null, "y1", Float.toString((float)dstPts[1]));
        element.setAttributeNS(null, "x2", Float.toString((float)dstPts[2]));
        element.setAttributeNS(null, "y2", Float.toString((float)dstPts[3]));
        SVGStylable stylable = (SVGStylable)element;
        if (this.strokePaint != null) {
            if (this.strokePaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.strokePaint);
                DOMUtilities.updateProperty(stylable, null, "stroke", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "stroke", "none");
        }
        if (this.fillPaint != null) {
            if (this.fillPaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.fillPaint);
                DOMUtilities.updateProperty(stylable, null, "fill", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "fill", "none");
        }
        return element;
    }
}

