/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractSelectionTool;
import org.w3c.dom.svg.SVGElement;

public class DefaultSelectionTool
extends AbstractSelectionTool {
    protected VectorCanvas canvas;
    protected Rectangle2D rect = new Rectangle2D.Double();
    protected Rectangle2D bounds = new Rectangle2D.Double();
    protected int startX;
    protected int startY;
    protected int newX;
    protected int newY;

    public DefaultSelectionTool() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Dimension dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            Image cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/canvas/tool/default-selection-cursor32.png"));
            this.cursor = toolkit.createCustomCursor(cursorImage, new Point(11, 7), "DEFAULT_SELECTION_CURSOR");
        }
        catch (Exception e) {
            this.cursor = Cursor.getDefaultCursor();
        }
    }

    @Override
    public void paint(Graphics2D g2d) {
        if (this.canvas == null) {
            return;
        }
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
        g2d.draw(this.rect);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        this.canvas.getCanvasSelection().setEnabledVisible(true, true, true);
        if (this.canvas.getCursor() != this.cursor) {
            this.canvas.setCursor(this.cursor);
        }
        this.rect.setRect(0.0, 0.0, 0.0, 0.0);
        this.fireMessageReceived(0, "Draw rectangular selection. Press escape to clear selection");
        this.canvas.repaint();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        this.newX = evt.getX();
        this.newY = evt.getY();
        this.rect.setRect(this.startX, this.startY, 0.0, 0.0);
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        List<SVGElement> list;
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        this.updateRect();
        Cursor prevCursor = this.canvas.getCursor();
        this.canvas.setCursor(Cursor.getPredefinedCursor(3));
        try {
            List<SVGElement> oldList;
            if (this.rect.isEmpty()) {
                list = CanvasUtilities.getSVGElementAt(this.canvas, evt.getPoint(), false);
                if (list.size() > 1) {
                    SVGElement o = list.get(0);
                    list.clear();
                    list.add(o);
                }
            } else {
                list = CanvasUtilities.getSVGElementAt(this.canvas, this.rect, false);
            }
            if ((evt.getModifiersEx() & 0x40) == 64 && (oldList = this.canvas.getCanvasSelection().getSelectionList()) != null && list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    SVGElement obj = list.get(i);
                    int indexOf = oldList.indexOf(obj);
                    if (indexOf >= 0) continue;
                    oldList.add(obj);
                }
                list = oldList;
            }
            this.rect.setRect(-1.0, -1.0, 0.0, 0.0);
        }
        finally {
            this.canvas.setCursor(prevCursor);
        }
        this.canvas.getCanvasSelection().setSelectionList(list);
        this.canvas.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        this.bounds.setRect(this.rect.getBounds());
        this.updateRect();
        this.bounds = this.bounds.createUnion(this.rect.getBounds());
        this.canvas.repaint((int)this.bounds.getX() - 1, (int)this.bounds.getY() - 1, (int)this.bounds.getWidth() + 2, (int)this.bounds.getHeight() + 2);
    }

    private void updateRect() {
        double rH;
        double rY;
        double rW;
        double rX;
        if (this.newX >= this.startX) {
            rX = this.startX;
            rW = this.newX - this.startX;
        } else {
            rX = this.newX;
            rW = this.startX - this.newX;
        }
        if (this.newY >= this.startY) {
            rY = this.startY;
            rH = this.newY - this.startY;
        } else {
            rY = this.newY;
            rH = this.startY - this.newY;
        }
        this.rect.setRect(rX, rY, rW, rH);
    }
}

