/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.canvas.tool.MoveTool;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.GeomUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGTRefElement;
import org.w3c.dom.svg.SVGTSpanElement;
import org.w3c.dom.svg.SVGTextElement;
import org.w3c.dom.svg.SVGUseElement;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class DefaultMoveTool
extends AbstractTool
implements MoveTool {
    private VectorCanvas canvas;
    private Stroke stroke = new BasicStroke(1.0f);
    private int startX;
    private int startY;
    private int tx;
    private int ty;
    private List<SVGElement> selectionList = new ArrayList<SVGElement>();
    private List<Shape> outlineList = new ArrayList<Shape>();
    private List<Shape> newOutlineList = new ArrayList<Shape>();
    private Rectangle2D bounds;
    private boolean keyRepeat = false;
    private boolean keyRelease = false;
    private Timer keyTimer = new Timer(5, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            DefaultMoveTool.this.keyRelease = true;
            DefaultMoveTool.this.keyTimer.stop();
            DefaultMoveTool.this.keyReleased(DefaultMoveTool.this.keyReleaseEvent);
        }
    });
    private KeyEvent keyReleaseEvent;

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        g2d.setStroke(this.stroke);
        for (int i = 0; i < this.newOutlineList.size(); ++i) {
            Shape shape = this.newOutlineList.get(i);
            g2d.draw(shape);
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void endTool() {
        this.selectionList.clear();
        this.outlineList.clear();
        this.newOutlineList.clear();
        this.keyRepeat = false;
    }

    @Override
    public void startTool() {
        this.keyRepeat = false;
        this.fireMessageReceived(0, "Drag to move selection");
    }

    protected void updateDOM() {
        if (this.selectionList.isEmpty()) {
            return;
        }
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = this.tx;
        srcPts[1] = this.ty;
        AffineTransform canvasAt = this.canvas.getTransform();
        float dx = 0.0f;
        float dy = 0.0f;
        CanvasModel model = this.canvas.getModel();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGPoint p;
            SVGPointList pointList;
            SVGLength lengthX;
            SVGSVGElement svgElement;
            GraphicsNode gn = model.getGraphicsNode(this.selectionList.get(i));
            if (gn == null) continue;
            SVGElement element = model.getSVGElement(gn);
            AffineTransform at = null;
            at = element instanceof SVGSVGElement ? new AffineTransform() : (AffineTransform)gn.getGlobalTransform().clone();
            double transX = at.getTranslateX();
            double transY = at.getTranslateY();
            dstPts[0] = srcPts[0] + transX;
            dstPts[1] = srcPts[1] + transY;
            at.concatenate(canvasAt);
            try {
                at = at.createInverse();
            }
            catch (NoninvertibleTransformException ex) {
                // empty catch block
            }
            at.transform(dstPts, 0, dstPts, 0, 1);
            dx = (float)dstPts[0];
            dy = (float)dstPts[1];
            if (element instanceof SVGTextElement) {
                this.updateTextElement((SVGTextElement)element, dx, dy);
                continue;
            }
            if (element instanceof SVGSVGElement) {
                svgElement = (SVGSVGElement)element;
                lengthX = svgElement.getX().getBaseVal();
                SVGLength lengthY = svgElement.getY().getBaseVal();
                lengthX.setValue(lengthX.getValue() + dx);
                lengthY.setValue(lengthY.getValue() + dy);
                System.out.println(dx + "," + dy);
                continue;
            }
            if (element instanceof SVGImageElement) {
                svgElement = (SVGImageElement)element;
                lengthX = svgElement.getX().getBaseVal();
                SVGLength lengthY = svgElement.getY().getBaseVal();
                lengthX.setValue(lengthX.getValue() + dx);
                lengthY.setValue(lengthY.getValue() + dy);
                continue;
            }
            if (element instanceof SVGUseElement) {
                svgElement = (SVGUseElement)element;
                lengthX = svgElement.getX().getBaseVal();
                SVGLength lengthY = svgElement.getY().getBaseVal();
                lengthX.setValue(lengthX.getValue() + dx);
                lengthY.setValue(lengthY.getValue() + dy);
                continue;
            }
            if (element instanceof SVGRectElement) {
                svgElement = (SVGRectElement)element;
                lengthX = svgElement.getX().getBaseVal();
                SVGLength lengthY = svgElement.getY().getBaseVal();
                lengthX.setValue(lengthX.getValue() + dx);
                lengthY.setValue(lengthY.getValue() + dy);
                continue;
            }
            if (element instanceof SVGEllipseElement) {
                svgElement = (SVGEllipseElement)element;
                lengthX = svgElement.getCx().getBaseVal();
                SVGLength lengthY = svgElement.getCy().getBaseVal();
                lengthX.setValue(lengthX.getValue() + dx);
                lengthY.setValue(lengthY.getValue() + dy);
                continue;
            }
            if (element instanceof SVGCircleElement) {
                svgElement = (SVGCircleElement)element;
                lengthX = svgElement.getCx().getBaseVal();
                SVGLength lengthY = svgElement.getCy().getBaseVal();
                lengthX.setValue(lengthX.getValue() + dx);
                lengthY.setValue(lengthY.getValue() + dy);
                continue;
            }
            if (element instanceof SVGLineElement) {
                svgElement = (SVGLineElement)element;
                SVGLength lengthX1 = svgElement.getX1().getBaseVal();
                SVGLength lengthY1 = svgElement.getY1().getBaseVal();
                SVGLength lengthX2 = svgElement.getX2().getBaseVal();
                SVGLength lengthY2 = svgElement.getY2().getBaseVal();
                lengthX1.setValue(lengthX1.getValue() + dx);
                lengthY1.setValue(lengthY1.getValue() + dy);
                lengthX2.setValue(lengthX2.getValue() + dx);
                lengthY2.setValue(lengthY2.getValue() + dy);
                continue;
            }
            if (element instanceof SVGPolylineElement) {
                svgElement = (SVGPolylineElement)element;
                pointList = svgElement.getPoints();
                for (int j = 0; j < pointList.getNumberOfItems(); ++j) {
                    p = pointList.getItem(j);
                    p.setX(p.getX() + dx);
                    p.setY(p.getY() + dy);
                }
                continue;
            }
            if (element instanceof SVGPolygonElement) {
                svgElement = (SVGPolygonElement)element;
                pointList = svgElement.getPoints();
                for (int j = 0; j < pointList.getNumberOfItems(); ++j) {
                    p = pointList.getItem(j);
                    p.setX(p.getX() + dx);
                    p.setY(p.getY() + dy);
                }
                continue;
            }
            if (!(element instanceof SVGPathElement)) continue;
            svgElement = (SVGPathElement)element;
            SVGPathSegList segList = svgElement.getPathSegList();
            for (int j = 0; j < segList.getNumberOfItems(); ++j) {
                SVGPathSegLinetoAbs line;
                SVGPathSegCurvetoQuadraticAbs quad;
                SVGPathSegCurvetoCubicAbs cubic;
                SVGPathSegMovetoAbs moveTo;
                SVGPathSeg pathSeg = segList.getItem(j);
                short type = pathSeg.getPathSegType();
                if (type == 2) {
                    moveTo = (SVGPathSegMovetoAbs)pathSeg;
                    moveTo.setX(moveTo.getX() + dx);
                    moveTo.setY(moveTo.getY() + dy);
                    continue;
                }
                if (type == 3) {
                    moveTo = (SVGPathSegMovetoRel)pathSeg;
                    moveTo.setX(moveTo.getX() + dx);
                    moveTo.setY(moveTo.getY() + dy);
                    continue;
                }
                if (type == 10) {
                    SVGPathSegArcAbs arc = (SVGPathSegArcAbs)pathSeg;
                    arc.setX(arc.getX() + dx);
                    arc.setY(arc.getY() + dy);
                    continue;
                }
                if (type == 6) {
                    cubic = (SVGPathSegCurvetoCubicAbs)pathSeg;
                    cubic.setX(cubic.getX() + dx);
                    cubic.setY(cubic.getY() + dy);
                    cubic.setX1(cubic.getX1() + dx);
                    cubic.setY1(cubic.getY1() + dy);
                    cubic.setX2(cubic.getX2() + dx);
                    cubic.setY2(cubic.getY2() + dy);
                    continue;
                }
                if (type == 16) {
                    cubic = (SVGPathSegCurvetoCubicSmoothAbs)pathSeg;
                    cubic.setX(cubic.getX() + dx);
                    cubic.setY(cubic.getY() + dy);
                    cubic.setX2(cubic.getX2() + dx);
                    cubic.setY2(cubic.getY2() + dy);
                    continue;
                }
                if (type == 8) {
                    quad = (SVGPathSegCurvetoQuadraticAbs)pathSeg;
                    quad.setX(quad.getX() + dx);
                    quad.setY(quad.getY() + dy);
                    quad.setX1(quad.getX1() + dx);
                    quad.setY1(quad.getY1() + dy);
                    continue;
                }
                if (type == 18) {
                    quad = (SVGPathSegCurvetoQuadraticSmoothAbs)pathSeg;
                    quad.setX(quad.getX() + dx);
                    quad.setY(quad.getY() + dy);
                    continue;
                }
                if (type == 4) {
                    line = (SVGPathSegLinetoAbs)pathSeg;
                    line.setX(line.getX() + dx);
                    line.setY(line.getY() + dy);
                    continue;
                }
                if (type == 12) {
                    line = (SVGPathSegLinetoHorizontalAbs)pathSeg;
                    line.setX(line.getX() + dx);
                    continue;
                }
                if (type != 14) continue;
                line = (SVGPathSegLinetoVerticalAbs)pathSeg;
                line.setY(line.getY() + dy);
            }
        }
    }

    protected void updateOutline() {
        AffineTransform at = AffineTransform.getTranslateInstance(this.tx, this.ty);
        this.newOutlineList.clear();
        for (int i = 0; i < this.outlineList.size(); ++i) {
            Shape shape = this.outlineList.get(i);
            shape = at.createTransformedShape(shape);
            this.newOutlineList.add(shape);
        }
    }

    private void updateTextElement(SVGTextElement elt, float dx, float dy) {
        NodeFilter nodeFilter = new NodeFilter(){

            @Override
            public short acceptNode(Node n) {
                if (n instanceof SVGTextElement) {
                    return 1;
                }
                if (n instanceof SVGTSpanElement) {
                    return 1;
                }
                if (n instanceof SVGTRefElement) {
                    return 1;
                }
                return 2;
            }
        };
        DocumentTraversal traversal = (DocumentTraversal)((Object)elt.getOwnerDocument());
        TreeWalker tw = traversal.createTreeWalker((Node)elt, 1, nodeFilter, false);
        this.processUpdateTextElement(tw, dx, dy);
    }

    private void processUpdateTextElement(TreeWalker tw, float dx, float dy) {
        block8: {
            SVGLength length;
            int i;
            SVGLengthList lengthList;
            Node node;
            block9: {
                SVGLength length2;
                int i2;
                block7: {
                    SVGLength length3;
                    int i3;
                    node = tw.getCurrentNode();
                    Node child = tw.firstChild();
                    while (child != null) {
                        this.processUpdateTextElement(tw, dx, dy);
                        child = tw.nextSibling();
                    }
                    tw.setCurrentNode(node);
                    if (!(node instanceof SVGTextElement)) break block7;
                    SVGTextElement elt = (SVGTextElement)node;
                    lengthList = elt.getX().getBaseVal();
                    for (i3 = 0; i3 < lengthList.getNumberOfItems(); ++i3) {
                        length3 = lengthList.getItem(i3);
                        length3.setValue(length3.getValue() + dx);
                    }
                    lengthList = elt.getY().getBaseVal();
                    for (i3 = 0; i3 < lengthList.getNumberOfItems(); ++i3) {
                        length3 = lengthList.getItem(i3);
                        length3.setValue(length3.getValue() + dy);
                    }
                    break block8;
                }
                if (!(node instanceof SVGTSpanElement)) break block9;
                SVGTSpanElement elt = (SVGTSpanElement)node;
                lengthList = elt.getX().getBaseVal();
                for (i2 = 0; i2 < lengthList.getNumberOfItems(); ++i2) {
                    length2 = lengthList.getItem(i2);
                    length2.setValue(length2.getValue() + dx);
                }
                lengthList = elt.getY().getBaseVal();
                for (i2 = 0; i2 < lengthList.getNumberOfItems(); ++i2) {
                    length2 = lengthList.getItem(i2);
                    length2.setValue(length2.getValue() + dy);
                }
                break block8;
            }
            if (!(node instanceof SVGTRefElement)) break block8;
            SVGTRefElement elt = (SVGTRefElement)node;
            lengthList = elt.getX().getBaseVal();
            for (i = 0; i < lengthList.getNumberOfItems(); ++i) {
                length = lengthList.getItem(i);
                length.setValue(length.getValue() + dx);
            }
            lengthList = elt.getY().getBaseVal();
            for (i = 0; i < lengthList.getNumberOfItems(); ++i) {
                length = lengthList.getItem(i);
                length.setValue(length.getValue() + dy);
            }
        }
    }

    private void prepareMove() {
        this.outlineList.clear();
        this.newOutlineList.clear();
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        CanvasModel model = this.canvas.getModel();
        this.selectionList = CanvasUtilities.getGraphicsElement(this.canvas.getCanvasSelection().getSelectionList());
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGElement elt = this.selectionList.get(i);
            GraphicsNode gn = model.getGraphicsNode(elt);
            if (gn == null) continue;
            Shape shape = gn.getOutline();
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(gn.getGlobalTransform());
            shape = at.createTransformedShape(shape);
            this.outlineList.add(shape);
        }
        this.bounds = GeomUtilities.getBounds2D(this.outlineList);
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.canvas.repaint();
    }

    private void doOutlineMove() {
        this.updateOutline();
        Rectangle2D newBounds = GeomUtilities.getBounds2D(this.newOutlineList);
        Rectangle2D.union(this.bounds, newBounds, this.bounds);
        Rectangle r = this.bounds.getBounds();
        this.canvas.repaint(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        this.bounds = newBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMove() {
        this.outlineList.clear();
        this.newOutlineList.clear();
        if (!this.selectionList.isEmpty()) {
            Cursor prevCursor = this.canvas.getCursor();
            this.canvas.setCursor(Cursor.getPredefinedCursor(3));
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Move");
            try {
                this.updateDOM();
                this.canvas.refresh();
            }
            finally {
                undoManager.end();
                this.selectionList.clear();
                this.canvas.setCursor(prevCursor);
            }
        }
        this.canvas.getCanvasSelection().setEnabledVisible(true, true, true);
        this.canvas.setTool(this.canvas.getPreviousTool());
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        this.tx = 0;
        this.ty = 0;
        this.prepareMove();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        this.tx = evt.getX() - this.startX;
        this.ty = evt.getY() - this.startY;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            Rectangle2D selectionBounds = this.canvas.getCanvasSelection().getSelectionBounds2D();
            int distanceX = (int)Math.round(selectionBounds.getX() % (double)gridSize);
            int distanceY = (int)Math.round(selectionBounds.getY() % (double)gridSize);
            this.tx = Math.round(this.tx / gridSize) * gridSize - distanceX;
            this.ty = Math.round(this.ty / gridSize) * gridSize - distanceY;
        }
        this.doOutlineMove();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.doMove();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        this.keyRelease = false;
        this.keyTimer.stop();
        if (!this.keyRepeat) {
            this.keyRepeat = true;
            this.tx = 0;
            this.ty = 0;
            this.prepareMove();
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        int keyCode = evt.getKeyCode();
        int inc = 1;
        if (evt.isShiftDown()) {
            inc = 10;
        }
        switch (keyCode) {
            case 37: {
                this.tx -= inc;
                break;
            }
            case 39: {
                this.tx += inc;
                break;
            }
            case 38: {
                this.ty -= inc;
                break;
            }
            case 40: {
                this.ty += inc;
                break;
            }
            default: {
                this.keyRepeat = false;
                return;
            }
        }
        this.doOutlineMove();
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (!this.keyRelease) {
            this.keyReleaseEvent = evt;
            this.keyTimer.restart();
        }
        if (!this.keyRelease) {
            return;
        }
        int keyCode = evt.getKeyCode();
        switch (keyCode) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.doMove();
                break;
            }
            default: {
                this.keyRepeat = false;
                return;
            }
        }
    }
}

