/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.text;

import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.text.BadLocationException;
import kiyut.sketsa.canvas.event.TextEvent;
import kiyut.sketsa.canvas.text.TextDocument;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DOMUtilities;
import org.apache.batik.gvt.TextNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.svg.SVGTSpanElement;
import org.w3c.dom.svg.SVGTextElement;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class DefaultTextDocument
extends TextDocument {
    private void normalizeNode(Node aNode) {
        DocumentTraversal traversal = (DocumentTraversal)((Object)aNode.getOwnerDocument());
        NodeIterator iter = traversal.createNodeIterator(aNode, 4, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            if (node instanceof Text) {
                Text textNode = (Text)node;
                Node prevSibling = node.getPreviousSibling();
                if (prevSibling != null && prevSibling.getNodeType() == 3 && prevSibling.getParentNode().equals(textNode.getParentNode())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(prevSibling.getNodeValue().trim());
                    sb.append(textNode.getNodeValue().trim());
                    textNode.replaceData(0, textNode.getLength(), sb.toString());
                    Node parentNode = prevSibling.getParentNode();
                    if (parentNode != null) {
                        parentNode.removeChild(prevSibling);
                    }
                }
            }
            node = iter.nextNode();
        }
    }

    private void removeEmptyNode(Node node) {
        for (Node parentNode = node.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            if (this.element.equals(parentNode)) {
                parentNode.removeChild(node);
                break;
            }
            node = parentNode;
        }
    }

    protected Text getTextNode(AttributedCharacterIterator aci, int offset) throws BadLocationException {
        Text text = null;
        if (offset > aci.getEndIndex()) {
            throw new BadLocationException("offset > endIndex", offset);
        }
        aci.setIndex(offset);
        Node node = null;
        try {
            node = (Node)((SoftReference)aci.getAttribute(TEXT_COMPOUND_ID)).get();
        }
        catch (Exception ex) {
            return text;
        }
        int runStart = aci.getRunStart(TEXT_COMPOUND_ID);
        if (!this.element.equals(node)) {
            if (node != null) {
                text = (Text)node.getFirstChild();
            }
        } else if (runStart > 0) {
            aci.setIndex(runStart - 1);
            Node prevNode = (Node)((SoftReference)aci.getAttribute(TEXT_COMPOUND_ID)).get();
            node = prevNode.getNextSibling();
            if (node instanceof Text) {
                text = (Text)node;
            }
        } else {
            text = (Text)node.getFirstChild();
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offset, String str) throws BadLocationException {
        TextNode textNode = (TextNode)this.canvas.getModel().getGraphicsNode((SVGElement)this.element);
        AttributedCharacterIterator aci = textNode.getAttributedCharacterIterator();
        if (offset > aci.getEndIndex()) {
            throw new BadLocationException(str, offset);
        }
        if (offset == aci.getEndIndex()) {
            aci.setIndex(offset - 1);
        } else {
            aci.setIndex(offset);
        }
        int runStart = aci.getRunStart(TEXT_COMPOUND_ID);
        int runLimit = aci.getRunLimit(TEXT_COMPOUND_ID);
        int endIndex = aci.getEndIndex();
        StringBuilder sb = new StringBuilder();
        for (int i = runStart; i < runLimit; ++i) {
            sb.append(aci.setIndex(i));
        }
        Text text = null;
        text = offset == endIndex ? this.getTextNode(aci, offset - 1) : this.getTextNode(aci, offset);
        if (text == null) {
            throw new BadLocationException(str, offset);
        }
        sb.insert(offset - runStart, str);
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Insert Text");
        try {
            Element parent = (Element)text.getParentNode();
            if (!parent.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space").equals("preserve")) {
                parent.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
            }
            text.replaceData(0, text.getLength(), sb.toString());
            this.normalizeNode((Node)this.element);
        }
        finally {
            undoManager.end();
        }
        TextEvent evt = new TextEvent(offset, str.length(), 1);
        this.fireInsertUpdate(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offset, int len) throws BadLocationException {
        int runStart;
        int runLimit;
        int index;
        TextNode textNode = (TextNode)this.canvas.getModel().getGraphicsNode((SVGElement)this.element);
        AttributedCharacterIterator aci = textNode.getAttributedCharacterIterator();
        if (offset + len > aci.getEndIndex()) {
            throw new BadLocationException("offset + len > " + aci.getEndIndex(), offset);
        }
        if (len == 0) {
            return;
        }
        ArrayList<Text> nodeList = new ArrayList<Text>();
        int n = index = offset < aci.getEndIndex() ? offset : offset - 1;
        for (int remaining = len; remaining >= 0; remaining -= runLimit - index) {
            aci.setIndex(index);
            Node node = (Node)((SoftReference)aci.getAttribute(TEXT_COMPOUND_ID)).get();
            runStart = aci.getRunStart(TEXT_COMPOUND_ID);
            runLimit = aci.getRunLimit(TEXT_COMPOUND_ID);
            nodeList.add(this.getTextNode(aci, index));
            index = runLimit + 1;
            if (index < aci.getEndIndex()) continue;
            break;
        }
        StringBuilder sbStart = new StringBuilder();
        aci.setIndex(offset);
        runStart = aci.getRunStart(TEXT_COMPOUND_ID);
        runLimit = aci.getRunLimit(TEXT_COMPOUND_ID);
        for (int i = runStart; i < offset; ++i) {
            sbStart.append(aci.setIndex(i));
        }
        StringBuilder sbEnd = new StringBuilder();
        aci.setIndex(offset + len);
        runStart = aci.getRunStart(TEXT_COMPOUND_ID);
        runLimit = aci.getRunLimit(TEXT_COMPOUND_ID);
        for (int i = offset + len; i < runLimit; ++i) {
            sbEnd.append(aci.setIndex(i));
        }
        Text startText = this.getTextNode(aci, offset);
        Text endText = this.getTextNode(aci, offset + len);
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Remove Text");
        try {
            block20: {
                block21: {
                    block22: {
                        block19: {
                            if (nodeList.size() != 1) break block19;
                            startText.replaceData(0, startText.getLength(), sbStart.toString() + sbEnd.toString());
                            if (sbStart.length() + sbEnd.length() <= 0) {
                                this.removeEmptyNode(startText);
                            }
                            break block20;
                        }
                        if (nodeList.size() != 2) break block21;
                        if (sbStart.length() <= 0) {
                            this.removeEmptyNode(startText);
                        } else {
                            startText.replaceData(0, startText.getLength(), sbStart.toString());
                        }
                        if (sbEnd.length() > 0) break block22;
                        this.removeEmptyNode(startText);
                        break block20;
                    }
                    if (endText == null) break block20;
                    endText.replaceData(0, endText.getLength(), sbEnd.toString());
                    break block20;
                }
                if (nodeList.size() > 2) {
                    if (sbStart.length() <= 0) {
                        this.removeEmptyNode(startText);
                    } else {
                        startText.replaceData(0, startText.getLength(), sbStart.toString());
                    }
                    nodeList.remove(0);
                    if (sbEnd.length() <= 0) {
                        this.removeEmptyNode(startText);
                    } else {
                        endText.replaceData(0, endText.getLength(), sbEnd.toString());
                    }
                    nodeList.remove(nodeList.size() - 1);
                    while (nodeList.size() > 0) {
                        Node node = (Node)nodeList.get(0);
                        nodeList.remove(0);
                        this.removeEmptyNode(node);
                    }
                }
            }
            this.normalizeNode((Node)this.element);
            SVGTextElement contentElement = this.element;
            if (contentElement.getNumberOfChars() <= 0) {
                Node parentNode = this.element.getParentNode();
                parentNode.removeChild((Node)this.element);
                this.element = null;
            }
        }
        finally {
            undoManager.end();
        }
        TextEvent evt = new TextEvent(offset, len, 2);
        this.fireRemoveUpdate(evt);
    }

    @Override
    public void replace(int offset, int len, String str) throws BadLocationException {
        this.remove(offset, len);
        this.insertString(offset, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertNewLine(int offset) throws BadLocationException {
        TextNode textNode = (TextNode)this.canvas.getModel().getGraphicsNode((SVGElement)this.element);
        AttributedCharacterIterator aci = textNode.getAttributedCharacterIterator();
        if (offset > aci.getEndIndex()) {
            throw new BadLocationException("", offset);
        }
        if (offset == aci.getEndIndex()) {
            aci.setIndex(offset - 1);
        } else {
            aci.setIndex(offset);
        }
        Node node = (Node)((SoftReference)aci.getAttribute(TEXT_COMPOUND_ID)).get();
        int runStart = aci.getRunStart(TEXT_COMPOUND_ID);
        int runLimit = aci.getRunLimit(TEXT_COMPOUND_ID);
        StringBuilder sb = new StringBuilder();
        for (int i = runStart; i < runLimit; ++i) {
            sb.append(aci.setIndex(i));
        }
        String split1 = sb.substring(0, offset - runStart);
        String split2 = sb.substring(offset - runStart);
        if (split2.length() == 0) {
            split2 = " ";
        }
        SVGDocument doc = (SVGDocument)this.element.getOwnerDocument();
        Text newText = doc.createTextNode(split2);
        Element tspan = doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
        tspan.appendChild(newText);
        NamedNodeMap nodeMap = node.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Attr attr = (Attr)nodeMap.item(i);
            tspan.setAttributeNode((Attr)attr.cloneNode(true));
        }
        tspan.removeAttributeNS(null, "id");
        tspan.removeAttributeNS(null, "x");
        tspan.removeAttributeNS(null, "y");
        tspan.removeAttributeNS(null, "dx");
        tspan.removeAttributeNS(null, "dy");
        float x = this.element.getX().getBaseVal().getItem(0).getValue();
        ViewCSS viewCSS = (ViewCSS)((Object)this.element.getOwnerDocument().getDocumentElement());
        CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle((Element)this.element, null);
        String valueStr = computedStyle.getPropertyValue("font-size");
        SVGLength svgLength = this.element.getOwnerSVGElement().createSVGLength();
        svgLength.setValueAsString(valueStr);
        svgLength.convertToSpecifiedUnits((short)1);
        float dy = svgLength.getValue();
        if (dy <= 0.0f) {
            dy = 12.0f;
        }
        tspan.setAttributeNS(null, "x", Float.toString(x));
        tspan.setAttributeNS(null, "dy", Float.toString(dy));
        Text text = null;
        text = offset == runLimit ? this.getTextNode(aci, offset - 1) : this.getTextNode(aci, offset);
        if (text == null) {
            throw new BadLocationException("", offset);
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Insert Text");
        try {
            text.replaceData(0, text.getLength(), split1);
            Node nextSibling = text.getNextSibling();
            if (!text.getParentNode().equals(this.element)) {
                nextSibling = text.getParentNode().getNextSibling();
            }
            if (nextSibling != null) {
                this.element.insertBefore((Node)tspan, nextSibling);
            } else {
                this.element.appendChild((Node)tspan);
            }
            this.normalizeNode((Node)this.element);
        }
        finally {
            undoManager.end();
        }
        TextEvent evt = new TextEvent(offset, 1, 1);
        this.fireInsertUpdate(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterAttributes(int offset, int length, Map<String, String> attrMap) throws BadLocationException {
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Text Attribute");
        try {
            this.setCharacterAttributesImpl(offset, length, attrMap);
        }
        finally {
            undoManager.end();
        }
        TextEvent evt = new TextEvent(offset, length, 0);
        this.fireChangedUpdate(evt);
    }

    protected void setCharacterAttributesImpl(int offset, int length, Map<String, String> attrMap) throws BadLocationException {
        int runLimit;
        TextNode textNode = (TextNode)this.canvas.getModel().getGraphicsNode((SVGElement)this.element);
        AttributedCharacterIterator aci = textNode.getAttributedCharacterIterator();
        int len = length;
        int start = offset;
        if (offset + len > aci.getEndIndex()) {
            throw new BadLocationException("offset + len > " + aci.getEndIndex(), offset);
        }
        for (int remain = len; remain > 0; remain -= runLimit - start) {
            aci.setIndex(start);
            int runStart = aci.getRunStart(TEXT_COMPOUND_ID);
            runLimit = aci.getRunLimit(TEXT_COMPOUND_ID);
            int endIndex = aci.getEndIndex();
            Node node = (Node)((SoftReference)aci.getAttribute(TEXT_COMPOUND_ID)).get();
            if (start == runStart && start + remain >= runLimit) {
                SVGStylable stylable = (SVGStylable)node;
                for (String key : attrMap.keySet()) {
                    DOMUtilities.updateProperty(stylable, null, key, attrMap.get(key));
                }
            } else {
                Attr attr;
                NamedNodeMap nodeMap;
                StringBuilder sb = new StringBuilder();
                for (int i = runStart; i < runLimit; ++i) {
                    sb.append(aci.setIndex(i));
                }
                int end = Math.min(start + remain, runLimit);
                if (end == endIndex) {
                    end = endIndex - 1;
                }
                String split1 = sb.substring(0, start - runStart);
                String split2 = sb.substring(start - runStart, end - runStart);
                String split3 = sb.substring(end - runStart);
                if (split2.length() == 0) {
                    split2 = null;
                }
                if (split3.length() == 0) {
                    split3 = null;
                }
                Text text = null;
                text = start == runLimit ? this.getTextNode(aci, start - 1) : this.getTextNode(aci, start);
                SVGTSpanElement tspan2 = null;
                SVGTSpanElement tspan3 = null;
                SVGDocument doc = (SVGDocument)this.element.getOwnerDocument();
                if (split2 != null) {
                    tspan2 = (SVGTSpanElement)doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
                    tspan2.appendChild((Node)doc.createTextNode(split2));
                    nodeMap = text.getParentNode().getAttributes();
                    for (int i = 0; i < nodeMap.getLength(); ++i) {
                        attr = (Attr)nodeMap.item(i);
                        tspan2.setAttributeNode((Attr)attr.cloneNode(true));
                    }
                    tspan2.removeAttributeNS(null, "id");
                    tspan2.removeAttributeNS(null, "x");
                    tspan2.removeAttributeNS(null, "y");
                    tspan2.removeAttributeNS(null, "dx");
                    tspan2.removeAttributeNS(null, "dy");
                    for (String key : attrMap.keySet()) {
                        DOMUtilities.updateProperty((SVGStylable)tspan2, null, key, attrMap.get(key));
                    }
                }
                if (split3 != null) {
                    tspan3 = (SVGTSpanElement)doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
                    tspan3.appendChild((Node)doc.createTextNode(split3));
                    nodeMap = text.getParentNode().getAttributes();
                    for (int i = 0; i < nodeMap.getLength(); ++i) {
                        attr = (Attr)nodeMap.item(i);
                        tspan3.setAttributeNode((Attr)attr.cloneNode(true));
                    }
                    tspan3.removeAttributeNS(null, "id");
                    tspan3.removeAttributeNS(null, "x");
                    tspan3.removeAttributeNS(null, "y");
                    tspan3.removeAttributeNS(null, "dx");
                    tspan3.removeAttributeNS(null, "dy");
                }
                Node nextSibling = text.getNextSibling();
                if (!text.getParentNode().equals(this.element)) {
                    nextSibling = text.getParentNode().getNextSibling();
                }
                if (nextSibling != null) {
                    if (tspan2 != null) {
                        this.element.insertBefore((Node)tspan2, nextSibling);
                    }
                    if (tspan3 != null) {
                        this.element.insertBefore((Node)tspan3, nextSibling);
                    }
                } else {
                    if (tspan2 != null) {
                        this.element.appendChild((Node)tspan2);
                    }
                    if (tspan3 != null) {
                        this.element.appendChild((Node)tspan3);
                    }
                }
                if (split1.length() <= 0) {
                    this.removeEmptyNode(text);
                } else {
                    text.replaceData(0, text.getLength(), split1);
                }
            }
            start = runLimit;
        }
        this.normalizeNode((Node)this.element);
        this.cleanUpTextElement();
    }

    private void cleanUpTextElement() {
        Node node = this.element.getFirstChild();
        Node sibling = null;
        while (node != null) {
            int i;
            sibling = node.getNextSibling();
            if (sibling == null) {
                node = null;
                break;
            }
            boolean same = true;
            if (!(node instanceof SVGTSpanElement) || !(sibling instanceof SVGTSpanElement)) {
                same = false;
            }
            if (same) {
                CSSStyleDeclaration cssStyle1 = ((SVGTSpanElement)node).getStyle();
                CSSStyleDeclaration cssStyle2 = ((SVGTSpanElement)sibling).getStyle();
                if (cssStyle1.getLength() != cssStyle2.getLength()) {
                    same = false;
                }
                if (same) {
                    for (i = 0; i < cssStyle1.getLength(); ++i) {
                        String property = cssStyle1.item(i);
                        if (cssStyle1.getPropertyValue(property).equals(cssStyle2.getPropertyValue(property))) continue;
                        same = false;
                        break;
                    }
                }
            }
            NamedNodeMap nodeMap1 = null;
            NamedNodeMap nodeMap2 = null;
            nodeMap1 = node instanceof Text ? node.getParentNode().getAttributes() : node.getAttributes();
            nodeMap2 = sibling instanceof Text ? sibling.getParentNode().getAttributes() : sibling.getAttributes();
            if (nodeMap1.getLength() != nodeMap2.getLength()) {
                same = false;
            }
            if (same) {
                for (i = 0; i < nodeMap1.getLength(); ++i) {
                    Attr attr1 = (Attr)nodeMap1.item(i);
                    if (attr1.getNodeName().equalsIgnoreCase("style")) continue;
                    Attr attr2 = (Attr)nodeMap2.getNamedItemNS(attr1.getNamespaceURI(), attr1.getNodeName());
                    if (attr2 == null) {
                        same = false;
                        break;
                    }
                    if (attr2.getNodeName().equalsIgnoreCase("dy") || attr2.getNodeName().equalsIgnoreCase("dx")) {
                        same = false;
                        break;
                    }
                    if (attr1.getNodeValue().equals(attr2.getNodeValue())) continue;
                    same = false;
                    break;
                }
            }
            if (same && node.getFirstChild() instanceof Text && sibling.getFirstChild() instanceof Text) {
                Text text1 = (Text)node.getFirstChild();
                Text text2 = (Text)sibling.getFirstChild();
                text2.insertData(0, text1.getData());
                Node parent = node.getParentNode();
                parent.removeChild(node);
            }
            node = sibling;
        }
    }
}

