/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import kiyut.sketsa.actions.AbstractEditorAction;
import kiyut.sketsa.canvas.VectorCanvas;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ZoomAction
extends AbstractEditorAction {
    protected JMenuItem menuPresenter;

    public void performAction() {
    }

    public String getName() {
        return NbBundle.getMessage(ZoomAction.class, (String)"CTL_ZoomAction");
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        if (this.menuPresenter != null) {
            this.menuPresenter.setEnabled(value);
        }
    }

    public JMenuItem getMenuPresenter() {
        if (this.menuPresenter == null) {
            this.menuPresenter = new ZoomMenu(this.getName());
            this.menuPresenter.setEnabled(false);
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)this.getName());
        }
        return this.menuPresenter;
    }

    public class ZoomItemAction
    extends AbstractAction {
        private double zoomFactor;

        public ZoomItemAction(double zoomFactor, String name) {
            this.zoomFactor = zoomFactor;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ZoomAction.this.editorCookie == null) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VectorCanvas canvas = ZoomAction.this.editorCookie.getVectorCanvas();
                    try {
                        canvas.setZoomFactor(ZoomItemAction.this.zoomFactor);
                        canvas.setTool(canvas.getTool());
                    }
                    catch (Exception ex) {
                        Logger logger = Logger.getLogger(this.getClass().getName());
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    class ZoomMenu
    extends JMenu
    implements DynamicMenuContent {
        public ZoomMenu(String s) {
            super(s);
            this.updateMenu();
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        private void updateMenu() {
            this.removeAll();
            this.addItem(9.0, "9:1 (900%)");
            this.addItem(8.0, "8:1 (800%)");
            this.addItem(6.0, "6:1 (600%)");
            this.addItem(4.0, "4:1 (400%)");
            this.addItem(3.0, "3:1 (300%)");
            this.addItem(2.0, "2:1 (200%)");
            this.addItem(1.0, "1:1 (100%)");
            this.addItem(0.5, "1:2 (50%)");
            this.addItem(0.3333, "1:3 (33.3%)");
            this.addItem(0.25, "1:4 (25%)");
            this.addItem(0.1667, "1:6 (16.7%)");
            this.addItem(0.125, "1:8 (12.5%)");
            this.addItem(0.0625, "1:16 (6.25%)");
            this.addItem(0.0444, "1:22 (4.44%)");
        }

        private void addItem(double zoomFactor, String name) {
            ZoomItemAction action = new ZoomItemAction(zoomFactor, name);
            JMenuItem menuItem = new JMenuItem(action);
            this.add(menuItem);
        }
    }
}

