/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import java.awt.BorderLayout;
import java.awt.Image;
import javax.swing.JFrame;
import kiyut.sketsa.Application;
import kiyut.sketsa.actions.AbstractEditorAction;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.tool.PreviewPane;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.swing.util.WindowUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class PreviewAction
extends AbstractEditorAction {
    public void performAction() {
        if (this.editorCookie == null) {
            return;
        }
        VectorCanvas canvas = this.editorCookie.getVectorCanvas();
        Image image = WindowManager.getDefault().getMainWindow().getIconImage();
        PreviewPane previewPane = new PreviewPane();
        JFrame frame = new JFrame(NbBundle.getMessage(PreviewAction.class, (String)"CTL_PreviewTitle.Text") + " - " + Application.getFullName());
        frame.setIconImage(image);
        frame.setDefaultCloseOperation(2);
        frame.setLayout(new BorderLayout());
        frame.add("Center", previewPane);
        frame.setVisible(true);
        frame.pack();
        WindowUtilities.centerWindow(frame);
        SVGDocument copyDoc = (SVGDocument)DOMUtilities.deepCloneDocument((Document)canvas.getSVGDocument());
        previewPane.setSVGDocument(copyDoc);
    }

    public String getName() {
        return NbBundle.getMessage(PreviewAction.class, (String)"CTL_PreviewAction");
    }

    protected String iconResource() {
        return NbBundle.getMessage(PreviewAction.class, (String)"ICON_PreviewAction");
    }
}

