/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import kiyut.sketsa.loaders.SVGDataObject;
import kiyut.sketsa.tool.NewDocumentPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.w3c.dom.svg.SVGDocument;

public final class NewAction
extends CallableSystemAction {
    private static int counter = 1;

    public void performAction() {
        NotifyDescriptor.Message nd;
        SVGDocument doc = null;
        NewDocumentPane newDocPane = new NewDocumentPane();
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)newDocPane, newDocPane.getTitle());
        dialogDesc.setModal(true);
        DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
        boolean valid = false;
        while (!valid) {
            Object choice = dialogDisplayer.notify((NotifyDescriptor)dialogDesc);
            if (choice.equals(DialogDescriptor.OK_OPTION)) {
                try {
                    newDocPane.validateValue();
                    doc = newDocPane.createSVGDocument();
                    valid = true;
                }
                catch (Exception ex) {
                    nd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                continue;
            }
            valid = true;
        }
        if (doc == null) {
            return;
        }
        String name = NbBundle.getMessage(NewAction.class, (String)"MSG_NewDocumentName.Text", (Object[])new Object[]{new Integer(counter++)});
        try {
            FileSystem fs = FileUtil.createMemoryFileSystem();
            FileObject fob = fs.getRoot().createData(name, "svg");
            DataObject data = DataObject.find((FileObject)fob);
            ((SVGDataObject)data).setSVGDocument(doc, false);
            OpenCookie cookie = (OpenCookie)data.getCookie(OpenCookie.class);
            cookie.open();
        }
        catch (Exception ex) {
            nd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
    }

    public String getName() {
        return NbBundle.getMessage(NewAction.class, (String)"CTL_NewAction");
    }

    protected String iconResource() {
        return NbBundle.getMessage(NewAction.class, (String)"ICON_NewAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

