/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import java.awt.EventQueue;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import kiyut.sketsa.actions.AbstractEditorAction;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;

public class FlipHorizontalAction
extends AbstractEditorAction {
    public void performAction() {
        if (this.editorCookie == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VectorCanvas canvas = FlipHorizontalAction.this.editorCookie.getVectorCanvas();
                List<SVGElement> selectionList = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
                if (selectionList.isEmpty()) {
                    String msg = NbBundle.getMessage(FlipHorizontalAction.class, (String)"MSG_SelectionEmpty.Text");
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                Rectangle2D rect = canvas.getCanvasSelection().getSelectionBounds2D();
                if (rect == null) {
                    return;
                }
                Point2D.Double p = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
                AffineTransform at = canvas.getTransform(true);
                try {
                    at = at.createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
                at.transform(p, p);
                CanvasModel model = canvas.getModel();
                SVGMatrix matrix1 = model.getSVGSVGElement().createSVGMatrix().translate((float)((Point2D)p).getX(), (float)((Point2D)p).getY());
                SVGMatrix matrix2 = model.getSVGSVGElement().createSVGMatrix();
                SVGMatrix matrix3 = model.getSVGSVGElement().createSVGMatrix().translate((float)(-((Point2D)p).getX()), (float)(-((Point2D)p).getY()));
                matrix2 = matrix2.flipX();
                DOMUndoManager undoManager = canvas.getUndoManager();
                undoManager.start("Transform Flip Horizontal");
                try {
                    for (int i = 0; i < selectionList.size(); ++i) {
                        SVGElement element = selectionList.get(i);
                        if (!(element instanceof SVGTransformable)) continue;
                        SVGTransform transform1 = model.getSVGSVGElement().createSVGTransformFromMatrix(matrix1);
                        SVGTransform transform2 = model.getSVGSVGElement().createSVGTransformFromMatrix(matrix2);
                        SVGTransform transform3 = model.getSVGSVGElement().createSVGTransformFromMatrix(matrix3);
                        SVGTransformList transformList = ((SVGTransformable)element).getTransform().getBaseVal();
                        transformList.consolidate();
                        transformList.insertItemBefore(transform1, 0);
                        transformList.insertItemBefore(transform2, 1);
                        transformList.insertItemBefore(transform3, 2);
                        transformList.consolidate();
                    }
                }
                catch (Exception ex) {
                    undoManager.cancel();
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
                finally {
                    undoManager.end();
                    canvas.refresh();
                }
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(FlipHorizontalAction.class, (String)"CTL_FlipHorizontalAction");
    }
}

