/*
 * Decompiled with CFR 0.152.
 */
package org.nbs.java.ayatana;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.gtk.laf.extended.GTKLookAndFeelExtended;
import org.java.ayatana.ApplicationMenu;
import org.java.ayatana.AyatanaDesktop;
import org.java.ayatana.DesktopFile;
import org.nbs.java.ayatana.NbsExtraMenuAction;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    public void restored() {
        if (UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) {
            try {
                GTKLookAndFeelExtended.applayGTKLookAndFeelExtended();
            }
            catch (Throwable e) {
                Logger.getLogger(Installer.class.getName()).log(Level.INFO, "Error on GTK Look And Feel Extended", e);
            }
        }
        if (!"false".equals(System.getProperty("netbeans.jayatana.desktopfile")) && AyatanaDesktop.isSupported()) {
            try {
                String iconName;
                String desktopFileId = System.getProperty("netbeans.jayatana.desktopfile.id");
                if (desktopFileId == null) {
                    String productVersion = System.getProperty("netbeans.productversion", "Netbeans IDE 7.1.2");
                    desktopFileId = "netbeans-" + productVersion.split(" +")[2];
                }
                if ((iconName = System.getProperty("netbeans.jayatana.desktopfile.icon")) == null) {
                    AyatanaDesktop.tryInstallIcon("netbeans", Installer.class.getResource("/org/nbs/java/ayatana/netbeans.png"));
                    iconName = "netbeans";
                }
                if (!new File(System.getProperty("user.home"), ".local/share/applications/" + desktopFileId + ".desktop").exists()) {
                    desktopFileId = "netbeans";
                }
                DesktopFile desktopFile = DesktopFile.initialize(desktopFileId, desktopFileId);
                desktopFile.setIcon(iconName);
                if (System.getProperty("netbeans.jayatana.desktopfile.name") != null) {
                    desktopFile.setName(System.getProperty("netbeans.jayatana.desktopfile.name"));
                }
                if (System.getProperty("netbeans.jayatana.desktopfile.comment") != null) {
                    desktopFile.setComment(System.getProperty("netbeans.jayatana.desktopfile.comment"));
                }
                if (System.getProperty("netbeans.jayatana.desktopfile.categories") != null) {
                    desktopFile.setCategories(System.getProperty("netbeans.jayatana.desktopfile.categories").split(","));
                }
                if (System.getProperty("netbeans.jayatana.desktopfile.command") != null) {
                    desktopFile.setCommand(System.getProperty("netbeans.jayatana.desktopfile.command"));
                }
                desktopFile.update();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                        frame.addPropertyChangeListener("iconImage", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if (AyatanaDesktop.isSupported()) {
                                    DesktopFile.setStartupWMClassToToolKit();
                                }
                            }
                        });
                    }
                });
            }
            catch (IOException e) {
                Logger.getLogger(Installer.class.getName()).log(Level.WARNING, "Can't install desktop file", e);
            }
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                if (AyatanaDesktop.isSupported()) {
                    JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                    ApplicationMenu.tryInstall(frame, new NbsExtraMenuAction());
                }
            }
        });
    }
}

