/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Main;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Beta
public class HtmlReporter
extends Reporter {
    private static final boolean USE_HOLO_STYLE = true;
    private static final String CSS = "hololike.css";
    private static final int SPLIT_LIMIT = 8;
    private static final int SHOWN_COUNT = 5;
    protected final Writer mWriter;
    private String mStripPrefix;
    private String mFixUrl;

    public HtmlReporter(LintCliClient client, File output) throws IOException {
        super(client, output);
        this.mWriter = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
    }

    @Override
    public void write(int errorCount, int warningCount, List<Warning> issues) throws IOException {
        Map<Issue, String> missing = this.computeMissingIssues(issues);
        this.mWriter.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" /><title>" + this.mTitle + "</title>\n");
        this.writeStyleSheet();
        if (!this.mSimpleFormat) {
            this.mWriter.write("<script language=\"javascript\" type=\"text/javascript\"> \n<!--\nfunction reveal(id) {\nif (document.getElementById) {\ndocument.getElementById(id).style.display = 'block';\ndocument.getElementById(id+'Link').style.display = 'none';\n}\n}\n//--> \n</script>\n");
        }
        this.mWriter.write("</head>\n<body>\n<h1>" + this.mTitle + "</h1>\n" + "<div class=\"titleSeparator\"></div>\n");
        this.mWriter.write(String.format("Check performed at %1$s.", new Date().toString()));
        this.mWriter.write("<br/>\n");
        this.mWriter.write(String.format("%1$d errors and %2$d warnings found:", errorCount, warningCount));
        this.mWriter.write("<br/><br/>\n");
        Issue previousIssue = null;
        if (!issues.isEmpty()) {
            ArrayList<List<Warning>> related = new ArrayList<List<Warning>>();
            ArrayList<Warning> currentList = null;
            for (Warning warning : issues) {
                if (warning.issue != previousIssue) {
                    previousIssue = warning.issue;
                    currentList = new ArrayList<Warning>();
                    related.add(currentList);
                }
                assert (currentList != null);
                currentList.add(warning);
            }
            this.writeOverview(related, missing.size());
            Category previousCategory = null;
            for (List list : related) {
                Warning first = (Warning)list.get(0);
                Issue issue = first.issue;
                if (issue.getCategory() != previousCategory) {
                    previousCategory = issue.getCategory();
                    this.mWriter.write("\n<a name=\"");
                    this.mWriter.write(issue.getCategory().getFullName());
                    this.mWriter.write("\"></a>\n");
                    this.mWriter.write("<div class=\"category\"><a href=\"#\" title=\"Return to top\">");
                    this.mWriter.write(issue.getCategory().getFullName());
                    this.mWriter.write("</a><div class=\"categorySeparator\"></div>\n");
                    this.mWriter.write("</div>\n");
                }
                this.mWriter.write("<a name=\"" + issue.getId() + "\"></a>\n");
                this.mWriter.write("<div class=\"issue\">\n");
                this.mWriter.write("<div class=\"id\"><a href=\"#\" title=\"Return to top\">");
                this.mWriter.write(issue.getId());
                this.mWriter.write(": ");
                this.mWriter.write(issue.getBriefDescription(TextFormat.HTML));
                this.mWriter.write("</a><div class=\"issueSeparator\"></div>\n");
                this.mWriter.write("</div>\n");
                this.mWriter.write("<div class=\"warningslist\">\n");
                boolean partialHide = !this.mSimpleFormat && list.size() > 8;
                int count = 0;
                for (Warning warning : list) {
                    if (partialHide && count == 5) {
                        String id = warning.issue.getId() + "Div";
                        this.mWriter.write("<button id=\"");
                        this.mWriter.write(id);
                        this.mWriter.write("Link\" onclick=\"reveal('");
                        this.mWriter.write(id);
                        this.mWriter.write("');\" />");
                        this.mWriter.write(String.format("+ %1$d More Occurrences...", list.size() - 5));
                        this.mWriter.write("</button>\n");
                        this.mWriter.write("<div id=\"");
                        this.mWriter.write(id);
                        this.mWriter.write("\" style=\"display: none\">\n");
                    }
                    ++count;
                    String url = null;
                    if (warning.path != null) {
                        url = this.writeLocation(warning.file, warning.path, warning.line);
                        this.mWriter.write(58);
                        this.mWriter.write(32);
                    }
                    boolean addedImage = false;
                    if (url != null && warning.location != null && warning.location.getSecondary() == null) {
                        addedImage = this.addImage(url, warning.location);
                    }
                    this.mWriter.write("<span class=\"message\">");
                    this.mWriter.append(TextFormat.RAW.convertTo(warning.message, TextFormat.HTML));
                    this.mWriter.write("</span>");
                    if (addedImage) {
                        this.mWriter.write("<br clear=\"right\"/>");
                    } else {
                        this.mWriter.write("<br />");
                    }
                    if (warning.line >= 0 && warning.fileContents != null) {
                        this.mWriter.write("<pre class=\"errorlines\">\n");
                        this.appendCodeBlock(warning.fileContents, warning.line, warning.offset);
                        this.mWriter.write("\n</pre>");
                    }
                    this.mWriter.write(10);
                    if (warning.location != null && warning.location.getSecondary() != null) {
                        String path;
                        int line;
                        Position start;
                        Location l;
                        this.mWriter.write("<ul>");
                        int otherLocations = 0;
                        for (l = warning.location.getSecondary(); l != null; l = l.getSecondary()) {
                            String message = l.getMessage();
                            if (message != null && !message.isEmpty()) {
                                String s;
                                start = l.getStart();
                                line = start != null ? start.getLine() : -1;
                                path = this.mClient.getDisplayPath(warning.project, l.getFile());
                                this.writeLocation(l.getFile(), path, line);
                                this.mWriter.write(58);
                                this.mWriter.write(32);
                                this.mWriter.write("<span class=\"message\">");
                                this.mWriter.append(TextFormat.RAW.convertTo(message, TextFormat.HTML));
                                this.mWriter.write("</span>");
                                this.mWriter.write("<br />");
                                String name = l.getFile().getName();
                                if (LintUtils.endsWith(name, ".png") || LintUtils.endsWith(name, ".jpg") || (s = this.mClient.readFile(l.getFile())) == null || s.isEmpty()) continue;
                                this.mWriter.write("<pre class=\"errorlines\">\n");
                                int offset = start != null ? start.getOffset() : -1;
                                this.appendCodeBlock(s, line, offset);
                                this.mWriter.write("\n</pre>");
                                continue;
                            }
                            ++otherLocations;
                        }
                        this.mWriter.write("</ul>");
                        if (otherLocations > 0) {
                            String id = "Location" + count + "Div";
                            this.mWriter.write("<button id=\"");
                            this.mWriter.write(id);
                            this.mWriter.write("Link\" onclick=\"reveal('");
                            this.mWriter.write(id);
                            this.mWriter.write("');\" />");
                            this.mWriter.write(String.format("+ %1$d Additional Locations...", otherLocations));
                            this.mWriter.write("</button>\n");
                            this.mWriter.write("<div id=\"");
                            this.mWriter.write(id);
                            this.mWriter.write("\" style=\"display: none\">\n");
                            this.mWriter.write("Additional locations: ");
                            this.mWriter.write("<ul>\n");
                            for (l = warning.location.getSecondary(); l != null; l = l.getSecondary()) {
                                start = l.getStart();
                                line = start != null ? start.getLine() : -1;
                                path = this.mClient.getDisplayPath(warning.project, l.getFile());
                                this.mWriter.write("<li> ");
                                this.writeLocation(l.getFile(), path, line);
                                this.mWriter.write("\n");
                            }
                            this.mWriter.write("</ul>\n");
                            this.mWriter.write("</div><br/><br/>\n");
                        }
                    }
                    if (!addedImage && url != null && warning.location != null && warning.location.getSecondary() != null) {
                        this.addImage(url, warning.location);
                    }
                    if (!warning.isVariantSpecific()) continue;
                    this.mWriter.write("\n");
                    this.mWriter.write("Applies to variants: ");
                    this.mWriter.write(Joiner.on((String)", ").join(warning.getIncludedVariantNames()));
                    this.mWriter.write("<br/>\n");
                    this.mWriter.write("Does <b>not</b> apply to variants: ");
                    this.mWriter.write(Joiner.on((String)", ").join(warning.getExcludedVariantNames()));
                    this.mWriter.write("<br/>\n");
                }
                if (partialHide) {
                    this.mWriter.write("</div>\n");
                }
                this.mWriter.write("</div>\n");
                this.writeIssueMetadata(issue, first.severity, null);
                this.mWriter.write("</div>\n");
            }
            if (!this.mClient.isCheckingSpecificIssues()) {
                this.writeMissingIssues(missing);
            }
            this.writeSuppressInfo();
        } else {
            this.mWriter.write("Congratulations!");
        }
        this.mWriter.write("\n</body>\n</html>");
        this.mWriter.close();
        if (!this.mClient.getFlags().isQuiet() && (this.mDisplayEmpty || errorCount > 0 || warningCount > 0)) {
            String url = SdkUtils.fileToUrlString((File)this.mOutput.getAbsoluteFile());
            System.out.println(String.format("Wrote HTML report to %1$s", url));
        }
    }

    private void writeIssueMetadata(Issue issue, Severity severity, String disabledBy) throws IOException {
        this.mWriter.write("<div class=\"metadata\">");
        if (this.mClient.getRegistry() instanceof BuiltinIssueRegistry) {
            boolean adtHasFix = Reporter.QuickfixHandler.ADT.hasAutoFix(issue);
            boolean studioHasFix = Reporter.QuickfixHandler.STUDIO.hasAutoFix(issue);
            if (adtHasFix || studioHasFix) {
                String adt = "Eclipse/ADT";
                String studio = "Android Studio/IntelliJ";
                String tools = adtHasFix && studioHasFix ? adt + " & " + studio : (studioHasFix ? studio : adt);
                this.mWriter.write("Note: This issue has an associated quickfix operation in " + tools);
                if (this.mFixUrl != null) {
                    this.mWriter.write("&nbsp;<img alt=\"Fix\" border=\"0\" align=\"top\" src=\"");
                    this.mWriter.write(this.mFixUrl);
                    this.mWriter.write("\" />\n");
                }
                this.mWriter.write("<br>\n");
            }
        }
        if (disabledBy != null) {
            this.mWriter.write(String.format("Disabled By: %1$s<br/>\n", disabledBy));
        }
        this.mWriter.write("Priority: ");
        this.mWriter.write(String.format("%1$d / 10", issue.getPriority()));
        this.mWriter.write("<br/>\n");
        this.mWriter.write("Category: ");
        this.mWriter.write(issue.getCategory().getFullName());
        this.mWriter.write("</div>\n");
        this.mWriter.write("Severity: ");
        if (severity == Severity.ERROR || severity == Severity.FATAL) {
            this.mWriter.write("<span class=\"error\">");
        } else if (severity == Severity.WARNING) {
            this.mWriter.write("<span class=\"warning\">");
        } else {
            this.mWriter.write("<span>");
        }
        this.appendEscapedText(severity.getDescription());
        this.mWriter.write("</span>");
        this.mWriter.write("<div class=\"summary\">\n");
        this.mWriter.write("Explanation: ");
        String description = issue.getBriefDescription(TextFormat.HTML);
        this.mWriter.write(description);
        if (!description.isEmpty() && Character.isLetter(description.charAt(description.length() - 1))) {
            this.mWriter.write(46);
        }
        this.mWriter.write("</div>\n");
        this.mWriter.write("<div class=\"explanation\">\n");
        String explanationHtml = issue.getExplanation(TextFormat.HTML);
        this.mWriter.write(explanationHtml);
        this.mWriter.write("\n</div>\n");
        List<String> moreInfo = issue.getMoreInfo();
        this.mWriter.write("<br/>");
        this.mWriter.write("<div class=\"moreinfo\">");
        this.mWriter.write("More info: ");
        int count = moreInfo.size();
        if (count > 1) {
            this.mWriter.write("<ul>");
        }
        for (String uri : moreInfo) {
            if (count > 1) {
                this.mWriter.write("<li>");
            }
            this.mWriter.write("<a href=\"");
            this.mWriter.write(uri);
            this.mWriter.write("\">");
            this.mWriter.write(uri);
            this.mWriter.write("</a>\n");
        }
        if (count > 1) {
            this.mWriter.write("</ul>");
        }
        this.mWriter.write("</div>");
        this.mWriter.write("<br/>");
        this.mWriter.write(String.format("To suppress this error, use the issue id \"%1$s\" as explained in the %2$sSuppressing Warnings and Errors%3$s section.", issue.getId(), "<a href=\"#SuppressInfo\">", "</a>"));
        this.mWriter.write("<br/>\n");
    }

    private void writeSuppressInfo() throws IOException {
        this.mWriter.write("\n<a name=\"SuppressInfo\"></a>\n");
        this.mWriter.write("<div class=\"category\">");
        this.mWriter.write("Suppressing Warnings and Errors");
        this.mWriter.write("<div class=\"categorySeparator\"></div>\n");
        this.mWriter.write("</div>\n");
        this.appendEscapedText(Main.getSuppressHelp());
        this.mWriter.write(10);
    }

    protected Map<Issue, String> computeMissingIssues(List<Warning> warnings) {
        HashSet<Project> projects = new HashSet<Project>();
        HashSet<Issue> seen = new HashSet<Issue>();
        for (Warning warning : warnings) {
            projects.add(warning.project);
            seen.add(warning.issue);
        }
        Configuration cliConfiguration = this.mClient.getConfiguration();
        HashMap map = Maps.newHashMap();
        block1: for (Issue issue : this.mClient.getRegistry().getIssues()) {
            if (seen.contains(issue)) continue;
            if (this.mClient.isSuppressed(issue)) {
                map.put(issue, "Command line flag");
                continue;
            }
            if (!issue.isEnabledByDefault() && !this.mClient.isAllEnabled()) {
                map.put(issue, "Default");
                continue;
            }
            if (cliConfiguration != null && !cliConfiguration.isEnabled(issue)) {
                map.put(issue, "Command line supplied --config lint.xml file");
                continue;
            }
            for (Project project : projects) {
                if (project.getConfiguration().isEnabled(issue)) continue;
                map.put(issue, "Project lint.xml file");
                continue block1;
            }
        }
        return map;
    }

    private void writeMissingIssues(Map<Issue, String> missing) throws IOException {
        this.mWriter.write("\n<a name=\"MissingIssues\"></a>\n");
        this.mWriter.write("<div class=\"category\">");
        this.mWriter.write("Disabled Checks");
        this.mWriter.write("<div class=\"categorySeparator\"></div>\n");
        this.mWriter.write("</div>\n");
        this.mWriter.write("The following issues were not run by lint, either because the check is not enabled by default, or because it was disabled with a command line flag or via one or more lint.xml configuration files in the project directories.");
        this.mWriter.write("\n<br/><br/>\n");
        ArrayList<Issue> list = new ArrayList<Issue>(missing.keySet());
        Collections.sort(list);
        for (Issue issue : list) {
            this.mWriter.write("<a name=\"" + issue.getId() + "\"></a>\n");
            this.mWriter.write("<div class=\"issue\">\n");
            this.mWriter.write("<div class=\"id\">");
            this.mWriter.write(issue.getId());
            this.mWriter.write("<div class=\"issueSeparator\"></div>\n");
            this.mWriter.write("</div>\n");
            String disabledBy = missing.get(issue);
            this.writeIssueMetadata(issue, issue.getDefaultSeverity(), disabledBy);
            this.mWriter.write("</div>\n");
        }
    }

    protected void writeStyleSheet() throws IOException {
        this.mWriter.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"http://fonts.googleapis.com/css?family=Roboto\" />\n");
        URL cssUrl = HtmlReporter.class.getResource(CSS);
        if (this.mSimpleFormat) {
            this.mWriter.write("<style>\n");
            InputStream input = cssUrl.openStream();
            byte[] bytes = ByteStreams.toByteArray((InputStream)input);
            try {
                Closeables.close((Closeable)input, (boolean)true);
            }
            catch (IOException e) {
                // empty catch block
            }
            String css = new String(bytes, Charsets.UTF_8);
            this.mWriter.write(css);
            this.mWriter.write("</style>\n");
        } else {
            String ref = this.addLocalResources(cssUrl);
            if (ref != null) {
                this.mWriter.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + ref + "\" />\n");
            }
        }
    }

    private void writeOverview(List<List<Warning>> related, int missingCount) throws IOException {
        this.mWriter.write("<table class=\"overview\">\n");
        String errorUrl = null;
        String warningUrl = null;
        if (!this.mSimpleFormat) {
            errorUrl = this.addLocalResources(HtmlReporter.getErrorIconUrl());
            warningUrl = this.addLocalResources(HtmlReporter.getWarningIconUrl());
            this.mFixUrl = this.addLocalResources(HtmlReporter.class.getResource("lint-run.png"));
        }
        Category previousCategory = null;
        for (List<Warning> warnings : related) {
            String imageUrl;
            Issue issue = warnings.get((int)0).issue;
            boolean isError = false;
            for (Warning warning : warnings) {
                if (warning.severity != Severity.ERROR && warning.severity != Severity.FATAL) continue;
                isError = true;
                break;
            }
            if (issue.getCategory() != previousCategory) {
                this.mWriter.write("<tr><td></td><td class=\"categoryColumn\">");
                previousCategory = issue.getCategory();
                String categoryName = issue.getCategory().getFullName();
                this.mWriter.write("<a href=\"#");
                this.mWriter.write(categoryName);
                this.mWriter.write("\">");
                this.mWriter.write(categoryName);
                this.mWriter.write("</a>\n");
                this.mWriter.write("</td></tr>");
                this.mWriter.write("\n");
            }
            this.mWriter.write("<tr>\n");
            this.mWriter.write("<td class=\"countColumn\">");
            this.mWriter.write(Integer.toString(warnings.size()));
            this.mWriter.write("</td>");
            this.mWriter.write("<td class=\"issueColumn\">");
            String string = imageUrl = isError ? errorUrl : warningUrl;
            if (imageUrl != null) {
                this.mWriter.write("<img border=\"0\" align=\"top\" src=\"");
                this.mWriter.write(imageUrl);
                this.mWriter.write("\" alt=\"");
                this.mWriter.write(isError ? "Error" : "Warning");
                this.mWriter.write("\" />\n");
            }
            this.mWriter.write("<a href=\"#");
            this.mWriter.write(issue.getId());
            this.mWriter.write("\">");
            this.mWriter.write(issue.getId());
            this.mWriter.write(": ");
            this.mWriter.write(issue.getBriefDescription(TextFormat.HTML));
            this.mWriter.write("</a>\n");
            this.mWriter.write("</td></tr>\n");
        }
        if (missingCount > 0 && !this.mClient.isCheckingSpecificIssues()) {
            this.mWriter.write("<tr><td></td>");
            this.mWriter.write("<td class=\"categoryColumn\">");
            this.mWriter.write("<a href=\"#MissingIssues\">");
            this.mWriter.write(String.format("Disabled Checks (%1$d)", missingCount));
            this.mWriter.write("</a>\n");
            this.mWriter.write("</td></tr>");
        }
        this.mWriter.write("</table>\n");
        this.mWriter.write("<br/>");
    }

    private String writeLocation(File file, String path, int line) throws IOException {
        this.mWriter.write("<span class=\"location\">");
        String url = this.getUrl(file);
        if (url != null) {
            this.mWriter.write("<a href=\"");
            this.mWriter.write(url);
            this.mWriter.write("\">");
        }
        String displayPath = this.stripPath(path);
        if (url != null && url.startsWith("../") && new File(displayPath).isAbsolute()) {
            displayPath = url;
        }
        this.mWriter.write(displayPath);
        if (url != null) {
            this.mWriter.write("</a>");
        }
        if (line >= 0) {
            this.mWriter.write(58);
            this.mWriter.write(Integer.toString(line + 1));
        }
        this.mWriter.write("</span>");
        return url;
    }

    private boolean addImage(String url, Location location) throws IOException {
        if (url != null && LintUtils.endsWith(url, ".png")) {
            if (location.getSecondary() != null) {
                ArrayList<String> urls = new ArrayList<String>();
                while (location != null && location.getFile() != null) {
                    String imageUrl = this.getUrl(location.getFile());
                    if (imageUrl != null && LintUtils.endsWith(imageUrl, ".png")) {
                        urls.add(imageUrl);
                    }
                    location = location.getSecondary();
                }
                if (!urls.isEmpty()) {
                    Collections.sort(urls, new Comparator<String>(){

                        @Override
                        public int compare(String s1, String s2) {
                            return HtmlReporter.getDpiRank(s1) - HtmlReporter.getDpiRank(s2);
                        }
                    });
                    this.mWriter.write("<table>");
                    this.mWriter.write("<tr>");
                    for (String linkedUrl : urls) {
                        this.mWriter.write("<td>");
                        this.mWriter.write("<a href=\"");
                        this.mWriter.write(linkedUrl);
                        this.mWriter.write("\">");
                        this.mWriter.write("<img border=\"0\" align=\"top\" src=\"");
                        this.mWriter.write(linkedUrl);
                        this.mWriter.write("\" /></a>\n");
                        this.mWriter.write("</td>");
                    }
                    this.mWriter.write("</tr>");
                    this.mWriter.write("<tr>");
                    for (String linkedUrl : urls) {
                        int end;
                        this.mWriter.write("<th>");
                        int index = linkedUrl.lastIndexOf("drawable-");
                        if (index != -1 && (end = linkedUrl.indexOf(47, index += "drawable-".length())) != -1) {
                            this.mWriter.write(linkedUrl.substring(index, end));
                        }
                        this.mWriter.write("</th>");
                    }
                    this.mWriter.write("</tr>\n");
                    this.mWriter.write("</table>\n");
                }
            } else {
                this.mWriter.write("<img class=\"embedimage\" align=\"right\" src=\"");
                this.mWriter.write(url);
                this.mWriter.write("\" />");
            }
            return true;
        }
        return false;
    }

    private static int getDpiRank(String url) {
        if (url.contains("-xhdpi")) {
            return 0;
        }
        if (url.contains("-hdpi")) {
            return 1;
        }
        if (url.contains("-mdpi")) {
            return 2;
        }
        if (url.contains("-ldpi")) {
            return 3;
        }
        return 4;
    }

    private void appendCodeBlock(String contents, int lineno, int offset) throws IOException {
        int min;
        int max = lineno + 3;
        for (int l = min = lineno - 3; l < max; ++l) {
            if (l < 0) continue;
            int lineOffset = LintCliClient.getLineOffset(contents, l);
            if (lineOffset == -1) break;
            this.mWriter.write(String.format("<span class=\"lineno\">%1$4d</span> ", l + 1));
            String line = LintCliClient.getLineOfOffset(contents, lineOffset);
            if (offset != -1 && lineOffset <= offset && lineOffset + line.length() >= offset) {
                int delta = offset - lineOffset;
                this.appendEscapedText(line.substring(0, delta));
                this.mWriter.write("<span class=\"errorspan\">");
                this.appendEscapedText(line.substring(delta));
                this.mWriter.write("</span>");
            } else if (offset == -1 && l == lineno) {
                this.mWriter.write("<span class=\"errorline\">");
                this.appendEscapedText(line);
                this.mWriter.write("</span>");
            } else {
                this.appendEscapedText(line);
            }
            if (l >= max - 1) continue;
            this.mWriter.write("\n");
        }
    }

    protected void appendEscapedText(String textValue) throws IOException {
        int n = textValue.length();
        for (int i = 0; i < n; ++i) {
            char c = textValue.charAt(i);
            if (c == '<') {
                this.mWriter.write("&lt;");
                continue;
            }
            if (c == '&') {
                this.mWriter.write("&amp;");
                continue;
            }
            if (c == '\n') {
                this.mWriter.write("<br/>\n");
                continue;
            }
            if (c > '\u00ff') {
                this.mWriter.write("&#");
                this.mWriter.write(Integer.toString(c));
                this.mWriter.write(59);
                continue;
            }
            this.mWriter.write(c);
        }
    }

    private String stripPath(String path) {
        if (this.mStripPrefix != null && path.startsWith(this.mStripPrefix) && path.length() > this.mStripPrefix.length()) {
            int index = this.mStripPrefix.length();
            if (path.charAt(index) == File.separatorChar) {
                ++index;
            }
            return path.substring(index);
        }
        return path;
    }

    void setStripPrefix(String prefix) {
        this.mStripPrefix = prefix;
    }

    static URL getWarningIconUrl() {
        return HtmlReporter.class.getResource("lint-warning.png");
    }

    static URL getErrorIconUrl() {
        return HtmlReporter.class.getResource("lint-error.png");
    }
}

