/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.DdmConstants;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.ddms.UIThread;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.sdkstats.DdmsPreferenceStore;
import com.android.sdkstats.SdkStatsPermissionDialog;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class PrefsDialog {
    public static final String SHELL_X = "shellX";
    public static final String SHELL_Y = "shellY";
    public static final String SHELL_WIDTH = "shellWidth";
    public static final String SHELL_HEIGHT = "shellHeight";
    public static final String EXPLORER_SHELL_X = "explorerShellX";
    public static final String EXPLORER_SHELL_Y = "explorerShellY";
    public static final String EXPLORER_SHELL_WIDTH = "explorerShellWidth";
    public static final String EXPLORER_SHELL_HEIGHT = "explorerShellHeight";
    public static final String SHOW_NATIVE_HEAP = "native";
    public static final String LOGCAT_COLUMN_MODE = "ddmsLogColumnMode";
    public static final String LOGCAT_FONT = "ddmsLogFont";
    public static final String LOGCAT_COLUMN_MODE_AUTO = "auto";
    public static final String LOGCAT_COLUMN_MODE_MANUAL = "manual";
    private static final String PREFS_DEBUG_PORT_BASE = "adbDebugBasePort";
    private static final String PREFS_SELECTED_DEBUG_PORT = "debugSelectedPort";
    private static final String PREFS_DEFAULT_THREAD_UPDATE = "defaultThreadUpdateEnabled";
    private static final String PREFS_DEFAULT_HEAP_UPDATE = "defaultHeapUpdateEnabled";
    private static final String PREFS_THREAD_REFRESH_INTERVAL = "threadStatusInterval";
    private static final String PREFS_LOG_LEVEL = "ddmsLogLevel";
    private static final String PREFS_TIMEOUT = "timeOut";
    private static final String PREFS_PROFILER_BUFFER_SIZE_MB = "profilerBufferSizeMb";
    private static final String PREFS_USE_ADBHOST = "useAdbHost";
    private static final String PREFS_ADBHOST_VALUE = "adbHostValue";
    private static DdmsPreferenceStore mStore = new DdmsPreferenceStore();

    private PrefsDialog() {
    }

    @Deprecated
    public static PreferenceStore getStore() {
        return mStore.getPreferenceStore();
    }

    @Deprecated
    public static void save() {
        try {
            mStore.getPreferenceStore().save();
        }
        catch (IOException ioe) {
            Log.w("ddms", "Failed saving prefs file: " + ioe.getMessage());
        }
    }

    public static void init() {
        PreferenceStore prefStore = mStore.getPreferenceStore();
        if (prefStore == null) {
            Log.e("ddms", "failed to access both the user HOME directory and the system wide temp folder. Quitting.");
            System.exit(1);
        }
        PrefsDialog.setDefaults(System.getProperty("user.home"));
        prefStore.addPropertyChangeListener(new ChangeListener());
        DdmPreferences.setDebugPortBase(prefStore.getInt(PREFS_DEBUG_PORT_BASE));
        DdmPreferences.setSelectedDebugPort(prefStore.getInt(PREFS_SELECTED_DEBUG_PORT));
        DdmPreferences.setLogLevel(prefStore.getString(PREFS_LOG_LEVEL));
        DdmPreferences.setInitialThreadUpdate(prefStore.getBoolean(PREFS_DEFAULT_THREAD_UPDATE));
        DdmPreferences.setInitialHeapUpdate(prefStore.getBoolean(PREFS_DEFAULT_HEAP_UPDATE));
        DdmPreferences.setTimeOut(prefStore.getInt(PREFS_TIMEOUT));
        DdmPreferences.setProfilerBufferSizeMb(prefStore.getInt(PREFS_PROFILER_BUFFER_SIZE_MB));
        DdmPreferences.setUseAdbHost(prefStore.getBoolean(PREFS_USE_ADBHOST));
        DdmPreferences.setAdbHostValue(prefStore.getString(PREFS_ADBHOST_VALUE));
        String out = System.getenv("ANDROID_PRODUCT_OUT");
        DdmUiPreferences.setSymbolsLocation((String)(out + File.separator + "symbols"));
        DdmUiPreferences.setAddr2LineLocation((String)"arm-linux-androideabi-addr2line");
        DdmUiPreferences.setAddr2LineLocation64((String)"aarch64-linux-android-addr2line");
        String traceview = System.getProperty("com.android.ddms.bindir");
        traceview = traceview != null && traceview.length() != 0 ? traceview + File.separator + DdmConstants.FN_TRACEVIEW : DdmConstants.FN_TRACEVIEW;
        DdmUiPreferences.setTraceviewLocation((String)traceview);
        DdmUiPreferences.setStore((IPreferenceStore)prefStore);
        DdmUiPreferences.setThreadRefreshInterval((int)prefStore.getInt(PREFS_THREAD_REFRESH_INTERVAL));
    }

    private static void setDefaults(String homeDir) {
        PreferenceStore prefStore = mStore.getPreferenceStore();
        prefStore.setDefault(PREFS_DEBUG_PORT_BASE, 8600);
        prefStore.setDefault(PREFS_SELECTED_DEBUG_PORT, 8700);
        prefStore.setDefault(PREFS_USE_ADBHOST, false);
        prefStore.setDefault(PREFS_ADBHOST_VALUE, "127.0.0.1");
        prefStore.setDefault(PREFS_DEFAULT_THREAD_UPDATE, true);
        prefStore.setDefault(PREFS_DEFAULT_HEAP_UPDATE, false);
        prefStore.setDefault(PREFS_THREAD_REFRESH_INTERVAL, 4);
        prefStore.setDefault("textSaveDir", homeDir);
        prefStore.setDefault("imageSaveDir", homeDir);
        prefStore.setDefault(PREFS_LOG_LEVEL, "info");
        prefStore.setDefault(PREFS_TIMEOUT, 5000);
        prefStore.setDefault(PREFS_PROFILER_BUFFER_SIZE_MB, 8);
        FontData fdat = new FontData("Courier", 10, 0);
        prefStore.setDefault("textOutputFont", fdat.toString());
        prefStore.setDefault(SHELL_X, 100);
        prefStore.setDefault(SHELL_Y, 100);
        prefStore.setDefault(SHELL_WIDTH, 800);
        prefStore.setDefault(SHELL_HEIGHT, 600);
        prefStore.setDefault(EXPLORER_SHELL_X, 50);
        prefStore.setDefault(EXPLORER_SHELL_Y, 50);
        prefStore.setDefault(SHOW_NATIVE_HEAP, false);
    }

    public static void run(Shell shell) {
        PreferenceStore prefStore = mStore.getPreferenceStore();
        assert (prefStore != null);
        PreferenceManager prefMgr = new PreferenceManager();
        PreferenceNode node = new PreferenceNode("debugger", new DebuggerPrefs());
        prefMgr.addToRoot(node);
        PreferenceNode subNode = new PreferenceNode("panel", new PanelPrefs());
        prefMgr.addToRoot(subNode);
        node = new PreferenceNode("LogCat", new LogCatPrefs());
        prefMgr.addToRoot(node);
        node = new PreferenceNode("misc", new MiscPrefs());
        prefMgr.addToRoot(node);
        node = new PreferenceNode("stats", new UsageStatsPrefs());
        prefMgr.addToRoot(node);
        PreferenceDialog dlg = new PreferenceDialog(shell, prefMgr);
        dlg.setPreferenceStore(prefStore);
        try {
            dlg.open();
        }
        catch (Throwable t) {
            Log.e("ddms", t);
        }
        try {
            prefStore.save();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private static class UsageStatsPrefs
    extends PreferencePage {
        private BooleanFieldEditor mOptInCheckbox;
        private Composite mTop;

        public UsageStatsPrefs() {
            this.setTitle("Usage Stats");
        }

        @Override
        protected Control createContents(Composite parent) {
            this.mTop = new Composite(parent, 0);
            this.mTop.setLayout((Layout)new GridLayout(1, false));
            this.mTop.setLayoutData((Object)new GridData(1808));
            Label text = new Label(this.mTop, 64);
            text.setLayoutData((Object)new GridData(768));
            text.setText("By choosing to send certain usage statistics to Google, you can help us improve the Android SDK. These usage statistics lets us measure things like active usage of the SDK, and let us know things like which versions of the SDK are in use and which tools are the most popular with developers. This limited data is not associated with personal information about you, and is examined on an aggregate basis, and is maintained in accordance with the Google Privacy Policy.");
            Link privacyPolicyLink = new Link(this.mTop, 64);
            privacyPolicyLink.setText("<a href=\"http://www.google.com/intl/en/privacy.html\">Google Privacy Policy</a>");
            privacyPolicyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SdkStatsPermissionDialog.openUrl((String)event.text);
                }
            });
            this.mOptInCheckbox = new BooleanFieldEditor("pingOptIn", "Send usage statistics to Google.", this.mTop);
            this.mOptInCheckbox.setPage(this);
            this.mOptInCheckbox.setPreferenceStore(this.getPreferenceStore());
            this.mOptInCheckbox.load();
            return null;
        }

        @Override
        protected Point doComputeSize() {
            if (this.mTop != null) {
                return this.mTop.computeSize(450, -1, true);
            }
            return super.doComputeSize();
        }

        @Override
        protected void performDefaults() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.loadDefault();
            }
            super.performDefaults();
        }

        @Override
        public void performApply() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.store();
            }
            super.performApply();
        }

        @Override
        public boolean performOk() {
            if (this.mOptInCheckbox != null) {
                this.mOptInCheckbox.store();
            }
            return super.performOk();
        }
    }

    private static class MiscPrefs
    extends FieldEditorPreferencePage {
        public MiscPrefs() {
            super(0);
            this.setTitle("Misc");
        }

        @Override
        protected void createFieldEditors() {
            IntegerFieldEditor ife = new IntegerFieldEditor(PrefsDialog.PREFS_TIMEOUT, "ADB connection time out (ms):", this.getFieldEditorParent());
            this.addField(ife);
            ife = new IntegerFieldEditor(PrefsDialog.PREFS_PROFILER_BUFFER_SIZE_MB, "Profiler buffer size (MB):", this.getFieldEditorParent());
            this.addField(ife);
            DirectoryFieldEditor dfe = new DirectoryFieldEditor("textSaveDir", "Default text save dir:", this.getFieldEditorParent());
            this.addField(dfe);
            dfe = new DirectoryFieldEditor("imageSaveDir", "Default image save dir:", this.getFieldEditorParent());
            this.addField(dfe);
            FontFieldEditor ffe = new FontFieldEditor("textOutputFont", "Text output font:", this.getFieldEditorParent());
            this.addField(ffe);
            RadioGroupFieldEditor rgfe = new RadioGroupFieldEditor(PrefsDialog.PREFS_LOG_LEVEL, "Logging Level", 1, new String[][]{{"Verbose", Log.LogLevel.VERBOSE.getStringValue()}, {"Debug", Log.LogLevel.DEBUG.getStringValue()}, {"Info", Log.LogLevel.INFO.getStringValue()}, {"Warning", Log.LogLevel.WARN.getStringValue()}, {"Error", Log.LogLevel.ERROR.getStringValue()}, {"Assert", Log.LogLevel.ASSERT.getStringValue()}}, this.getFieldEditorParent(), true);
            this.addField(rgfe);
        }
    }

    private static class LogCatPrefs
    extends FieldEditorPreferencePage {
        public LogCatPrefs() {
            super(0);
            this.setTitle("Logcat");
        }

        @Override
        protected void createFieldEditors() {
            if (UIThread.useOldLogCatView()) {
                RadioGroupFieldEditor rgfe = new RadioGroupFieldEditor(PrefsDialog.LOGCAT_COLUMN_MODE, "Message Column Resizing Mode", 1, new String[][]{{"Manual", PrefsDialog.LOGCAT_COLUMN_MODE_MANUAL}, {"Automatic", PrefsDialog.LOGCAT_COLUMN_MODE_AUTO}}, this.getFieldEditorParent(), true);
                this.addField(rgfe);
                FontFieldEditor ffe = new FontFieldEditor(PrefsDialog.LOGCAT_FONT, "Text output font:", this.getFieldEditorParent());
                this.addField(ffe);
            } else {
                FontFieldEditor ffe = new FontFieldEditor("logcat.view.font", "Text output font:", this.getFieldEditorParent());
                this.addField(ffe);
                IntegerFieldEditor maxMessages = new IntegerFieldEditor("logcat.messagelist.max.size", "Maximum number of logcat messages to buffer", this.getFieldEditorParent());
                this.addField(maxMessages);
                BooleanFieldEditor autoScrollLock = new BooleanFieldEditor("logcat.view.auto-scroll-lock", "Automatically enable/disable scroll lock based on the scrollbar position", this.getFieldEditorParent());
                this.addField(autoScrollLock);
            }
        }
    }

    private static class PanelPrefs
    extends FieldEditorPreferencePage {
        public PanelPrefs() {
            super(0);
            this.setTitle("Info Panels");
        }

        @Override
        protected void createFieldEditors() {
            BooleanFieldEditor bfe = new BooleanFieldEditor(PrefsDialog.PREFS_DEFAULT_THREAD_UPDATE, "Thread updates enabled by default", this.getFieldEditorParent());
            this.addField(bfe);
            bfe = new BooleanFieldEditor(PrefsDialog.PREFS_DEFAULT_HEAP_UPDATE, "Heap updates enabled by default", this.getFieldEditorParent());
            this.addField(bfe);
            IntegerFieldEditor ife = new IntegerFieldEditor(PrefsDialog.PREFS_THREAD_REFRESH_INTERVAL, "Thread status interval (seconds):", this.getFieldEditorParent());
            ife.setValidRange(1, 60);
            this.addField(ife);
        }
    }

    private static class DebuggerPrefs
    extends FieldEditorPreferencePage {
        private BooleanFieldEditor mUseAdbHost;
        private StringFieldEditor mAdbHostValue;

        public DebuggerPrefs() {
            super(1);
            this.setTitle("Debugger");
        }

        @Override
        protected void createFieldEditors() {
            IntegerFieldEditor ife = new IntegerFieldEditor(PrefsDialog.PREFS_DEBUG_PORT_BASE, "Starting value for local port:", this.getFieldEditorParent());
            ife.setValidRange(1024, Short.MAX_VALUE);
            this.addField(ife);
            ife = new IntegerFieldEditor(PrefsDialog.PREFS_SELECTED_DEBUG_PORT, "Port of Selected VM:", this.getFieldEditorParent());
            ife.setValidRange(1024, Short.MAX_VALUE);
            this.addField(ife);
            this.mUseAdbHost = new BooleanFieldEditor(PrefsDialog.PREFS_USE_ADBHOST, "Use ADBHOST", this.getFieldEditorParent());
            this.addField(this.mUseAdbHost);
            this.mAdbHostValue = new StringFieldEditor(PrefsDialog.PREFS_ADBHOST_VALUE, "ADBHOST value:", this.getFieldEditorParent());
            this.mAdbHostValue.setEnabled(this.getPreferenceStore().getBoolean(PrefsDialog.PREFS_USE_ADBHOST), this.getFieldEditorParent());
            this.addField(this.mAdbHostValue);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource().equals(this.mUseAdbHost)) {
                this.mAdbHostValue.setEnabled(this.mUseAdbHost.getBooleanValue(), this.getFieldEditorParent());
            }
            super.propertyChange(event);
        }
    }

    private static class ChangeListener
    implements IPropertyChangeListener {
        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String changed = event.getProperty();
            PreferenceStore prefStore = mStore.getPreferenceStore();
            if (changed.equals(PrefsDialog.PREFS_DEBUG_PORT_BASE)) {
                DdmPreferences.setDebugPortBase(prefStore.getInt(PrefsDialog.PREFS_DEBUG_PORT_BASE));
            } else if (changed.equals(PrefsDialog.PREFS_SELECTED_DEBUG_PORT)) {
                DdmPreferences.setSelectedDebugPort(prefStore.getInt(PrefsDialog.PREFS_SELECTED_DEBUG_PORT));
            } else if (changed.equals(PrefsDialog.PREFS_LOG_LEVEL)) {
                DdmPreferences.setLogLevel((String)event.getNewValue());
            } else if (changed.equals("textSaveDir")) {
                prefStore.setValue("lastTextSaveDir", (String)event.getNewValue());
            } else if (changed.equals("imageSaveDir")) {
                prefStore.setValue("lastImageSaveDir", (String)event.getNewValue());
            } else if (changed.equals(PrefsDialog.PREFS_TIMEOUT)) {
                DdmPreferences.setTimeOut(prefStore.getInt(PrefsDialog.PREFS_TIMEOUT));
            } else if (changed.equals(PrefsDialog.PREFS_PROFILER_BUFFER_SIZE_MB)) {
                DdmPreferences.setProfilerBufferSizeMb(prefStore.getInt(PrefsDialog.PREFS_PROFILER_BUFFER_SIZE_MB));
            } else if (changed.equals(PrefsDialog.PREFS_USE_ADBHOST)) {
                DdmPreferences.setUseAdbHost(prefStore.getBoolean(PrefsDialog.PREFS_USE_ADBHOST));
            } else if (changed.equals(PrefsDialog.PREFS_ADBHOST_VALUE)) {
                DdmPreferences.setAdbHostValue(prefStore.getString(PrefsDialog.PREFS_ADBHOST_VALUE));
            } else {
                Log.v("ddms", "Preference change: " + event.getProperty() + ": '" + event.getOldValue() + "' --> '" + event.getNewValue() + "'");
            }
        }
    }
}

